/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.media.MediaLocator;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.CaptureDevices;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.impl.neomedia.device.Devices;
import org.jitsi.impl.neomedia.device.NotifyDevices;
import org.jitsi.impl.neomedia.device.PlaybackDevices;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.Logger;

public abstract class AudioSystem
extends DeviceSystem {
    public static final int FEATURE_AGC = 16;
    public static final int FEATURE_DENOISE = 2;
    public static final int FEATURE_ECHO_CANCELLATION = 4;
    public static final int FEATURE_NOTIFY_AND_PLAYBACK_DEVICES = 8;
    public static final String LOCATOR_PROTOCOL_AUDIORECORD = "audiorecord";
    public static final String LOCATOR_PROTOCOL_AUDIOSILENCE = "audiosilence";
    public static final String LOCATOR_PROTOCOL_JAVASOUND = "javasound";
    public static final String LOCATOR_PROTOCOL_MACCOREAUDIO = "maccoreaudio";
    public static final String LOCATOR_PROTOCOL_OPENSLES = "opensles";
    public static final String LOCATOR_PROTOCOL_PORTAUDIO = "portaudio";
    public static final String LOCATOR_PROTOCOL_PULSEAUDIO = "pulseaudio";
    public static final String LOCATOR_PROTOCOL_WASAPI = "wasapi";
    private static Logger logger = Logger.getLogger(AudioSystem.class);
    private static final String PNAME_AGC = "automaticgaincontrol";
    protected static final String PNAME_DENOISE = "denoise";
    protected static final String PNAME_ECHOCANCEL = "echocancel";
    private Devices[] devices;

    public static AudioSystem getAudioSystem(String locatorProtocol) {
        AudioSystem[] audioSystems = AudioSystem.getAudioSystems();
        AudioSystem audioSystemWithLocatorProtocol = null;
        if (audioSystems != null) {
            for (AudioSystem audioSystem : audioSystems) {
                if (!audioSystem.getLocatorProtocol().equalsIgnoreCase(locatorProtocol)) continue;
                audioSystemWithLocatorProtocol = audioSystem;
                break;
            }
        }
        return audioSystemWithLocatorProtocol;
    }

    public static AudioSystem[] getAudioSystems() {
        ArrayList<AudioSystem> audioSystems;
        DeviceSystem[] deviceSystems = DeviceSystem.getDeviceSystems(MediaType.AUDIO);
        if (deviceSystems == null) {
            audioSystems = null;
        } else {
            audioSystems = new ArrayList<AudioSystem>(deviceSystems.length);
            for (DeviceSystem deviceSystem : deviceSystems) {
                if (!(deviceSystem instanceof AudioSystem)) continue;
                audioSystems.add((AudioSystem)deviceSystem);
            }
        }
        return audioSystems == null ? null : audioSystems.toArray(new AudioSystem[audioSystems.size()]);
    }

    protected AudioSystem(String locatorProtocol) throws Exception {
        this(locatorProtocol, 0);
    }

    protected AudioSystem(String locatorProtocol, int features) throws Exception {
        super(MediaType.AUDIO, locatorProtocol, features);
    }

    @Override
    public Renderer createRenderer() {
        return this.createRenderer(true);
    }

    public Renderer createRenderer(boolean playback) {
        Renderer renderer;
        String className = this.getRendererClassName();
        if (className == null) {
            renderer = null;
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                clazz = null;
                logger.error((Object)("Failed to get class " + className), t);
            }
            if (clazz == null) {
                renderer = null;
            } else if (!Renderer.class.isAssignableFrom(clazz)) {
                renderer = null;
            } else {
                boolean superCreateRenderer;
                if ((this.getFeatures() & 8) != 0 && AbstractAudioRenderer.class.isAssignableFrom(clazz)) {
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz.getConstructor(Boolean.TYPE);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (constructor != null) {
                        superCreateRenderer = false;
                        try {
                            renderer = (Renderer)constructor.newInstance(playback);
                        }
                        catch (Throwable t) {
                            if (t instanceof ThreadDeath) {
                                throw (ThreadDeath)t;
                            }
                            renderer = null;
                            logger.error((Object)("Failed to initialize a new " + className + " instance"), t);
                        }
                        if (renderer != null && !playback) {
                            CaptureDeviceInfo2 device = this.getSelectedDevice(DataFlow.NOTIFY);
                            if (device == null) {
                                renderer = null;
                            } else {
                                MediaLocator locator = device.getLocator();
                                if (locator != null) {
                                    ((AbstractAudioRenderer)renderer).setLocator(locator);
                                }
                            }
                        }
                    } else {
                        superCreateRenderer = true;
                        renderer = null;
                    }
                } else {
                    superCreateRenderer = true;
                    renderer = null;
                }
                if (superCreateRenderer && renderer == null) {
                    renderer = super.createRenderer();
                }
            }
        }
        return renderer;
    }

    public InputStream getAudioInputStream(String uri) throws IOException {
        ResourceManagementService resources = LibJitsi.getResourceManagementService();
        URL url = resources == null ? null : resources.getSoundURLForPath(uri);
        AudioInputStream audioStream = null;
        try {
            if (url == null) {
                url = new URL(uri);
            }
            audioStream = javax.sound.sampled.AudioSystem.getAudioInputStream(url);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (UnsupportedAudioFileException uafe) {
            logger.error((Object)("Unsupported format of audio stream " + url), (Throwable)uafe);
        }
        return audioStream;
    }

    public CaptureDeviceInfo2 getDevice(DataFlow dataFlow, MediaLocator locator) {
        return this.devices[dataFlow.ordinal()].getDevice(locator);
    }

    public List<CaptureDeviceInfo2> getDevices(DataFlow dataFlow) {
        return this.devices[dataFlow.ordinal()].getDevices();
    }

    public AudioFormat getFormat(InputStream audioInputStream) {
        if (audioInputStream instanceof AudioInputStream) {
            javax.sound.sampled.AudioFormat af = ((AudioInputStream)audioInputStream).getFormat();
            return new AudioFormat("LINEAR", (double)af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels());
        }
        return null;
    }

    protected String getPropertyName(String basePropertyName) {
        return "net.java.sip.communicator.impl.neomedia.audioSystem." + this.getLocatorProtocol() + "." + basePropertyName;
    }

    public CaptureDeviceInfo2 getSelectedDevice(DataFlow dataFlow) {
        return this.devices[dataFlow.ordinal()].getSelectedDevice(this.getDevices(dataFlow));
    }

    public boolean isAutomaticGainControl() {
        boolean value;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean bl = value = (this.getFeatures() & 0x10) == 16;
        if (cfg != null) {
            value = cfg.getBoolean(this.getPropertyName(PNAME_AGC), value);
        }
        return value;
    }

    public boolean isDenoise() {
        boolean value;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean bl = value = (this.getFeatures() & 2) == 2;
        if (cfg != null) {
            value = cfg.getBoolean(this.getPropertyName(PNAME_DENOISE), value);
        }
        return value;
    }

    public boolean isEchoCancel() {
        boolean value;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean bl = value = (this.getFeatures() & 4) == 4;
        if (cfg != null) {
            value = cfg.getBoolean(this.getPropertyName(PNAME_ECHOCANCEL), value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postInitialize() throws Exception {
        try {
            try {
                this.postInitializeSpecificDevices(DataFlow.CAPTURE);
            }
            finally {
                if ((8 & this.getFeatures()) != 0) {
                    try {
                        this.postInitializeSpecificDevices(DataFlow.NOTIFY);
                    }
                    finally {
                        this.postInitializeSpecificDevices(DataFlow.PLAYBACK);
                    }
                }
            }
        }
        finally {
            super.postInitialize();
        }
    }

    protected void postInitializeSpecificDevices(DataFlow dataFlow) {
        List<CaptureDeviceInfo2> activeDevices = this.getDevices(dataFlow);
        Devices devices = this.devices[dataFlow.ordinal()];
        CaptureDeviceInfo2 selectedActiveDevice = devices.getSelectedDevice(activeDevices);
        devices.setDevice(selectedActiveDevice, false);
    }

    @Override
    protected void preInitialize() throws Exception {
        super.preInitialize();
        if (this.devices == null) {
            this.devices = new Devices[3];
            this.devices[DataFlow.CAPTURE.ordinal()] = new CaptureDevices(this);
            this.devices[DataFlow.NOTIFY.ordinal()] = new NotifyDevices(this);
            this.devices[DataFlow.PLAYBACK.ordinal()] = new PlaybackDevices(this);
        }
    }

    void propertyChange(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    public void setAutomaticGainControl(boolean automaticGainControl) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            cfg.setProperty(this.getPropertyName(PNAME_AGC), automaticGainControl);
        }
    }

    protected void setCaptureDevices(List<CaptureDeviceInfo2> captureDevices) {
        this.devices[DataFlow.CAPTURE.ordinal()].setDevices(captureDevices);
    }

    public void setDenoise(boolean denoise) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            cfg.setProperty(this.getPropertyName(PNAME_DENOISE), denoise);
        }
    }

    public void setDevice(DataFlow dataFlow, CaptureDeviceInfo2 device, boolean save) {
        this.devices[dataFlow.ordinal()].setDevice(device, save);
    }

    public void setEchoCancel(boolean echoCancel) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            cfg.setProperty(this.getPropertyName(PNAME_ECHOCANCEL), echoCancel);
        }
    }

    protected void setPlaybackDevices(List<CaptureDeviceInfo2> playbackDevices) {
        this.devices[DataFlow.PLAYBACK.ordinal()].setDevices(playbackDevices);
        this.devices[DataFlow.NOTIFY.ordinal()].setDevices(playbackDevices);
    }

    public static enum DataFlow {
        CAPTURE,
        NOTIFY,
        PLAYBACK;

    }
}

