/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.concurrency;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;

public abstract class LazyReference<V, E extends Exception> {
    private V reference;
    private final Semaphore firstGetter = new Semaphore(1);
    private final CountDownLatch initialized = new CountDownLatch(1);

    public V get() throws E, InterruptedException {
        if (this.firstGetter.tryAcquire()) {
            try {
                this.reference = this.newInstance();
            }
            finally {
                this.initialized.countDown();
            }
        }
        this.initialized.await();
        if (this.reference == null) {
            throw new NullPointerException("newInstance() returned null");
        }
        return this.reference;
    }

    public abstract V newInstance() throws E;
}

