/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.KlibModuleRef;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "extractKlibFromZip", "Ljava/io/File;", "library", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "loadIrLibrary", "Lorg/jetbrains/kotlin/ir/backend/js/KlibModuleRef;", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "Companion", "cli"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    private final CommonCompilerPerformanceManager performanceManager = new CommonCompilerPerformanceManager("Kotlin to JS (IR) Compiler"){};
    private static final Map<String, ModuleKind> moduleKindMap;
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    private static final Map<String, ProduceKind> produceMap;
    public static final Companion Companion;

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File extractKlibFromZip(String library, MessageCollector messageCollector) {
        ZipFile zipLib = new ZipFile(library);
        String string = new File(library).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(library).name");
        File tempDir = FilesKt.createTempDir$default((String)string, (String)"klibjar", null, (int)4, null);
        tempDir.deleteOnExit();
        File extractedKlibDir = null;
        Iterator iterator2 = CollectionsKt.iterator(zipLib.entries());
        while (iterator2.hasNext()) {
            ZipEntry entry;
            ZipEntry zipEntry = entry = (ZipEntry)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
            if (!zipEntry.isDirectory()) {
                Closeable closeable = zipLib.getInputStream(entry);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    long l;
                    InputStream input = (InputStream)closeable;
                    boolean bl2 = false;
                    File outputEntryFile = new File(tempDir, entry.getName());
                    outputEntryFile.getParentFile().mkdirs();
                    Object object = outputEntryFile;
                    boolean bl3 = false;
                    object = new FileOutputStream((File)object);
                    bl3 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)object;
                        boolean bl4 = false;
                        InputStream inputStream = input;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
                        l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                    long l2 = l;
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            String string2 = entry.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
            if (!StringsKt.endsWith$default((String)string2, (String)"KLIB/", (boolean)false, (int)2, null)) continue;
            extractedKlibDir = new File(tempDir, entry.getName());
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Klib " + library + " is extracted into " + extractedKlibDir, null, 4, null);
        }
        return extractedKlibDir;
    }

    private final KlibModuleRef loadIrLibrary(String library, MessageCollector messageCollector) {
        File metadataFile;
        File klibDir;
        block10: {
            File file2;
            File klibDirInsideDir;
            int n;
            File[] klibFiles;
            block9: {
                File file3;
                File file4;
                File libraryFile = new File(library);
                if (FileUtil.isJarOrZip(libraryFile)) {
                    file4 = this.extractKlibFromZip(library, messageCollector);
                    if (file4 == null) {
                        return null;
                    }
                } else {
                    if (!libraryFile.isDirectory()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Klib " + library + " must be a directory", null, 4, null);
                        return null;
                    }
                    file4 = libraryFile;
                }
                klibDir = file4;
                klibFiles = klibDir.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)klibFiles, (String)"klibFiles");
                File[] fileArray = klibFiles;
                boolean bl = false;
                if (fileArray.length == 0) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, "Klib " + library + " directory is empty", null, 4, null);
                    return null;
                }
                File[] fileArray2 = klibFiles;
                boolean bl2 = false;
                File[] fileArray3 = fileArray2;
                boolean bl3 = false;
                File[] fileArray4 = fileArray3;
                int n2 = fileArray4.length;
                for (n = 0; n < n2; ++n) {
                    File file5;
                    File it = file5 = fileArray4[n];
                    boolean bl4 = false;
                    File file6 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"it");
                    String string = file6.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                    if (!StringsKt.endsWith$default((String)string, (String)"KLIB", (boolean)false, (int)2, null)) continue;
                    file3 = file5;
                    break block9;
                }
                file3 = klibDirInsideDir = null;
            }
            if (klibDirInsideDir != null) {
                klibDir = klibDirInsideDir;
                klibFiles = klibDir.listFiles();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)klibFiles, (String)"klibFiles");
            File[] fileArray = klibFiles;
            boolean bl = false;
            File[] fileArray5 = fileArray;
            boolean bl5 = false;
            File[] fileArray6 = fileArray5;
            n = fileArray6.length;
            for (int i = 0; i < n; ++i) {
                File file7;
                File it = file7 = fileArray6[i];
                boolean bl6 = false;
                File file8 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"it");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file8), (Object)"klm")) continue;
                file2 = file7;
                break block10;
            }
            file2 = metadataFile = null;
        }
        if (metadataFile == null) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, "No metadata file (.klm) for klib: " + klibDir, null, 4, null);
            return null;
        }
        String string = FilesKt.getNameWithoutExtension(metadataFile);
        String string2 = klibDir.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"klibDir.absolutePath");
        return new KlibModuleRef(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        ExitCode pluginLoadResult = PluginCliParser.loadPluginsSafe(arguments2.getPluginClasspaths(), arguments2.getPluginOptions(), configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        List libraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries());
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        Object[] commonSourcesArray = arguments2.getCommonSources();
        Object object = commonSourcesArray;
        if (commonSourcesArray == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = SetsKt.emptySet();
        }
        Object commonSources = object;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "No source files", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String string = FileUtil.getNameWithoutExtension(outputFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getNameWithoutExtension(outputFile)");
        configuration.put(CommonConfigurationKeys.MODULE_NAME, string);
        JsConfig config = new JsConfig(project, configuration);
        File file2 = outputFile.getParentFile();
        if (file2 == null) {
            File file3 = outputFile.getAbsoluteFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputFile.absoluteFile");
            file2 = file3.getParentFile();
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
        }
        File outputDir2 = file2;
        try {
            CompilerConfiguration compilerConfiguration = config.getConfiguration();
            File file4 = outputDir2.getCanonicalFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"outputDir.canonicalFile");
            compilerConfiguration.put(JSConfigurationKeys.OUTPUT_DIR, file4);
        }
        catch (IOException e) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual((Object)"noCall", (Object)arguments2.getMain()) ? null : CollectionsKt.emptyList();
        Iterable $this$flatMap$iv = libraries;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object)this.loadIrLibrary(it, messageCollector));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KlibModuleRef it = (KlibModuleRef)e$iv;
            boolean bl = false;
            String key$iv = it.getModuleName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List dependencies2 = list$iv;
        ProduceKind produceKind = produceMap.get(arguments2.getIrProduceOnly());
        if (produceKind == null) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Unknown produce kind: " + arguments2.getIrProduceOnly() + ". Valid values are: js, klib", null, 4, null);
        }
        if (produceKind == ProduceKind.JS || produceKind == ProduceKind.DEFAULT) {
            String compiledModule = CompilerKt.compile$default(project, sourcesFiles, configuration, null, dependencies2, dependencies2, mainCallArguments, 8, null);
            FilesKt.writeText$default((File)outputFile, (String)compiledModule, null, (int)2, null);
        }
        if (produceKind == ProduceKind.KLIB || produceKind == ProduceKind.DEFAULT && arguments2.getMetaInfo()) {
            String outputKlibPath = outputFilePath + ".KLIB";
            Project project2 = config.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"config.project");
            CompilerConfiguration compilerConfiguration = config.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
            KlibKt.generateKLib(project2, sourcesFiles, compilerConfiguration, dependencies2, dependencies2, outputKlibPath);
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        IncrementalResultsConsumer incrementalResultsConsumer;
        String moduleKindName;
        ModuleKind moduleKind;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual((Object)"v5", (Object)arguments2.getTarget());
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Unsupported ECMA version: ");
                String string = arguments2.getTarget();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = stringBuilder.append(string).toString();
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22));
            }
        }
        EcmaVersion ecmaVersion = EcmaVersion.defaultVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ecmaVersion), (String)"EcmaVersion.defaultVersion()");
        configuration.put(JSConfigurationKeys.TARGET, ecmaVersion);
        if (arguments2.getSourceMap()) {
            messageCollector.report(CompilerMessageSeverity.WARNING, "source-map argument is not supported yet", null);
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = friendModules;
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
            String string2 = string;
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string2.split($i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl3 = false;
                    CharSequence charSequence = it;
                    int n2 = 0;
                    if (charSequence.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            if ($this$toTypedArray$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (CharSequence element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                CharSequence charSequence = it;
                boolean bl5 = false;
                if (charSequence.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        IncrementalDataProvider incrementalDataProvider = services.get(IncrementalDataProvider.class);
        if (incrementalDataProvider != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, incrementalDataProvider);
        }
        if ((incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class)) != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, incrementalResultsConsumer);
        }
        if ((lookupTracker = services.get(LookupTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, lookupTracker);
        }
        if ((expectActualTracker = services.get(ExpectActualTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, expectActualTracker);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection<String>)sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-js -Xir";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkParameterIsNotNull((Object)versionArray, (String)"versionArray");
        return new JsMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    static {
        Companion = new Companion(null);
        moduleKindMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD))});
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))});
        produceMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(null, (Object)((Object)ProduceKind.DEFAULT)), TuplesKt.to((Object)"js", (Object)((Object)ProduceKind.JS)), TuplesKt.to((Object)"klib", (Object)((Object)ProduceKind.KLIB))});
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                String string = virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : file2.getName() + " (no virtual file)";
                collection.add(string);
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + org.jetbrains.kotlin.utils.StringsKt.join(fileNames, ", "), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            Object object = libraryString;
            if (object == null || (object = this.splitByPathSeparator((String)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(@NotNull String $receiver) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence = $receiver;
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
            String string2 = string;
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string2.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    int n2 = 0;
                    if (charSequence2.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            if ($this$toTypedArray$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (CharSequence element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                CharSequence charSequence3 = it;
                boolean bl4 = false;
                if (charSequence3.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

