/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.intrinsics.AndAnd;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayGet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySize;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BinaryOp;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Clone;
import org.jetbrains.kotlin.backend.jvm.intrinsics.CompareTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.HashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Increment;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Inv;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrEnumValueOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIllegalArgumentException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrNoWhenBranchMatchedException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IteratorNext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NewArray;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NumberCast;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.RangeTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringGetChar;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowNPE;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ToString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0003'()B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00190\u0018H\u0002J*\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J*\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00190\u00182\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$J\u001a\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00190\u0018H\u0002J*\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;)V", "KOTLIN_INTERNAL_IR", "Lorg/jetbrains/kotlin/name/FqName;", "KOTLIN_JVM", "KOTLIN_JVM_INTERNAL_UNSAFE", "andandSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getAndandSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "intrinsicsMap", "", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "arrayMethods", "", "Lkotlin/Pair;", "binaryFunForPrimitives", "name", "", "intrinsic", "binaryOp", "methodName", "opcode", "", "getIntrinsic", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "numberConversionMethods", "unaryFunForPrimitives", "Companion", "Key", "OperatorNames", "backend.jvm"})
public final class IrIntrinsicMethods {
    private final FqName KOTLIN_INTERNAL_IR;
    private final FqName KOTLIN_JVM;
    private final FqName KOTLIN_JVM_INTERNAL_UNSAFE;
    @NotNull
    private final IrSimpleFunctionSymbol andandSymbol;
    private final Map<Key, IntrinsicMethod> intrinsicsMap;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    private static final Increment INC;
    private static final Increment DEC;
    private static final Equals EQUALS;
    public static final Companion Companion;

    @NotNull
    public final IrSimpleFunctionSymbol getAndandSymbol() {
        return this.andandSymbol;
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkParameterIsNotNull((Object)symbol2, (String)"symbol");
        return this.intrinsicsMap.get(IrIntrinsicMethods.Companion.toKey(symbol2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> unaryFunForPrimitives(String name, IntrinsicMethod intrinsic) {
        void $this$flatMapTo$iv$iv;
        PrimitiveType[] $this$flatMap$iv = PrimitiveType.values();
        boolean $i$f$flatMap = false;
        PrimitiveType[] primitiveTypeArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var8_8 = $this$flatMapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void type2 = element$iv$iv = var8_8[i];
            boolean bl = false;
            IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get(type2);
            if (irType == null) {
                Intrinsics.throwNpe();
            }
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            if (irClassSymbol == null) {
                Intrinsics.throwNpe();
            }
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.methodWithArity(irClassSymbol, name, 0, intrinsic);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitives(String name, IntrinsicMethod intrinsic) {
        void $this$flatMapTo$iv$iv;
        PrimitiveType[] $this$flatMap$iv = PrimitiveType.values();
        boolean $i$f$flatMap = false;
        PrimitiveType[] primitiveTypeArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var8_8 = $this$flatMapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void type2 = element$iv$iv = var8_8[i];
            boolean bl = false;
            IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get(type2);
            if (irType == null) {
                Intrinsics.throwNpe();
            }
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            if (irClassSymbol == null) {
                Intrinsics.throwNpe();
            }
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.methodWithArity(irClassSymbol, name, 1, intrinsic);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Pair<Key, IntrinsicMethod>> binaryOp(String methodName, int opcode) {
        return this.binaryFunForPrimitives(methodName, new BinaryOp(opcode));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods() {
        void $this$flatMapTo$iv$iv;
        Set<PrimitiveType> set = PrimitiveType.NUMBER_TYPES;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"PrimitiveType.NUMBER_TYPES");
        Iterable $this$flatMap$iv = set;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PrimitiveType type2 = (PrimitiveType)((Object)element$iv$iv);
            boolean bl = false;
            IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get((Object)type2);
            if (irType == null) {
                Intrinsics.throwNpe();
            }
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            if (irClassSymbol == null) {
                Intrinsics.throwNpe();
            }
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.numberConversionMethods(irClassSymbol);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)IrIntrinsicMethods.Companion.numberConversionMethods(this.irBuiltIns.getNumberClass()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> arrayMethods() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.symbols.getPrimitiveArrays().values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrClassSymbol it = (IrClassSymbol)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.arrayMethods(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)IrIntrinsicMethods.Companion.arrayMethods(this.symbols.getArray()));
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final JvmSymbols getSymbols() {
        return this.symbols;
    }

    /*
     * WARNING - void declaration
     */
    public IrIntrinsicMethods(@NotNull IrBuiltIns irBuiltIns, @NotNull JvmSymbols symbols2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkParameterIsNotNull((Object)symbols2, (String)"symbols");
        this.irBuiltIns = irBuiltIns;
        this.symbols = symbols2;
        this.KOTLIN_INTERNAL_IR = new FqName("kotlin.internal.ir");
        this.KOTLIN_JVM = new FqName("kotlin.jvm");
        this.KOTLIN_JVM_INTERNAL_UNSAFE = new FqName("kotlin.jvm.internal.unsafe");
        Object object = this.irBuiltIns;
        IrIntrinsicMethods irIntrinsicMethods = this;
        boolean bl = false;
        boolean bl2 = false;
        IrBuiltIns $this$run = object;
        boolean bl3 = false;
        Object object2 = $this$run.defineOperator("ANDAND", $this$run.getBool(), CollectionsKt.listOf((Object[])new SimpleType[]{$this$run.getBool(), $this$run.getBool()}));
        irIntrinsicMethods.andandSymbol = object2;
        Object[] objectArray = new Pair[19];
        objectArray[0] = TuplesKt.to((Object)new Key(this.KOTLIN_JVM, new FqName("T"), "<get-javaClass>", CollectionsKt.emptyList()), (Object)JavaClassProperty.INSTANCE);
        objectArray[1] = TuplesKt.to((Object)new Key(this.KOTLIN_JVM, KotlinBuiltIns.FQ_NAMES.kClass.toSafe(), "<get-java>", CollectionsKt.emptyList()), (Object)KClassJavaProperty.INSTANCE);
        objectArray[2] = TuplesKt.to((Object)new Key(this.KOTLIN_JVM_INTERNAL_UNSAFE, null, "monitorEnter", CollectionsKt.listOf((Object)KotlinBuiltIns.FQ_NAMES.any.toSafe())), (Object)MonitorInstruction.MONITOR_ENTER);
        objectArray[3] = TuplesKt.to((Object)new Key(this.KOTLIN_JVM_INTERNAL_UNSAFE, null, "monitorExit", CollectionsKt.listOf((Object)KotlinBuiltIns.FQ_NAMES.any.toSafe())), (Object)MonitorInstruction.MONITOR_EXIT);
        objectArray[4] = TuplesKt.to((Object)new Key(this.KOTLIN_JVM, KotlinBuiltIns.FQ_NAMES.array.toSafe(), "isArrayOf", CollectionsKt.emptyList()), (Object)IsArrayOf.INSTANCE);
        objectArray[5] = TuplesKt.to((Object)IrIntrinsicMethods.Companion.toKey(this.symbols.getArrayOf()), (Object)ArrayOf.INSTANCE);
        FqName fqName2 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        objectArray[6] = TuplesKt.to((Object)new Key(fqName2, KotlinBuiltIns.FQ_NAMES.any.toSafe(), "toString", CollectionsKt.emptyList()), (Object)ToString.INSTANCE);
        FqName fqName3 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        objectArray[7] = TuplesKt.to((Object)new Key(fqName3, null, "arrayOfNulls", CollectionsKt.listOf((Object)KotlinBuiltIns.FQ_NAMES._int.toSafe())), (Object)NewArray.INSTANCE);
        FqName fqName4 = KotlinBuiltIns.FQ_NAMES.cloneable.toSafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"KotlinBuiltIns.FQ_NAMES.cloneable.toSafe()");
        objectArray[8] = TuplesKt.to((Object)new Key(fqName4, null, "clone", CollectionsKt.emptyList()), (Object)Clone.INSTANCE);
        objectArray[9] = TuplesKt.to((Object)new Key(this.KOTLIN_INTERNAL_IR, null, "ANDAND", CollectionsKt.listOf((Object[])new FqName[]{KotlinBuiltIns.FQ_NAMES._boolean.toSafe(), KotlinBuiltIns.FQ_NAMES._boolean.toSafe()})), (Object)AndAnd.INSTANCE);
        Key key = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqSymbol());
        if (key == null) {
            Intrinsics.throwNpe();
        }
        KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken, (String)"KtTokens.EQEQ");
        objectArray[10] = TuplesKt.to((Object)key, (Object)new Equals(ktSingleValueToken));
        Key key2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqeqSymbol());
        if (key2 == null) {
            Intrinsics.throwNpe();
        }
        KtSingleValueToken ktSingleValueToken2 = KtTokens.EQEQEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken2, (String)"KtTokens.EQEQEQ");
        objectArray[11] = TuplesKt.to((Object)key2, (Object)new Equals(ktSingleValueToken2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getFloat());
        if (irSimpleFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        Key key3 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol);
        if (key3 == null) {
            Intrinsics.throwNpe();
        }
        Type type2 = Type.FLOAT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.FLOAT_TYPE");
        objectArray[12] = TuplesKt.to((Object)key3, (Object)new Ieee754Equals(type2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getDouble());
        if (irSimpleFunctionSymbol2 == null) {
            Intrinsics.throwNpe();
        }
        Key key4 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol2);
        if (key4 == null) {
            Intrinsics.throwNpe();
        }
        Type type3 = Type.DOUBLE_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.DOUBLE_TYPE");
        objectArray[13] = TuplesKt.to((Object)key4, (Object)new Ieee754Equals(type3));
        Key key5 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getBooleanNotSymbol());
        if (key5 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[14] = TuplesKt.to((Object)key5, (Object)Not.INSTANCE);
        Key key6 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEnumValueOfSymbol());
        if (key6 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[15] = TuplesKt.to((Object)key6, (Object)IrEnumValueOf.INSTANCE);
        Key key7 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getNoWhenBranchMatchedExceptionSymbol());
        if (key7 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[16] = TuplesKt.to((Object)key7, (Object)IrNoWhenBranchMatchedException.INSTANCE);
        Key key8 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getIllegalArgumentExceptionSymbol());
        if (key8 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[17] = TuplesKt.to((Object)key8, (Object)IrIllegalArgumentException.INSTANCE);
        Key key9 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getThrowNpeSymbol());
        if (key9 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[18] = TuplesKt.to((Object)key9, (Object)ThrowNPE.INSTANCE);
        object = this.symbols.getPrimitiveArrayOfByType().values();
        object2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)this.numberConversionMethods()), (Iterable)this.unaryFunForPrimitives("plus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryPlus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("minus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryMinus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inv", Inv.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inc", INC)), (Iterable)this.unaryFunForPrimitives("dec", DEC)), (Iterable)this.unaryFunForPrimitives("hashCode", HashCode.INSTANCE)), (Iterable)this.unaryFunForPrimitives("toString", ToString.INSTANCE)), (Iterable)this.binaryFunForPrimitives("equals", EQUALS));
        irIntrinsicMethods = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = (IrSimpleFunctionSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            Pair pair = TuplesKt.to((Object)IrIntrinsicMethods.Companion.toKey((IrFunctionSymbol)it), (Object)ArrayOf.INSTANCE);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.symbols.getPrimitiveIteratorsByType().values();
        object2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)object2, (Iterable)collection), (Iterable)this.binaryFunForPrimitives("rangeTo", RangeTo.INSTANCE)), (Iterable)this.binaryOp("plus", 96)), (Iterable)this.binaryOp("minus", 100)), (Iterable)this.binaryOp("times", 104)), (Iterable)this.binaryOp("div", 108)), (Iterable)this.binaryOp("mod", 112)), (Iterable)this.binaryOp("rem", 112)), (Iterable)this.binaryOp("shl", 120)), (Iterable)this.binaryOp("shr", 122)), (Iterable)this.binaryOp("ushr", 124)), (Iterable)this.binaryOp("and", 126)), (Iterable)this.binaryOp("or", 128)), (Iterable)this.binaryOp("xor", 130)), (Iterable)this.binaryFunForPrimitives("compareTo", CompareTo.INSTANCE)), (Iterable)IrIntrinsicMethods.Companion.methodWithArity(this.irBuiltIns.getBooleanClass(), "not", 0, Not.INSTANCE)), (Iterable)IrIntrinsicMethods.Companion.methodWithArity(this.irBuiltIns.getStringClass(), "get", 1, StringGetChar.INSTANCE));
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrClassSymbol iteratorClass = (IrClassSymbol)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.methodWithArity(iteratorClass, "next", 0, IteratorNext.INSTANCE);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)object2, (Iterable)collection), (Iterable)this.arrayMethods());
        Map<SimpleType, IrSimpleFunctionSymbol> map2 = this.irBuiltIns.getLessFunByOperandType();
        KtSingleValueToken ktSingleValueToken3 = KtTokens.LT;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken3, (String)"KtTokens.LT");
        Collection collection3 = CollectionsKt.plus((Collection)collection2, (Iterable)IrIntrinsicMethods.Companion.primitiveComparisonIntrinsics(map2, ktSingleValueToken3));
        Map<SimpleType, IrSimpleFunctionSymbol> map3 = this.irBuiltIns.getLessOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LTEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken4, (String)"KtTokens.LTEQ");
        Collection collection4 = CollectionsKt.plus((Collection)collection3, (Iterable)IrIntrinsicMethods.Companion.primitiveComparisonIntrinsics(map3, ktSingleValueToken4));
        Map<SimpleType, IrSimpleFunctionSymbol> map4 = this.irBuiltIns.getGreaterFunByOperandType();
        KtSingleValueToken ktSingleValueToken5 = KtTokens.GT;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken5, (String)"KtTokens.GT");
        Collection collection5 = CollectionsKt.plus((Collection)collection4, (Iterable)IrIntrinsicMethods.Companion.primitiveComparisonIntrinsics(map4, ktSingleValueToken5));
        Map<SimpleType, IrSimpleFunctionSymbol> map5 = this.irBuiltIns.getGreaterOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken6 = KtTokens.GTEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken6, (String)"KtTokens.GTEQ");
        irIntrinsicMethods.intrinsicsMap = MapsKt.toMap((Iterable)CollectionsKt.plus((Collection)collection5, (Iterable)IrIntrinsicMethods.Companion.primitiveComparisonIntrinsics(map5, ktSingleValueToken6)));
    }

    static {
        Companion = new Companion(null);
        INTRINSICS_CLASS_NAME = INTRINSICS_CLASS_NAME;
        INC = new Increment(1);
        DEC = new Increment(-1);
        KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken, (String)"KtTokens.EQEQ");
        EQUALS = new Equals(ktSingleValueToken);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "", "owner", "Lorg/jetbrains/kotlin/name/FqName;", "receiverParameterTypeName", "name", "", "valueParameterTypeNames", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getOwner", "()Lorg/jetbrains/kotlin/name/FqName;", "getReceiverParameterTypeName", "getValueParameterTypeNames", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm"})
    public static final class Key {
        @NotNull
        private final FqName owner;
        @Nullable
        private final FqName receiverParameterTypeName;
        @NotNull
        private final String name;
        @NotNull
        private final List<FqName> valueParameterTypeNames;

        @NotNull
        public final FqName getOwner() {
            return this.owner;
        }

        @Nullable
        public final FqName getReceiverParameterTypeName() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<FqName> getValueParameterTypeNames() {
            return this.valueParameterTypeNames;
        }

        public Key(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(valueParameterTypeNames, (String)"valueParameterTypeNames");
            this.owner = owner;
            this.receiverParameterTypeName = receiverParameterTypeName;
            this.name = name;
            this.valueParameterTypeNames = valueParameterTypeNames;
        }

        @NotNull
        public final FqName component1() {
            return this.owner;
        }

        @Nullable
        public final FqName component2() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final List<FqName> component4() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final Key copy(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(valueParameterTypeNames, (String)"valueParameterTypeNames");
            return new Key(owner, receiverParameterTypeName, name, valueParameterTypeNames);
        }

        public static /* synthetic */ Key copy$default(Key key, FqName fqName2, FqName fqName3, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = key.owner;
            }
            if ((n & 2) != 0) {
                fqName3 = key.receiverParameterTypeName;
            }
            if ((n & 4) != 0) {
                string = key.name;
            }
            if ((n & 8) != 0) {
                list2 = key.valueParameterTypeNames;
            }
            return key.copy(fqName2, fqName3, string, list2);
        }

        @NotNull
        public String toString() {
            return "Key(owner=" + this.owner + ", receiverParameterTypeName=" + this.receiverParameterTypeName + ", name=" + this.name + ", valueParameterTypeNames=" + this.valueParameterTypeNames + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.owner;
            FqName fqName3 = this.receiverParameterTypeName;
            String string = this.name;
            List<FqName> list2 = this.valueParameterTypeNames;
            return (((fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (fqName3 != null ? ((Object)fqName3).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Key)) break block3;
                    Key key = (Key)object;
                    if (!Intrinsics.areEqual((Object)this.owner, (Object)key.owner) || !Intrinsics.areEqual((Object)this.receiverParameterTypeName, (Object)key.receiverParameterTypeName) || !Intrinsics.areEqual((Object)this.name, (Object)key.name) || !Intrinsics.areEqual(this.valueParameterTypeNames, key.valueParameterTypeNames)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$OperatorNames;", "", "()V", "ANDAND", "", "backend.jvm"})
    private static final class OperatorNames {
        @NotNull
        public static final String ANDAND = "ANDAND";
        public static final OperatorNames INSTANCE;

        private OperatorNames() {
        }

        static {
            OperatorNames operatorNames;
            INSTANCE = operatorNames = new OperatorNames();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J:\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\"\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J6\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 0\u000e0\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u0004\u0018\u00010\u000f*\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Companion;", "", "()V", "DEC", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Increment;", "EQUALS", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals;", "INC", "INTRINSICS_CLASS_NAME", "", "getINTRINSICS_CLASS_NAME$backend_jvm", "()Ljava/lang/String;", "arrayMethods", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "arrayClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getParameterFqName", "Lorg/jetbrains/kotlin/name/FqName;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "methodWithArity", "klass", "name", "arity", "", "intrinsic", "numberConversionMethods", "numberClass", "primitiveComparisonIntrinsics", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveComparison;", "typeToIrFun", "", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "operator", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "toKey", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "backend.jvm"})
    public static final class Companion {
        @NotNull
        public final String getINTRINSICS_CLASS_NAME$backend_jvm() {
            return INTRINSICS_CLASS_NAME;
        }

        /*
         * WARNING - void declaration
         */
        private final Key toKey(@NotNull IrFunctionSymbol $this$toKey) {
            Collection<FqName> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Object object2;
            Object $this$safeAs$iv = $this$toKey.getOwner().getParent();
            boolean $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv;
            if (!(object3 instanceof IrClass)) {
                object3 = null;
            }
            if ((object2 = (object = (IrClass)object3)) == null || (object2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object2)) == null) {
                $this$safeAs$iv = $this$toKey.getOwner().getParent();
                $i$f$safeAs = false;
                Object object4 = $this$safeAs$iv;
                if (!(object4 instanceof IrPackageFragment)) {
                    object4 = null;
                }
                object = (IrPackageFragment)object4;
                IrDeclarationContainer irDeclarationContainer = object;
                object2 = irDeclarationContainer != null ? irDeclarationContainer.getFqName() : null;
            }
            if (object2 == null) {
                return null;
            }
            FqName fqName2 = this.getParameterFqName($this$toKey.getOwner().getExtensionReceiverParameter());
            String string = $this$toKey.getOwner().getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"owner.name.asString()");
            $this$safeAs$iv = $this$toKey.getOwner().getValueParameters();
            String string2 = string;
            FqName fqName3 = fqName2;
            object = object2;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName4 = this.getParameterFqName((IrValueParameter)p1);
                collection.add(fqName4);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            String string3 = string2;
            FqName fqName5 = fqName3;
            Object object5 = object;
            return new Key((FqName)object5, fqName5, string3, list2);
        }

        private final FqName getParameterFqName(IrValueParameter parameter2) {
            FqName fqName2;
            Object object = parameter2;
            if (object != null && (object = object.getType()) != null && (object = IrTypesKt.getClassifierOrNull((IrType)object)) != null && (object = object.getOwner()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = it;
                fqName2 = object3 instanceof IrClass ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)it) : (object3 instanceof IrTypeParameter ? new FqName(((IrTypeParameter)it).getName().asString()) : null);
            } else {
                fqName2 = null;
            }
            return fqName2;
        }

        private final List<Pair<Key, IntrinsicMethod>> methodWithArity(IrClassSymbol klass2, String name, int arity, IntrinsicMethod intrinsic) {
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(IrUtilsKt.getFunctions((IrClass)klass2.getOwner()), (Function1)((Function1)new Function1<IrSimpleFunction, Boolean>(name, arity){
                final /* synthetic */ String $name;
                final /* synthetic */ int $arity;

                public final boolean invoke(@NotNull IrSimpleFunction it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getName().asString(), (Object)this.$name) && it.getValueParameters().size() == this.$arity;
                }
                {
                    this.$name = string;
                    this.$arity = n;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<IrSimpleFunction, Pair<? extends Key, ? extends IntrinsicMethod>>(intrinsic){
                final /* synthetic */ IntrinsicMethod $intrinsic;

                @NotNull
                public final Pair<Key, IntrinsicMethod> invoke(@NotNull IrSimpleFunction it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Key key = org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicMethods$Companion.access$toKey(IrIntrinsicMethods.Companion, it.getSymbol());
                    if (key == null) {
                        Intrinsics.throwNpe();
                    }
                    return TuplesKt.to((Object)key, (Object)this.$intrinsic);
                }
                {
                    this.$intrinsic = intrinsicMethod;
                    super(1);
                }
            })));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods(IrClassSymbol numberClass) {
            void $this$flatMapTo$iv$iv;
            ImmutableSet<Name> immutableSet = OperatorConventions.NUMBER_CONVERSIONS;
            Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"OperatorConventions.NUMBER_CONVERSIONS");
            Iterable $this$flatMap$iv = immutableSet;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Name method = (Name)element$iv$iv;
                boolean bl = false;
                String string = method.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.asString()");
                Iterable list$iv$iv = Companion.methodWithArity(numberClass, string, 0, NumberCast.INSTANCE);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final List<Pair<Key, IntrinsicMethod>> arrayMethods(IrClassSymbol arrayClass) {
            Object it;
            Sequence<IrProperty> $this$single$iv;
            Object[] objectArray;
            Sequence<IrConstructorSymbol> sequence2 = IrUtilsKt.getConstructors(arrayClass);
            Companion companion = this;
            int n = 0;
            Object[] objectArray2 = objectArray = new Pair[2];
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (IrConstructorSymbol)element$iv;
                boolean bl = false;
                if (!(((IrConstructor)it.getOwner()).getValueParameters().size() == 2)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object var14_14 = single$iv;
            Key key = companion.toKey(var14_14);
            if (key == null) {
                Intrinsics.throwNpe();
            }
            objectArray[n] = TuplesKt.to((Object)key, (Object)ArrayConstructor.INSTANCE);
            $this$single$iv = IrUtilsKt.getProperties((IrDeclarationContainer)arrayClass.getOwner());
            companion = this;
            n = 1;
            objectArray = objectArray2;
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"size")) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            var14_14 = single$iv;
            IrSimpleFunction irSimpleFunction = ((IrProperty)var14_14).getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            Key key2 = companion.toKey(irSimpleFunction.getSymbol());
            if (key2 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[n] = TuplesKt.to((Object)key2, (Object)ArraySize.INSTANCE);
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray2), (Iterable)this.methodWithArity(arrayClass, "set", 2, ArraySet.INSTANCE)), (Iterable)this.methodWithArity(arrayClass, "get", 1, ArrayGet.INSTANCE)), (Iterable)this.methodWithArity(arrayClass, "clone", 0, Clone.INSTANCE)), (Iterable)this.methodWithArity(arrayClass, "iterator", 0, ArrayIterator.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Key, PrimitiveComparison>> primitiveComparisonIntrinsics(Map<SimpleType, ? extends IrSimpleFunctionSymbol> typeToIrFun, KtSingleValueToken operator) {
            void $this$mapTo$iv$iv;
            Map<SimpleType, ? extends IrSimpleFunctionSymbol> $this$map$iv = typeToIrFun;
            boolean $i$f$map = false;
            Map<SimpleType, ? extends IrSimpleFunctionSymbol> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var8_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator2 = var8_8.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $dstr$type$irFunSymbol;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var14_14 = $dstr$type$irFunSymbol;
                boolean bl3 = false;
                SimpleType type2 = (SimpleType)var14_14.getKey();
                var14_14 = $dstr$type$irFunSymbol;
                bl3 = false;
                IrSimpleFunctionSymbol irFunSymbol = (IrSimpleFunctionSymbol)var14_14.getValue();
                Key key = Companion.toKey(irFunSymbol);
                if (key == null) {
                    Intrinsics.throwNpe();
                }
                Pair pair = TuplesKt.to((Object)key, (Object)new PrimitiveComparison(type2, operator));
                collection.add(pair);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

