/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint;

import com.github.shyiko.klob.Glob;
import com.github.shyiko.ktlint.Main;
import com.github.shyiko.ktlint.core.KtLint;
import com.github.shyiko.ktlint.core.LintError;
import com.github.shyiko.ktlint.core.ParseException;
import com.github.shyiko.ktlint.core.Reporter;
import com.github.shyiko.ktlint.core.ReporterProvider;
import com.github.shyiko.ktlint.core.RuleExecutionException;
import com.github.shyiko.ktlint.core.RuleSet;
import com.github.shyiko.ktlint.core.RuleSetProvider;
import com.github.shyiko.ktlint.internal.EditorConfig;
import com.github.shyiko.ktlint.internal.IntellijIDEAIntegration;
import com.github.shyiko.ktlint.internal.MavenDependencyResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.transfer.TransferEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="An anti-bikeshedding Kotlin linter with built-in formatter\n(https://github.com/shyiko/ktlint).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint <flags> [patterns]\n\nExamples:\n  # check the style of all Kotlin files inside the current dir (recursively)\n  # (hidden folders will be skipped)\n  ktlint\n\n  # check only certain locations (prepend ! to negate the pattern)\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n\n  # auto-correct style violations\n  ktlint -F \"src/**/*.kt\"\n\n  # custom reporter\n  ktlint --reporter=plain?group_by_file\n  # multiple reporters can be specified like this\n  ktlint --reporter=plain \\\n    --reporter=checkstyle,output=ktlint-checkstyle-report.xml\n  # 3rd-party reporter\n  ktlint --reporter=html,artifact=com.gihub.user:repo:master-SNAPSHOT\n\nFlags:", synopsisHeading="", customSynopsis={""}, sortOptions=false)
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0016\u0010*\u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010,0,0+H\u0002Jr\u0010\u000f\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000426\u00103\u001a2\u0012\u0013\u0012\u001105\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(9\u0012\u0004\u0012\u00020%04H\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010;\u001a\n #*\u0004\u0018\u00010\u00050\u00052\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010\u0011\u001a\u00020%H\u0002J]\u0010>\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042!\u00103\u001a\u001d\u0012\u0013\u0012\u001105\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020%0?H\u0002J$\u0010@\u001a\u00020%2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020'0B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050DH\u0002J\u0016\u0010E\u001a\u00020F2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020'0BH\u0002J\u001b\u0010G\u001a\u00020%2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050IH\u0007\u00a2\u0006\u0002\u0010JJ\u001b\u0010K\u001a\u00020%2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050IH\u0002\u00a2\u0006\u0002\u0010JJ\u001c\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050M2\u0006\u0010N\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020%H\u0002J\b\u0010O\u001a\u00020\u0005H\u0002J\u001a\u0010P\u001a\u00020%*\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S00H\u0002J&\u0010T\u001a\b\u0012\u0004\u0012\u0002HU0D\"\u0004\b\u0000\u0010U*\b\u0012\u0004\u0012\u0002HU0D2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010V\u001a\n #*\u0004\u0018\u00010\u00050\u0005*\u00020,H\u0002J<\u0010W\u001a\u00020%\"\u0004\b\u0000\u0010U*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0X0+2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002HU\u0012\u0004\u0012\u00020%0?2\b\b\u0002\u0010Y\u001a\u00020\u0013H\u0002J\u0010\u0010Z\u001a\u000205*\u00060[j\u0002`\\H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u000f\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u00138B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n #*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/github/shyiko/ktlint/Main;", "", "()V", "DEPRECATED_FLAGS", "", "", "android", "", "apply", "color", "debug", "forceApply", "forceUpdate", "Ljava/lang/Boolean;", "forceUpdateDeprecated", "format", "help", "installGitPreCommitHook", "limit", "", "getLimit", "()I", "patterns", "Ljava/util/ArrayList;", "printAST", "relative", "reporters", "repositories", "repositoriesDeprecated", "rulesets", "skipClasspathCheck", "stdin", "verbose", "version", "workDir", "kotlin.jvm.PlatformType", "applyToIDEA", "", "buildDependencyResolver", "Lcom/github/shyiko/ktlint/internal/MavenDependencyResolver;", "expandTilde", "path", "fileSequence", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "fileName", "text", "ruleSets", "", "Lcom/github/shyiko/ktlint/core/RuleSet;", "userData", "cb", "Lkotlin/Function2;", "Lcom/github/shyiko/ktlint/core/LintError;", "Lkotlin/ParameterName;", "name", "e", "corrected", "getImplementationVersion", "hex", "input", "", "lint", "Lkotlin/Function1;", "loadJARs", "dependencyResolver", "Lkotlin/Lazy;", "artifacts", "", "loadReporter", "Lcom/github/shyiko/ktlint/core/Reporter;", "main", "args", "", "([Ljava/lang/String;)V", "parseCmdLine", "parseQuery", "Ljava/util/LinkedHashMap;", "query", "usage", "addURLs", "Ljava/net/URLClassLoader;", "url", "Ljava/net/URL;", "head", "T", "location", "parallel", "Ljava/util/concurrent/Callable;", "numberOfThreads", "toLintError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "ktlint"})
public final class Main {
    private static final Map<String, String> DEPRECATED_FLAGS;
    @CommandLine.Option(names={"--android", "-a"}, description={"Turn on Android Kotlin Style Guide compatibility"})
    private static boolean android;
    @CommandLine.Option(names={"--apply-to-idea"}, description={"Update Intellij IDEA project settings"})
    private static boolean apply;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private static boolean color;
    @CommandLine.Option(names={"--debug"}, description={"Turn on debug output"})
    private static boolean debug;
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix any deviations from the code style"})
    private static boolean format;
    @CommandLine.Option(names={"--install-git-pre-commit-hook"}, description={"Install git hook to automatically check files for style violations on commit"})
    private static boolean installGitPreCommitHook;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private static int limit;
    @CommandLine.Option(names={"--print-ast"}, description={"Print AST (useful when writing/debugging rules)"})
    private static boolean printAST;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private static boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, json, checkstyle). To use a third-party reporter specify either a path to a JAR file on the filesystem or a<groupId>:<artifactId>:<version> triple pointing to a remote artifact (in which case ktlint will first check local cache (~/.m2/repository) and then, if not found, attempt downloading it from Maven Central/JCenter/JitPack/user-provided repository)"})
    private static ArrayList<String> reporters;
    @CommandLine.Option(names={"--repository"}, description={"An additional Maven repository (Maven Central/JCenter/JitPack are active by default) (value format: <id>=<url>)"})
    private static ArrayList<String> repositories;
    @CommandLine.Option(names={"--ruleset-repository", "--reporter-repository"}, hidden=true)
    private static ArrayList<String> repositoriesDeprecated;
    @CommandLine.Option(names={"--repository-update", "-U"}, description={"Check remote repositories for updated snapshots"})
    private static Boolean forceUpdate;
    @CommandLine.Option(names={"--ruleset-update", "--reporter-update"}, hidden=true)
    private static Boolean forceUpdateDeprecated;
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s) or a <groupId>:<artifactId>:<version> triple pointing to a remote artifact (in which case ktlint will first check local cache (~/.m2/repository) and then, if not found, attempt downloading it from Maven Central/JCenter/JitPack/user-provided repository)"})
    private static ArrayList<String> rulesets;
    @CommandLine.Option(names={"--skip-classpath-check"}, description={"Do not check classpath for pottential conflicts"})
    private static boolean skipClasspathCheck;
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private static boolean stdin;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Show error codes"})
    private static boolean verbose;
    @CommandLine.Option(names={"--version"}, description={"Print version information"})
    private static boolean version;
    @CommandLine.Option(names={"--help", "-h"}, help=true, hidden=true)
    private static boolean help;
    @CommandLine.Option(names={"-y"}, hidden=true)
    private static boolean forceApply;
    @CommandLine.Parameters(hidden=true)
    private static ArrayList<String> patterns;
    private static final String workDir;
    public static final Main INSTANCE;

    private final int getLimit() {
        return limit < 0 ? Integer.MAX_VALUE : limit;
    }

    private final String location(@NotNull File $receiver) {
        return relative ? FilesKt.toRelativeString((File)$receiver, (File)new File(workDir)) : $receiver.getPath();
    }

    private final String usage() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream it = byteArrayOutputStream = new ByteArrayOutputStream();
        CommandLine.usage((Object)INSTANCE, (PrintStream)new PrintStream(it), (CommandLine.Help.Ansi)CommandLine.Help.Ansi.OFF);
        return StringsKt.replace$default((String)byteArrayOutputStream.toString(), (String)StringsKt.repeat((CharSequence)" ", (int)32), (String)StringsKt.repeat((CharSequence)" ", (int)30), (boolean)false, (int)4, null);
    }

    private final void parseCmdLine(String[] args) {
        try {
            CommandLine.populateCommand((Object)this, (String[])Arrays.copyOf(args, args.length));
            repositories.addAll((Collection<String>)repositoriesDeprecated);
            if (forceUpdateDeprecated != null && forceUpdate == null) {
                forceUpdate = forceUpdateDeprecated;
            }
        }
        catch (Exception e22) {
            System.err.println("Error: " + e22.getMessage() + "\n\n" + this.usage());
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (help) {
            String e22 = this.usage();
            System.out.println((Object)e22);
            int e22 = 0;
            System.exit(e22);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        for (Object element$iv : (Object[])args) {
            String flag;
            String alt;
            String arg = (String)element$iv;
            if (!StringsKt.startsWith$default((String)arg, (String)"--", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)arg, (CharSequence)"=", (boolean)false, (int)2, null) || (alt = DEPRECATED_FLAGS.get(flag = StringsKt.substringBefore$default((String)arg, (String)"=", null, (int)2, null))) == null) continue;
            System.err.println("" + flag + " flag is deprecated and will be removed in 1.0.0 (use " + alt + " instead)");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Main.INSTANCE.parseCmdLine(args);
        if (Main.version) {
            var1_1 = Main.INSTANCE.getImplementationVersion();
            System.out.println((Object)var1_1);
            var1_2 = 0;
            System.exit(var1_2);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (Main.installGitPreCommitHook) {
            Main.INSTANCE.installGitPreCommitHook();
            if (!Main.apply) {
                var1_3 = 0;
                System.exit(var1_3);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        if (Main.apply) {
            Main.INSTANCE.applyToIDEA();
            var1_4 = 0;
            System.exit(var1_4);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (Main.printAST) {
            Main.INSTANCE.printAST();
            var1_5 = 0;
            System.exit(var1_5);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        start = System.currentTimeMillis();
        dependencyResolver = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)main.dependencyResolver.1.INSTANCE);
        if (!Main.rulesets.isEmpty()) {
            Main.INSTANCE.loadJARs((Lazy<MavenDependencyResolver>)dependencyResolver, (List<String>)Main.rulesets);
        }
        var5_8 = ServiceLoader.load(RuleSetProvider.class);
        var6_9 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        var8_11 = $receiver$iv$iv.iterator();
        while (var8_11.hasNext()) {
            item$iv$iv = var8_11.next();
            var10_13 = (RuleSetProvider)item$iv$iv;
            var30_14 = destination$iv$iv;
            var31_15 /* !! */  = TuplesKt.to((Object)it.get().getId(), (Object)it);
            var30_14.add(var31_15 /* !! */ );
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                String string = Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)"standard") ? '\u0000' + (String)it.getFirst() : (String)it.getFirst();
                it = (Pair)b;
                Comparable comparable = (Comparable)((Object)string);
                String string2 = Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)"standard") ? '\u0000' + (String)it.getFirst() : (String)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        };
        ruleSetProviders = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv);
        if (Main.debug) {
            $receiver$iv = ruleSetProviders;
            for (E element$iv : $receiver$iv) {
                it = (Pair)element$iv /* !! */ ;
                System.err.println("[DEBUG] Discovered ruleset \"" + (String)it.getFirst() + '\"');
            }
        }
        reporter = Main.INSTANCE.loadReporter((Lazy<MavenDependencyResolver>)dependencyResolver);
        v0 = Main.workDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"workDir");
        v1 /* !! */  = EditorConfig.Companion.of(v0);
        if (v1 /* !! */  == null) ** GOTO lbl-1000
        editorConfig /* !! */  = element$iv /* !! */  = v1 /* !! */ ;
        if (Main.debug) {
            System.err.println("[DEBUG] Discovered .editorconfig (" + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence(editorConfig /* !! */ , (Function1)main.userData.1.1.INSTANCE), (Function1)main.userData.1.2.INSTANCE), null, null, null, (int)0, null, null, (int)63, null) + ')');
            $i$a$1$forEach = (Map)editorConfig /* !! */ ;
            $i$f$forEach = new StringBuilder().append("[DEBUG] ");
            $i$a$1$map = System.err;
            $i$f$mapTo = $receiver$iv;
            destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$receiver$iv.size()));
            $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                var17_24 = (Map.Entry)element$iv$iv$iv;
                var18_25 = destination$iv$iv;
                var19_26 = (String)it.getKey();
                var20_27 = (Map.Entry)element$iv$iv$iv;
                var21_28 = var19_26;
                var22_29 = var18_25;
                var23_30 = it$iv$iv.getValue();
                var22_29.put(var21_28, var23_30);
            }
            var18_25 = destination$iv$iv;
            $i$a$1$map.println($i$f$forEach.append(var18_25).append(" loaded from .editorconfig").toString());
        }
        if ((v1 /* !! */  = element$iv /* !! */ ) != null) {
            v2 = v1 /* !! */ ;
        } else lbl-1000:
        // 2 sources

        {
            v2 = MapsKt.emptyMap();
        }
        userData = MapsKt.plus((Map)v2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"android", (Object)String.valueOf(Main.android))));
        tripped = new AtomicBoolean();
        process$ = new Function2<String, String, List<? extends main.LintErrorWithCorrectionInfo>>(ruleSetProviders, userData, tripped){
            final /* synthetic */ List $ruleSetProviders;
            final /* synthetic */ Map $userData;
            final /* synthetic */ AtomicBoolean $tripped;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<main.LintErrorWithCorrectionInfo> invoke(@NotNull String fileName, @NotNull String fileContent) {
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
                if (Main.access$getDebug$p(Main.INSTANCE)) {
                    System.err.println("[DEBUG] Checking " + (Intrinsics.areEqual((Object)fileName, (Object)"<text>") ^ true ? Main.access$location(Main.INSTANCE, new File(fileName)) : fileName));
                }
                @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000%\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"com/github/shyiko/ktlint/Main$main$LintErrorWithCorrectionInfo", "", "err", "Lcom/github/shyiko/ktlint/core/LintError;", "corrected", "", "(Lcom/github/shyiko/ktlint/core/LintError;Z)V", "getCorrected", "()Z", "getErr", "()Lcom/github/shyiko/ktlint/core/LintError;", "component1", "component2", "copy", "(Lcom/github/shyiko/ktlint/core/LintError;Z)Lcom/github/shyiko/ktlint/Main$main$LintErrorWithCorrectionInfo;", "equals", "other", "hashCode", "", "toString", "", "ktlint"})
                public final class LintErrorWithCorrectionInfo {
                    @NotNull
                    private final LintError err;
                    private final boolean corrected;

                    @NotNull
                    public final LintError getErr() {
                        return this.err;
                    }

                    public final boolean getCorrected() {
                        return this.corrected;
                    }

                    public LintErrorWithCorrectionInfo(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        this.err = err;
                        this.corrected = corrected;
                    }

                    @NotNull
                    public final LintError component1() {
                        return this.err;
                    }

                    public final boolean component2() {
                        return this.corrected;
                    }

                    @NotNull
                    public final LintErrorWithCorrectionInfo copy(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        return new LintErrorWithCorrectionInfo(err, corrected);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ LintErrorWithCorrectionInfo copy$default(LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo, LintError lintError, boolean bl, int n, Object object) {
                        if ((n & 1) != 0) {
                            lintError = lintErrorWithCorrectionInfo.err;
                        }
                        if ((n & 2) != 0) {
                            bl = lintErrorWithCorrectionInfo.corrected;
                        }
                        return lintErrorWithCorrectionInfo.copy(lintError, bl);
                    }

                    public String toString() {
                        return "LintErrorWithCorrectionInfo(err=" + this.err + ", corrected=" + this.corrected + ")";
                    }

                    public int hashCode() {
                        LintError lintError = this.err;
                        int n = (lintError != null ? lintError.hashCode() : 0) * 31;
                        int n2 = (int)(this.corrected ? 1 : 0);
                        if (n2 != 0) {
                            n2 = 1;
                        }
                        return n + n2;
                    }

                    public boolean equals(Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof LintErrorWithCorrectionInfo)) break block3;
                                LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo = (LintErrorWithCorrectionInfo)object;
                                if (!Intrinsics.areEqual((Object)this.err, (Object)lintErrorWithCorrectionInfo.err) || !(this.corrected == lintErrorWithCorrectionInfo.corrected)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                ArrayList<LintErrorWithCorrectionInfo> result = new ArrayList<LintErrorWithCorrectionInfo>();
                if (Main.access$getFormat$p(Main.INSTANCE)) {
                    String $receiver$iv2;
                    Object object;
                    String string;
                    Object object2;
                    try {
                        Collection<RuleSet> collection;
                        void $receiver$iv$iv;
                        Iterable iterable = this.$ruleSetProviders;
                        object2 = fileContent;
                        string = fileName;
                        object = Main.INSTANCE;
                        void var6_12 = $receiver$iv2;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$receiver$iv2), (int)10));
                        for (T item$iv$iv2 : $receiver$iv$iv) {
                            void it;
                            Pair pair = (Pair)item$iv$iv2;
                            collection = destination$iv$iv;
                            RuleSet ruleSet = ((RuleSetProvider)it.getSecond()).get();
                            collection.add(ruleSet);
                        }
                        collection = (List)destination$iv$iv;
                        $receiver$iv2 = Main.access$format((Main)object, string, (String)object2, collection, this.$userData, (Function2)new Function2<LintError, Boolean, Unit>(this, result){
                            final /* synthetic */ main.2 this$0;
                            final /* synthetic */ ArrayList $result;

                            public final void invoke(@NotNull LintError err, boolean corrected) {
                                Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                                if (!corrected) {
                                    this.$result.add(new LintErrorWithCorrectionInfo(err, corrected));
                                    this.this$0.$tripped.set(true);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$result = arrayList;
                                super(2);
                            }
                        });
                    }
                    catch (Exception e) {
                        result.add(new LintErrorWithCorrectionInfo(Main.access$toLintError(Main.INSTANCE, e), false));
                        this.$tripped.set(true);
                        $receiver$iv2 = fileContent;
                    }
                    String formattedFileContent2 = $receiver$iv2;
                    if (Main.access$getStdin$p(Main.INSTANCE)) {
                        System.out.println((Object)formattedFileContent2);
                    } else if (fileContent != formattedFileContent2) {
                        $receiver$iv2 = "UTF-8";
                        string = formattedFileContent2;
                        object = new File(fileName);
                        Charset charset = Charset.forName($receiver$iv2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                        object2 = charset;
                        FilesKt.writeText((File)object, (String)string, (Charset)object2);
                    }
                } else {
                    try {
                        Collection<RuleSet> collection;
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        Iterable formattedFileContent2 = this.$ruleSetProviders;
                        String string = fileContent;
                        String string2 = fileName;
                        Main main2 = Main.INSTANCE;
                        void $receiver$iv2 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            Pair item$iv$iv2 = (Pair)item$iv$iv;
                            collection = destination$iv$iv;
                            RuleSet ruleSet = ((RuleSetProvider)it.getSecond()).get();
                            collection.add(ruleSet);
                        }
                        collection = (List)destination$iv$iv;
                        Main.access$lint(main2, string2, string, collection, this.$userData, (Function1)new Function1<LintError, Unit>(this, result){
                            final /* synthetic */ main.2 this$0;
                            final /* synthetic */ ArrayList $result;

                            public final void invoke(@NotNull LintError err) {
                                Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                                this.$result.add(new LintErrorWithCorrectionInfo(err, false));
                                this.this$0.$tripped.set(true);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$result = arrayList;
                                super(1);
                            }
                        });
                    }
                    catch (Exception e) {
                        result.add(new LintErrorWithCorrectionInfo(Main.access$toLintError(Main.INSTANCE, e), false));
                        this.$tripped.set(true);
                    }
                }
                return result;
            }
            {
                this.$ruleSetProviders = list;
                this.$userData = map;
                this.$tripped = atomicBoolean;
                super(2);
            }
        };
        $i$a$1$map = new Pair((Object)new AtomicInteger(), (Object)new AtomicInteger());
        $receiver$iv = (AtomicInteger)$i$a$1$map.component1();
        errorNumber = (AtomicInteger)$i$a$1$map.component2();
        report$ = new Function2<String, List<? extends main.LintErrorWithCorrectionInfo>, Unit>((AtomicInteger)fileNumber, errorNumber, reporter){
            final /* synthetic */ AtomicInteger $fileNumber;
            final /* synthetic */ AtomicInteger $errorNumber;
            final /* synthetic */ Reporter $reporter;

            public final void invoke(@NotNull String fileName, @NotNull List<main.LintErrorWithCorrectionInfo> errList) {
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                Intrinsics.checkParameterIsNotNull(errList, (String)"errList");
                this.$fileNumber.incrementAndGet();
                int n = errList.size();
                int n2 = Main.access$getLimit$p(Main.INSTANCE) - this.$errorNumber.get();
                int n3 = 0;
                n2 = Math.max(n2, n3);
                int errListLimit = Math.min(n, n2);
                this.$errorNumber.addAndGet(errListLimit);
                this.$reporter.before(fileName);
                Iterable $receiver$iv = Main.access$head(Main.INSTANCE, errList, errListLimit);
                for (T element$iv : $receiver$iv) {
                    LintErrorWithCorrectionInfo $err_corrected = (LintErrorWithCorrectionInfo)element$iv;
                    LintError err = $err_corrected.component1();
                    boolean corrected = $err_corrected.component2();
                    this.$reporter.onLintError(fileName, err, corrected);
                }
                this.$reporter.after(fileName);
            }
            {
                this.$fileNumber = atomicInteger;
                this.$errorNumber = atomicInteger2;
                this.$reporter = reporter;
                super(2);
            }
        };
        reporter.beforeAll();
        if (Main.stdin) {
            var12_18 = ByteStreamsKt.readBytes$default((InputStream)System.in, (int)0, (int)1, null);
            var33_31 = "<text>";
            var32_32 = process$;
            var31_15 /* !! */  = "<text>";
            var30_14 = report$;
            var34_33 = new String(var12_18, Charsets.UTF_8);
            var30_14.invoke((String)var31_15 /* !! */ , var32_32.invoke(var33_31, var34_33));
        } else {
            Main.parallel$default(Main.INSTANCE, SequencesKt.map((Sequence)SequencesKt.takeWhile(Main.INSTANCE.fileSequence(), (Function1)((Function1)new Function1<File, Boolean>(errorNumber){
                final /* synthetic */ AtomicInteger $errorNumber;

                public final boolean invoke(File it) {
                    return this.$errorNumber.get() < Main.access$getLimit$p(Main.INSTANCE);
                }
                {
                    this.$errorNumber = atomicInteger;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends main.LintErrorWithCorrectionInfo>>>>(process$){
                final /* synthetic */ main.2 $process$2;

                @NotNull
                public final Callable<Pair<File, List<main.LintErrorWithCorrectionInfo>>> invoke(File file) {
                    return new Callable<Pair<? extends File, ? extends List<? extends main.LintErrorWithCorrectionInfo>>>(this, file){
                        final /* synthetic */ main.5 this$0;
                        final /* synthetic */ File $file;

                        @NotNull
                        public final Pair<File, List<main.LintErrorWithCorrectionInfo>> call() {
                            main.2 v0 = this.this$0.$process$2;
                            String string = this.$file.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                            return TuplesKt.to((Object)this.$file, v0.invoke(string, FilesKt.readText$default((File)this.$file, null, (int)1, null)));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = file;
                        }
                    };
                }
                {
                    this.$process$2 = var1_1;
                    super(1);
                }
            })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends main.LintErrorWithCorrectionInfo>>, Unit>(report$){
                final /* synthetic */ main.3 $report$3;

                public final void invoke(Pair<? extends File, ? extends List<main.LintErrorWithCorrectionInfo>> $file_errList) {
                    File file = (File)$file_errList.component1();
                    List errList = (List)$file_errList.component2();
                    String string = Main.access$location(Main.INSTANCE, file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.location()");
                    this.$report$3.invoke(string, errList);
                }
                {
                    this.$report$3 = var1_1;
                    super(1);
                }
            }, 0, 2, null);
        }
        reporter.afterAll();
        if (Main.debug) {
            System.err.println("[DEBUG] " + (System.currentTimeMillis() - start) + "ms / " + fileNumber + " file(s) / " + errorNumber + " error(s)");
        }
        if (tripped.get()) {
            var12_19 = 1;
            System.exit(var12_19);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final String getImplementationVersion() {
        String string = this.getClass().getPackage().getImplementationVersion();
        if (string == null) {
            InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (inputStream != null) {
                InputStream inputStream2;
                InputStream stream = inputStream2 = inputStream;
                string = new Manifest(stream).getMainAttributes().getValue("Implementation-Version");
            } else {
                string = null;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Reporter loadReporter(Lazy<MavenDependencyResolver> dependencyResolver2) {
        Collection $receiver$iv;
        Object id;
        Object object;
        Object destination$iv$iv;
        String string;
        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000+\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JF\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"com/github/shyiko/ktlint/Main$loadReporter$ReporterTemplate", "", "id", "", "artifact", "config", "", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getConfig", "()Ljava/util/Map;", "getId", "getOutput", "setOutput", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)Lcom/github/shyiko/ktlint/Main$loadReporter$ReporterTemplate;", "equals", "", "other", "hashCode", "", "toString", "ktlint"})
        public final class ReporterTemplate {
            @NotNull
            private final String id;
            @Nullable
            private final String artifact;
            @NotNull
            private final Map<String, String> config;
            @Nullable
            private String output;

            @NotNull
            public final String getId() {
                return this.id;
            }

            @Nullable
            public final String getArtifact() {
                return this.artifact;
            }

            @NotNull
            public final Map<String, String> getConfig() {
                return this.config;
            }

            @Nullable
            public final String getOutput() {
                return this.output;
            }

            public final void setOutput(@Nullable String string) {
                this.output = string;
            }

            public ReporterTemplate(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(config, (String)"config");
                this.id = id;
                this.artifact = artifact;
                this.config = config;
                this.output = output;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @Nullable
            public final String component2() {
                return this.artifact;
            }

            @NotNull
            public final Map<String, String> component3() {
                return this.config;
            }

            @Nullable
            public final String component4() {
                return this.output;
            }

            @NotNull
            public final ReporterTemplate copy(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(config, (String)"config");
                return new ReporterTemplate(id, artifact, config, output);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ReporterTemplate copy$default(ReporterTemplate reporterTemplate, String string, String string2, Map map, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = reporterTemplate.id;
                }
                if ((n & 2) != 0) {
                    string2 = reporterTemplate.artifact;
                }
                if ((n & 4) != 0) {
                    map = reporterTemplate.config;
                }
                if ((n & 8) != 0) {
                    string3 = reporterTemplate.output;
                }
                return reporterTemplate.copy(string, string2, map, string3);
            }

            public String toString() {
                return "ReporterTemplate(id=" + this.id + ", artifact=" + this.artifact + ", config=" + this.config + ", output=" + this.output + ")";
            }

            public int hashCode() {
                String string = this.id;
                String string2 = this.artifact;
                Map<String, String> map = this.config;
                String string3 = this.output;
                return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ReporterTemplate)) break block3;
                        ReporterTemplate reporterTemplate = (ReporterTemplate)object;
                        if (!Intrinsics.areEqual((Object)this.id, (Object)reporterTemplate.id) || !Intrinsics.areEqual((Object)this.artifact, (Object)reporterTemplate.artifact) || !Intrinsics.areEqual(this.config, reporterTemplate.config) || !Intrinsics.areEqual((Object)this.output, (Object)reporterTemplate.output)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        ReporterTemplate it;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Object $receiver$iv2;
        void $receiver$iv$iv2;
        Object object2;
        Pair reporterId;
        Collection collection;
        Object item$iv$iv2;
        void $receiver$iv$iv3;
        Iterable $receiver$iv3 = reporters.isEmpty() ? CollectionsKt.listOf((Object)"plain") : (List)reporters;
        Iterable iterable = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv3) {
            String string2;
            String string3;
            Map map;
            Object it2;
            String string4;
            Object $receiver$iv4;
            ReporterTemplate reporterTemplate;
            ReporterTemplate reporterTemplate2;
            Pair pair;
            block18: {
                String string5;
                String string6;
                ListIterator iterator$iv;
                String rawReporterConfig;
                List split;
                block17: {
                    ReporterTemplate reporterTemplate3;
                    Object object3;
                    void reporter;
                    String string7 = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    split = StringsKt.split$default((CharSequence)((CharSequence)reporter), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    Object object4 = new String[]{"?"};
                    boolean bl = false;
                    int n = 2;
                    object4 = object3 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)split.get(0)), (String[])object4, (boolean)bl, (int)n, (int)2, null), (Iterable)CollectionsKt.listOf((Object)""));
                    String string8 = (String)object4.get(0);
                    object4 = object3;
                    rawReporterConfig = (String)object4.get(1);
                    object3 = split;
                    pair = reporterId;
                    reporterTemplate2 = reporterTemplate3;
                    reporterTemplate = reporterTemplate3;
                    iterator$iv = $receiver$iv4.listIterator($receiver$iv4.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        String it3 = (String)element$iv;
                        if (!StringsKt.startsWith$default((String)it3, (String)"artifact=", (boolean)false, (int)2, null)) continue;
                        string6 = (String)element$iv;
                        break block17;
                    }
                    string6 = null;
                }
                string4 = string6;
                ReporterTemplate reporterTemplate4 = reporterTemplate;
                ReporterTemplate reporterTemplate5 = reporterTemplate2;
                Pair pair2 = pair;
                String string9 = string4;
                if (string9 != null) {
                    $receiver$iv4 = string9;
                    pair = pair2;
                    reporterTemplate2 = reporterTemplate5;
                    reporterTemplate = reporterTemplate4;
                    it2 = $receiver$iv4;
                    string4 = (String)StringsKt.split$default((CharSequence)((CharSequence)it2), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null).get(1);
                    reporterTemplate4 = reporterTemplate;
                    reporterTemplate5 = reporterTemplate2;
                    pair2 = pair;
                    string5 = string4;
                } else {
                    string5 = null;
                }
                $receiver$iv4 = split;
                map = MapsKt.plus((Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"verbose", (Object)String.valueOf(verbose)), TuplesKt.to((Object)"color", (Object)String.valueOf(color))}), (Map)INSTANCE.parseQuery(rawReporterConfig));
                string4 = string5;
                pair = pair2;
                reporterTemplate2 = reporterTemplate5;
                reporterTemplate = reporterTemplate4;
                iterator$iv = $receiver$iv4.listIterator($receiver$iv4.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    String it4 = (String)element$iv;
                    if (!StringsKt.startsWith$default((String)it4, (String)"output=", (boolean)false, (int)2, null)) continue;
                    string3 = (String)element$iv;
                    break block18;
                }
                string3 = null;
            }
            String string10 = string3;
            ReporterTemplate reporterTemplate6 = reporterTemplate;
            ReporterTemplate reporterTemplate7 = reporterTemplate2;
            Pair pair3 = pair;
            String string11 = string4;
            Map map2 = map;
            String string12 = string10;
            if (string12 != null) {
                $receiver$iv4 = string12;
                map = map2;
                string4 = string11;
                pair = pair3;
                reporterTemplate2 = reporterTemplate7;
                reporterTemplate = reporterTemplate6;
                it2 = $receiver$iv4;
                string10 = (String)StringsKt.split$default((CharSequence)((CharSequence)it2), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null).get(1);
                reporterTemplate6 = reporterTemplate;
                reporterTemplate7 = reporterTemplate2;
                pair3 = pair;
                string11 = string4;
                map2 = map;
                string2 = string10;
            } else {
                string2 = null;
            }
            reporterTemplate7((String)pair3, string11, map2, string2);
            object2 = reporterTemplate6;
            collection.add(object2);
        }
        List tpls = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        ServiceLoader<ReporterProvider> reporterLoader = ServiceLoader.load(ReporterProvider.class);
        Object $receiver$iv5 = reporterLoader;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10)), (int)16);
        item$iv$iv2 = $receiver$iv5;
        Object destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            Map $i$a$4$let = destination$iv$iv3;
            ReporterProvider it5 = (ReporterProvider)element$iv$iv2;
            reporterId = TuplesKt.to((Object)it5.getId(), (Object)it5);
            $i$a$4$let.put(reporterId.getFirst(), reporterId.getSecond());
        }
        Object map = $receiver$iv5 = destination$iv$iv3;
        destination$iv$iv3 = $receiver$iv2 = (Iterable)tpls;
        Object destination$iv$iv4 = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv) {
            ReporterTemplate it6 = (ReporterTemplate)element$iv$iv3;
            if (!(!map.containsKey(it6.getId()))) continue;
            destination$iv$iv4.add(element$iv$iv3);
        }
        $receiver$iv2 = (List)destination$iv$iv4;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv4 = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            element$iv$iv = element$iv$iv$iv;
            it = (ReporterTemplate)element$iv$iv;
            if (it.getArtifact() == null) continue;
            String it$iv$iv = string;
            destination$iv$iv4.add(it$iv$iv);
        }
        List missingReporters = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
        if (!missingReporters.isEmpty()) {
            void $receiver$iv$iv4;
            INSTANCE.loadJARs(dependencyResolver2, missingReporters);
            reporterLoader.reload();
            $receiver$iv2 = reporterLoader;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
            destination$iv$iv4 = $receiver$iv2;
            destination$iv$iv = new LinkedHashMap(capacity$iv2);
            for (Object element$iv$iv4 : $receiver$iv$iv4) {
                element$iv$iv = destination$iv$iv;
                it = (ReporterProvider)element$iv$iv4;
                string = TuplesKt.to((Object)it.getId(), (Object)it);
                element$iv$iv.put((Object)string.getFirst(), (Object)string.getSecond());
            }
            object = destination$iv$iv;
        } else {
            object = map;
        }
        Object reporterProviderById = object;
        if (debug) {
            map = $receiver$iv5 = reporterProviderById;
            $receiver$iv2 = map.entrySet().iterator();
            while ($receiver$iv2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $id = element$iv = (Map.Entry)$receiver$iv2.next();
                destination$iv$iv = $id;
                id = (String)destination$iv$iv.getKey();
                System.err.println("[DEBUG] Discovered reporter \"" + (String)id + '\"');
            }
        }
        Function1<ReporterTemplate, Reporter> toReporter$ = new Function1<ReporterTemplate, Reporter>((Map)reporterProviderById){
            final /* synthetic */ Map $reporterProviderById;

            @NotNull
            public final Reporter invoke(@NotNull ReporterTemplate $receiver) {
                Reporter reporter;
                PrintStream stream;
                PrintStream printStream;
                ReporterProvider reporterProvider;
                block7: {
                    String string;
                    StringBuilder stringBuilder;
                    PrintStream printStream2;
                    block9: {
                        block8: {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            reporterProvider = (ReporterProvider)this.$reporterProviderById.get($receiver.getId());
                            if (reporterProvider == null) {
                                System.err.println("Error: reporter \"" + $receiver.getId() + "\" wasn't found (available: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.$reporterProviderById.keySet()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
                                int n = 1;
                                System.exit(n);
                                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                            }
                            if (!Main.access$getDebug$p(Main.INSTANCE)) break block7;
                            printStream2 = System.err;
                            stringBuilder = new StringBuilder().append("[DEBUG] Initializing \"").append($receiver.getId()).append("\" reporter with ").append($receiver.getConfig());
                            string = $receiver.getOutput();
                            if (string == null) break block8;
                            String string2 = string;
                            StringBuilder stringBuilder2 = stringBuilder;
                            PrintStream printStream3 = printStream2;
                            String it = string2;
                            String string3 = ", output=" + it;
                            printStream2 = printStream3;
                            stringBuilder = stringBuilder2;
                            string = string3;
                            if (string != null) break block9;
                        }
                        string = "";
                    }
                    printStream2.println(stringBuilder.append((Object)string).toString());
                }
                if ($receiver.getOutput() != null) {
                    File file = new File($receiver.getOutput()).getParentFile();
                    if (file != null) {
                        PreprocessorKt.mkdirsOrFail((File)file);
                    }
                    printStream = new PrintStream($receiver.getOutput(), "UTF-8");
                } else {
                    printStream = Main.access$getStdin$p(Main.INSTANCE) ? System.err : System.out;
                }
                PrintStream printStream4 = stream = printStream;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream4, (String)"stream");
                Reporter reporter2 = reporter = reporterProvider.get(printStream4, $receiver.getConfig());
                return $receiver.getOutput() != null ? (Reporter)new Reporter(reporter2, $receiver, stream){
                    private final /* synthetic */ Reporter $$delegate_0;
                    final /* synthetic */ Reporter $reporter;
                    final /* synthetic */ ReporterTemplate receiver$0$inlined;
                    final /* synthetic */ PrintStream $stream$inlined;
                    {
                        this.$reporter = $captured_local_variable$1;
                        this.receiver$0$inlined = reporterTemplate;
                        this.$stream$inlined = printStream;
                        this.$$delegate_0 = $captured_local_variable$1;
                    }

                    public void afterAll() {
                        this.$reporter.afterAll();
                        this.$stream$inlined.close();
                    }

                    public void after(@NotNull String file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        this.$$delegate_0.after(file);
                    }

                    public void before(@NotNull String file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        this.$$delegate_0.before(file);
                    }

                    public void beforeAll() {
                        this.$$delegate_0.beforeAll();
                    }

                    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        this.$$delegate_0.onLintError(file, err, corrected);
                    }
                } : reporter2;
            }
            {
                this.$reporterProviderById = map;
                super(1);
            }
        };
        map = tpls;
        collection = Reporter.Companion;
        $receiver$iv2 = $receiver$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv3 : $receiver$iv$iv2) {
            void it7;
            id = (ReporterTemplate)item$iv$iv3;
            object2 = destination$iv$iv22;
            Reporter reporter = toReporter$.invoke((ReporterTemplate)it7);
            object2.add(reporter);
        }
        object2 = (List)destination$iv$iv22;
        Collection thisCollection$iv = $receiver$iv = (Collection)object2;
        Reporter[] reporterArray = thisCollection$iv.toArray(new Reporter[0]);
        if (reporterArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        object2 = reporterArray;
        Reporter[] reporterArray2 = (Reporter[])object2;
        return collection.from(Arrays.copyOf(reporterArray2, reporterArray2.length));
    }

    private final LintError toLintError(@NotNull Exception $receiver) {
        LintError lintError;
        Exception exception = $receiver;
        Exception e = exception;
        Exception exception2 = e;
        if (exception2 instanceof ParseException) {
            String string;
            LintError lintError2;
            LintError lintError3 = lintError2;
            lintError = lintError2;
            int n = ((ParseException)e).getLine();
            int n2 = ((ParseException)e).getCol();
            String string2 = "";
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string3 = e.getMessage();
            if (string3 != null) {
                String string4 = string3;
                StringBuilder stringBuilder2 = stringBuilder;
                String string5 = string2;
                int n3 = n2;
                int n4 = n;
                LintError lintError4 = lintError3;
                LintError lintError5 = lintError;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                String string8 = string7;
                lintError = lintError5;
                lintError3 = lintError4;
                n = n4;
                n2 = n3;
                string2 = string5;
                stringBuilder = stringBuilder2;
                string = string8;
            } else {
                string = null;
            }
            lintError3(n, n2, string2, stringBuilder.append(string).append(')').toString());
        } else if (exception2 instanceof RuleExecutionException) {
            if (debug) {
                System.err.println("[DEBUG] Internal Error (" + ((RuleExecutionException)e).getRuleId() + ')');
                e.printStackTrace(System.err);
            }
            lintError = new LintError(((RuleExecutionException)e).getLine(), ((RuleExecutionException)e).getCol(), "", "Internal Error (" + ((RuleExecutionException)e).getRuleId() + "). " + "Please create a ticket at https://github.com/shyiko/ktlint/issue " + "(if possible, provide the source code that triggered an error)");
        } else {
            throw (Throwable)e;
        }
        return lintError;
    }

    private final void printAST() {
        printAST.1 process$ = printAST.1.INSTANCE;
        if (stdin) {
            byte[] byArray = ByteStreamsKt.readBytes$default((InputStream)System.in, (int)0, (int)1, null);
            String string = "<text>";
            printAST.1 var4_5 = process$;
            String string2 = new String(byArray, Charsets.UTF_8);
            var4_5.invoke(string, string2);
        } else {
            for (File file : this.fileSequence()) {
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                process$.invoke(string, FilesKt.readText$default((File)file, null, (int)1, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<File> fileSequence() {
        Iterator iterator;
        if (patterns.isEmpty()) {
            iterator = Glob.from((String[])new String[]{"**/*.kt", "**/*.kts"}).iterate(Paths.get(workDir, new String[0]), new Glob.IterationOption[]{Glob.IterationOption.SKIP_HIDDEN});
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)patterns;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string2 = INSTANCE.expandTilde((String)it);
                collection.add(string2);
            }
            $receiver$iv = (List)destination$iv$iv;
            Iterable thisCollection$iv = $receiver$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            iterator = Glob.from((String[])Arrays.copyOf(stringArray, stringArray.length)).iterate(Paths.get(workDir, new String[0]));
        }
        return SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)fileSequence.2.INSTANCE);
    }

    private final void installGitPreCommitHook() {
        byte[] byArray;
        if (!new File(".git").isDirectory()) {
            System.err.println(".git directory not found. Are you sure you are inside project root directory?");
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        File hooksDir = new File(".git", "hooks");
        PreprocessorKt.mkdirsOrFail((File)hooksDir);
        File preCommitHookFile = new File(hooksDir, "pre-commit");
        byte[] expectedPreCommitHook = ByteStreamsKt.readBytes$default((InputStream)ClassLoader.getSystemClassLoader().getResourceAsStream("ktlint-git-pre-commit-hook" + (android ? "-android" : "") + ".sh"), (int)0, (int)1, null);
        try {
            byArray = FilesKt.readBytes((File)preCommitHookFile);
        }
        catch (FileNotFoundException e) {
            byArray = null;
        }
        byte[] actualPreCommitHook = byArray;
        if (actualPreCommitHook != null && !((byArray = actualPreCommitHook).length == 0) && !Arrays.equals(actualPreCommitHook, expectedPreCommitHook)) {
            File backupFile = new File(hooksDir, "pre-commit.ktlint-backup." + this.hex(actualPreCommitHook));
            System.err.println(".git/hooks/pre-commit -> " + backupFile);
            FilesKt.copyTo$default((File)preCommitHookFile, (File)backupFile, (boolean)true, (int)0, (int)4, null);
        }
        FilesKt.writeBytes((File)preCommitHookFile, (byte[])expectedPreCommitHook);
        preCommitHookFile.setExecutable(true);
        System.err.println(".git/hooks/pre-commit installed");
    }

    private final void applyToIDEA() {
        try {
            Path workDir = Paths.get(".", new String[0]);
            if (!forceApply) {
                Path path = workDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"workDir");
                Path[] fileList = IntellijIDEAIntegration.INSTANCE.apply(path, true, android);
                System.err.println("The following files are going to be updated:\n\n\t" + ArraysKt.joinToString$default((Object[])fileList, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null) + "\n\nDo you wish to proceed? [y/n]\n" + "(in future, use -y flag if you wish to skip confirmation)");
                Scanner scanner = new Scanner(System.in);
                String res2 = (String)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(scanner){
                    final /* synthetic */ Scanner $scanner;

                    @Nullable
                    public final String invoke() {
                        String string;
                        try {
                            string = this.$scanner.next();
                        }
                        catch (NoSuchElementException e) {
                            string = null;
                        }
                        return string;
                    }
                    {
                        this.$scanner = scanner;
                        super(0);
                    }
                })), (Function1)applyToIDEA.res.2.INSTANCE));
                if (!StringsKt.equals((String)"y", (String)res2, (boolean)true)) {
                    System.err.println("(update canceled)");
                    int n = 1;
                    System.exit(n);
                    throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
            Path path = workDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"workDir");
            IntellijIDEAIntegration.INSTANCE.apply(path, false, android);
        }
        catch (IntellijIDEAIntegration.ProjectNotFoundException e) {
            System.err.println(".idea directory not found. Are you sure you are inside project root directory?");
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        System.err.println("(updated)");
        System.err.println("\nPlease restart your IDE");
        System.err.println("(if you experience any issues please report them at https://github.com/shyiko/ktlint)");
    }

    private final String hex(byte[] input) {
        return new BigInteger(MessageDigest.getInstance("SHA-256").digest(input)).toString(16);
    }

    private final String expandTilde(String path) {
        CharSequence charSequence = path;
        Regex regex = new Regex("^~");
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.home\")");
        String string2 = string;
        return regex.replaceFirst(charSequence, string2);
    }

    private final <T> List<T> head(@NotNull List<? extends T> $receiver, int limit) {
        return limit == $receiver.size() ? $receiver : $receiver.subList(0, limit);
    }

    /*
     * WARNING - void declaration
     */
    private final MavenDependencyResolver buildDependencyResolver() {
        Collection<RemoteRepository> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        MavenDependencyResolver mavenDependencyResolver;
        File mavenLocal = new File(new File(System.getProperty("user.home"), ".m2"), "repository");
        PreprocessorKt.mkdirsOrFail((File)mavenLocal);
        Iterable iterable = repositories;
        Collection collection2 = CollectionsKt.listOf((Object[])new RemoteRepository[]{new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore")).build(), new RemoteRepository.Builder("bintray", "default", "http://jcenter.bintray.com").setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore")).build(), new RemoteRepository.Builder("jitpack", "default", "http://jitpack.io").build()});
        File file = mavenLocal;
        MavenDependencyResolver mavenDependencyResolver2 = mavenDependencyResolver;
        MavenDependencyResolver mavenDependencyResolver3 = mavenDependencyResolver;
        void var4_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String url;
            String id;
            void repository;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            int n = StringsKt.indexOf$default((CharSequence)((CharSequence)repository), (String)"=", (int)0, (boolean)false, (int)6, null);
            int $receiver22 = n;
            if ($receiver22 == -1) {
                throw (Throwable)new RuntimeException("" + (String)repository + " is not a valid repository entry " + "(make sure it's provided as <id>=<url>");
            }
            int colon = n;
            void $receiver22 = repository;
            int n2 = 0;
            void v1 = $receiver22;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v1.substring(n2, colon), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            void var12_17 = repository;
            int n3 = colon + 1;
            void v2 = var12_17;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v2.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
            RemoteRepository remoteRepository = new RemoteRepository.Builder(id, "default", url).build();
            collection.add(remoteRepository);
        }
        collection = (List)destination$iv$iv;
        mavenDependencyResolver2(file, CollectionsKt.plus((Collection)collection2, (Iterable)collection), Intrinsics.areEqual((Object)forceUpdate, (Object)true));
        MavenDependencyResolver dependencyResolver2 = mavenDependencyResolver3;
        if (debug) {
            dependencyResolver2.setTransferEventListener((Function1<? super TransferEvent, Unit>)((Function1)buildDependencyResolver.1.INSTANCE));
        }
        return dependencyResolver2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadJARs(Lazy<MavenDependencyResolver> dependencyResolver2, List<String> artifacts) {
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.URLClassLoader");
        }
        Iterable iterable = artifacts;
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        Main main2 = this;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Iterable $receiver$iv2;
            String artifact = (String)element$iv$iv;
            if (debug) {
                System.err.println("[DEBUG] Resolving " + artifact);
            }
            try {
                void $receiver$iv$iv2;
                $receiver$iv2 = ((MavenDependencyResolver)dependencyResolver2.getValue()).resolve((Artifact)new DefaultArtifact(artifact));
                Iterator iterator = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    URL uRL = it.toURI().toURL();
                    collection.add(uRL);
                }
                $receiver$iv2 = (List)destination$iv$iv2;
            }
            catch (IllegalArgumentException e) {
                File file = new File(INSTANCE.expandTilde(artifact));
                if (!file.exists()) {
                    System.err.println("Error: " + artifact + " does not exist");
                    int n = 1;
                    System.exit(n);
                    throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                $receiver$iv2 = CollectionsKt.listOf((Object)file.toURI().toURL());
            }
            catch (RepositoryException e) {
                if (debug) {
                    e.printStackTrace();
                }
                System.err.println("Error: " + artifact + " wasn't found");
                int file = 1;
                System.exit(file);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            Iterable result = $receiver$iv2;
            if (debug) {
                $receiver$iv2 = result;
                for (Object element$iv : $receiver$iv2) {
                    URL url = (URL)element$iv;
                    System.err.println("[DEBUG] Loading " + url);
                }
            }
            if (!skipClasspathCheck) {
                boolean bl;
                block21: {
                    URL it;
                    boolean bl2;
                    block20: {
                        $receiver$iv2 = result;
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $receiver$iv2) {
                                it = (URL)element$iv;
                                if (!StringsKt.startsWith$default((String)StringsKt.substringAfterLast$default((String)it.toString(), (String)"/", null, (int)2, null), (String)"ktlint-core-", (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block20;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        System.err.println('\"' + artifact + "\" appears to have a runtime/compile dependency on \"ktlint-core\".\n" + "Please inform the author that \"com.github.shyiko:ktlint*\" should be marked " + "compileOnly (Gradle) / provided (Maven).\n" + "(to suppress this warning use --skip-classpath-check)");
                    }
                    if (($receiver$iv2 = result) instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            it = (URL)element$iv;
                            if (!StringsKt.startsWith$default((String)StringsKt.substringAfterLast$default((String)it.toString(), (String)"/", null, (int)2, null), (String)"kotlin-stdlib-", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    System.err.println('\"' + artifact + "\" appears to have a runtime/compile dependency on \"kotlin-stdlib\".\n" + "Please inform the author that \"org.jetbrains.kotlin:kotlin-stdlib*\" should be marked " + "compileOnly (Gradle) / provided (Maven).\n" + "(to suppress this warning use --skip-classpath-check)");
                }
            }
            Iterable list$iv$iv = result;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        main2.addURLs(uRLClassLoader, list);
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<String, String> parseQuery(String query) {
        void $receiver$iv;
        LinkedHashMap<String, String> initial$iv;
        Iterable iterable = StringsKt.split$default((CharSequence)query, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        LinkedHashMap<String, String> accumulator$iv = initial$iv = new LinkedHashMap<String, String>();
        for (Object element$iv : $receiver$iv) {
            void s;
            String string = (String)element$iv;
            LinkedHashMap<String, String> map = accumulator$iv;
            Object object = (String[])s;
            if (!(object.length() == 0)) {
                Object object2;
                Object e;
                object = new String[]{"="};
                boolean bl = false;
                int n = 2;
                Object object3 = e = (object = StringsKt.split$default((CharSequence)((CharSequence)s), (String[])object, (boolean)bl, (int)n, (int)2, null));
                int n2 = 1;
                Object e2 = e.get(0);
                LinkedHashMap<String, String> linkedHashMap = map;
                if (n2 <= CollectionsKt.getLastIndex((List)object3)) {
                    object2 = object3.get(n2);
                } else {
                    int it = n2;
                    object2 = "true";
                }
                Object object4 = object2;
                linkedHashMap.put((String)e2, URLDecoder.decode((String)object4, "UTF-8"));
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    private final void lint(String fileName, String text, Iterable<RuleSet> ruleSets, Map<String, String> userData2, Function1<? super LintError, Unit> cb) {
        if (StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true)) {
            KtLint.INSTANCE.lint(text, ruleSets, userData2, cb);
        } else {
            KtLint.INSTANCE.lintScript(text, ruleSets, userData2, cb);
        }
    }

    private final String format(String fileName, String text, Iterable<RuleSet> ruleSets, Map<String, String> userData2, Function2<? super LintError, ? super Boolean, Unit> cb) {
        return StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true) ? KtLint.INSTANCE.format(text, ruleSets, userData2, cb) : KtLint.INSTANCE.formatScript(text, ruleSets, userData2, cb);
    }

    private final void addURLs(@NotNull URLClassLoader $receiver, Iterable<URL> url) {
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        Iterable<URL> $receiver$iv = url;
        Iterator<URL> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            URL element$iv;
            URL it = element$iv = iterator.next();
            method.invoke((Object)$receiver, it);
        }
    }

    private final <T> void parallel(@NotNull Sequence<? extends Callable<T>> $receiver, Function1<? super T, Unit> cb, int numberOfThreads) {
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw (Throwable)new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
                throw (Throwable)new UnsupportedOperationException();
            }

            public T get() {
                throw (Throwable)new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw (Throwable)new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw (Throwable)new UnsupportedOperationException();
            }
        };
        Thread consumer2 = new Thread(new Runnable(q, pill2, cb){
            final /* synthetic */ ArrayBlockingQueue $q;
            final /* synthetic */ parallel.pill.1 $pill;
            final /* synthetic */ Function1 $cb;

            public final void run() {
                Future future;
                while ((future = (Future)this.$q.poll(Long.MAX_VALUE, TimeUnit.NANOSECONDS)) != this.$pill) {
                    this.$cb.invoke(future.get());
                }
            }
            {
                this.$q = arrayBlockingQueue;
                this.$pill = var2_2;
                this.$cb = function1;
            }
        });
        consumer2.start();
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (Callable v : $receiver) {
            q.put(executorService.submit(v));
        }
        q.put(pill2);
        executorService.shutdown();
        consumer2.join();
    }

    static /* bridge */ /* synthetic */ void parallel$default(Main main2, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        main2.parallel(sequence, function1, n);
    }

    private Main() {
    }

    static {
        Main main2;
        INSTANCE = main2 = new Main();
        DEPRECATED_FLAGS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"--ruleset-repository", (Object)"--repository"), TuplesKt.to((Object)"--reporter-repository", (Object)"--repository"), TuplesKt.to((Object)"--ruleset-update", (Object)"--repository-update"), TuplesKt.to((Object)"--reporter-update", (Object)"--repository-update")});
        limit = -1;
        reporters = new ArrayList();
        repositories = new ArrayList();
        repositoriesDeprecated = new ArrayList();
        rulesets = new ArrayList();
        patterns = new ArrayList();
        workDir = new File(".").getCanonicalPath();
    }

    @NotNull
    public static final /* synthetic */ MavenDependencyResolver access$buildDependencyResolver(Main $this) {
        return $this.buildDependencyResolver();
    }

    public static final /* synthetic */ String access$location(Main $this, @NotNull File $receiver) {
        return $this.location($receiver);
    }

    public static final /* synthetic */ boolean access$getDebug$p(Main $this) {
        Main main2 = $this;
        return debug;
    }

    public static final /* synthetic */ void access$setDebug$p(Main $this, boolean bl) {
        Main main2 = $this;
        debug = bl;
    }

    public static final /* synthetic */ boolean access$getFormat$p(Main $this) {
        Main main2 = $this;
        return format;
    }

    public static final /* synthetic */ void access$setFormat$p(Main $this, boolean bl) {
        Main main2 = $this;
        format = bl;
    }

    @NotNull
    public static final /* synthetic */ String access$format(Main $this, @NotNull String fileName, @NotNull String text, @NotNull Iterable ruleSets, @NotNull Map userData2, @NotNull Function2 cb) {
        return $this.format(fileName, text, ruleSets, userData2, (Function2<? super LintError, ? super Boolean, Unit>)cb);
    }

    @NotNull
    public static final /* synthetic */ LintError access$toLintError(Main $this, @NotNull Exception $receiver) {
        return $this.toLintError($receiver);
    }

    public static final /* synthetic */ boolean access$getStdin$p(Main $this) {
        Main main2 = $this;
        return stdin;
    }

    public static final /* synthetic */ void access$setStdin$p(Main $this, boolean bl) {
        Main main2 = $this;
        stdin = bl;
    }

    public static final /* synthetic */ void access$lint(Main $this, @NotNull String fileName, @NotNull String text, @NotNull Iterable ruleSets, @NotNull Map userData2, @NotNull Function1 cb) {
        $this.lint(fileName, text, ruleSets, userData2, (Function1<? super LintError, Unit>)cb);
    }

    public static final /* synthetic */ int access$getLimit$p(Main $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ void access$setLimit$p(Main $this, int n) {
        Main main2 = $this;
        limit = n;
    }

    @NotNull
    public static final /* synthetic */ List access$head(Main $this, @NotNull List $receiver, int limit) {
        return $this.head($receiver, limit);
    }

    public static final /* synthetic */ boolean access$getColor$p(Main $this) {
        Main main2 = $this;
        return color;
    }

    public static final /* synthetic */ void access$setColor$p(Main $this, boolean bl) {
        Main main2 = $this;
        color = bl;
    }
}

