/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Messages;

public class ActionMarkCompleted
extends SelectionProviderAction {
    public ActionMarkCompleted(ISelectionProvider provider) {
        super(provider, Messages.getString("markCompletedAction.title"));
        this.setEnabled(false);
    }

    public void run() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    Iterator iterator = ActionMarkCompleted.this.getStructuredSelection().iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof IMarker)) continue;
                        IMarker marker = (IMarker)obj;
                        try {
                            marker.setAttribute("done", true);
                        }
                        catch (CoreException e) {}
                    }
                }
            }, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IMarker)) {
                return;
            }
            IMarker marker = (IMarker)obj;
            if (!marker.getAttribute("userEditable", true)) {
                return;
            }
            if (!marker.getAttribute("done", false)) continue;
            return;
        }
        this.setEnabled(true);
    }
}

