/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class CompositeReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IReconcilingStrategy[] fStrategies;

    public void setReconcilingStrategies(IReconcilingStrategy[] strategies) {
        this.fStrategies = strategies;
    }

    public IReconcilingStrategy[] getReconcilingStrategies() {
        return this.fStrategies;
    }

    public void setDocument(IDocument document) {
        if (this.fStrategies == null) {
            return;
        }
        for (int i = 0; i < this.fStrategies.length; ++i) {
            this.fStrategies[i].setDocument(document);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.fStrategies == null) {
            return;
        }
        for (int i = 0; i < this.fStrategies.length; ++i) {
            this.fStrategies[i].reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        if (this.fStrategies == null) {
            return;
        }
        for (int i = 0; i < this.fStrategies.length; ++i) {
            this.fStrategies[i].reconcile(partition);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (this.fStrategies == null) {
            return;
        }
        for (int i = 0; i < this.fStrategies.length; ++i) {
            if (!(this.fStrategies[i] instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)this.fStrategies[i];
            extension.setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        if (this.fStrategies == null) {
            return;
        }
        for (int i = 0; i < this.fStrategies.length; ++i) {
            if (!(this.fStrategies[i] instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)this.fStrategies[i];
            extension.initialReconcile();
        }
    }
}

