/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class SelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaModelException {
        ISelection selection;
        if (part instanceof JavaEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((JavaEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IJavaElement[] result = new IJavaElement[selection.size()];
            int i = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IJavaElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IJavaElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(JavaEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IJavaElement[] codeResolveOrInput(JavaEditor editor) throws JavaModelException {
        ITextSelection selection;
        IJavaElement input = SelectionConverter.getInput(editor);
        IJavaElement[] result = SelectionConverter.codeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IJavaElement[]{input};
        }
        return result;
    }

    public static IJavaElement[] codeResolveOrInputHandled(JavaEditor editor, Shell shell, String title) {
        try {
            return SelectionConverter.codeResolveOrInput(editor);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, ActionMessages.getString("SelectionConverter.codeResolve_failed"));
            return null;
        }
    }

    public static IJavaElement codeResolveOrInput(JavaEditor editor, Shell shell, String title, String message) throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolveOrInput(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        IJavaElement candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectJavaElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static IJavaElement codeResolveOrInputHandled(JavaEditor editor, Shell shell, String title, String message) {
        try {
            return SelectionConverter.codeResolveOrInput(editor, shell, title, message);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, ActionMessages.getString("SelectionConverter.codeResolveOrInput_failed"));
            return null;
        }
    }

    public static IJavaElement[] codeResolve(JavaEditor editor) throws JavaModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement codeResolve(JavaEditor editor, Shell shell, String title, String message) throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolve(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        IJavaElement candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectJavaElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static IJavaElement[] codeResolveHandled(JavaEditor editor, Shell shell, String title) {
        try {
            return SelectionConverter.codeResolve(editor);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, ActionMessages.getString("SelectionConverter.codeResolve_failed"));
            return null;
        }
    }

    public static IJavaElement getElementAtOffset(JavaEditor editor) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IType getTypeAtOffset(JavaEditor editor) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element = SelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = SelectionConverter.getInputAsCompilationUnit(editor)) != null) {
            type = unit.findPrimaryType();
        }
        return type;
    }

    public static IJavaElement getInput(JavaEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public static ICompilationUnit getInputAsCompilationUnit(JavaEditor editor) {
        IJavaElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    public static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            IJavaElement[] elements;
            if (input instanceof ICompilationUnit) {
                JavaModelUtil.reconcile((ICompilationUnit)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaModelUtil.reconcile(cunit);
            IJavaElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IJavaElement resolveEnclosingElement(JavaEditor editor, ITextSelection selection) throws JavaModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput(editor), selection);
    }

    public static IJavaElement resolveEnclosingElement(IJavaElement input, ITextSelection selection) throws JavaModelException {
        IJavaElement atOffset = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaModelUtil.reconcile(cunit);
            atOffset = cunit.getElementAt(selection.getOffset());
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(selection.getOffset());
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IJavaElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }
}

