/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.JavaElementMapper;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusCodes;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.structure.InstanceMethodMover;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

class InstanceMethodMover {
    private final Method fMethodToMove;
    private NewReceiver fNewReceiver;
    private String fNewMethodName;
    private String fOriginalReceiverParameterName;
    private boolean fInlineDelegator;
    private boolean fRemoveDelegator;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;

    public static InstanceMethodMover create(MethodDeclaration declaration, ICompilationUnit declarationCU, CodeGenerationSettings codeGenSettings) {
        Method method = Method.create(declaration, declarationCU, codeGenSettings);
        if (method == null) {
            return null;
        }
        return new InstanceMethodMover(method);
    }

    private InstanceMethodMover(Method method) {
        Assert.isNotNull(method);
        this.fMethodToMove = method;
        this.fInlineDelegator = true;
        this.fRemoveDelegator = true;
        this.fNewMethodName = this.fMethodToMove.getName();
        this.fOriginalReceiverParameterName = this.guessOriginalReceiverParameterName();
    }

    private String guessOriginalReceiverParameterName() {
        ITypeBinding type = this.fMethodToMove.getDeclaringClass();
        String typeName = InstanceMethodMover.getQualifiedName(type);
        if (typeName.length() == 0) {
            return "";
        }
        String[] candidates = NamingConventions.suggestArgumentNames((IJavaProject)this.fMethodToMove.getProject(), (String)"", (String)typeName, (int)type.getDimensions(), (String[])this.getExcludedParameterNames());
        if (candidates.length > 0) {
            return candidates[0];
        }
        return "";
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return InstanceMethodMover.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private String[] getExcludedParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        MethodDeclaration methodDeclaration = this.fMethodToMove.getMethodDeclaration();
        List params = methodDeclaration.parameters();
        for (int i = 0; i < params.size(); ++i) {
            names.add(((SingleVariableDeclaration)params.get(i)).getName().getIdentifier());
        }
        Block body = methodDeclaration.getBody();
        if (body != null) {
            IBinding[] variableBindings = new ScopeAnalyzer((CompilationUnit)methodDeclaration.getRoot()).getDeclarationsAfter(body.getStartPosition(), 2);
            for (int i = 0; i < variableBindings.length; ++i) {
                names.add(variableBindings[i].getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public MoveInstanceMethodRefactoring.INewReceiver[] getPossibleNewReceivers() {
        return this.fMethodToMove.getPossibleNewReceivers();
    }

    public void chooseNewReceiver(MoveInstanceMethodRefactoring.INewReceiver chosen) {
        Assert.isTrue(Arrays.asList(this.getPossibleNewReceivers()).contains(chosen));
        this.fNewReceiver = (NewReceiver)chosen;
    }

    public String getNewMethodName() {
        return this.fNewMethodName;
    }

    public void setNewMethodName(String newMethodName) {
        Assert.isNotNull(newMethodName);
        this.fNewMethodName = newMethodName;
    }

    public String getOriginalReceiverParameterName() {
        return this.fOriginalReceiverParameterName;
    }

    public void setOriginalReceiverParameterName(String originalReceiverParameterName) {
        Assert.isNotNull(originalReceiverParameterName);
        this.fOriginalReceiverParameterName = originalReceiverParameterName;
    }

    public void setInlineDelegator(boolean inlineDelegator) {
        this.fInlineDelegator = inlineDelegator;
        this.checkInvariant();
    }

    public void setRemoveDelegator(boolean removeDelegator) {
        this.fRemoveDelegator = removeDelegator;
        this.checkInvariant();
    }

    public boolean getInlineDelegator() {
        return this.fInlineDelegator;
    }

    public boolean getRemoveDelegator() {
        return this.fRemoveDelegator;
    }

    private void checkInvariant() {
        if (this.fRemoveDelegator) {
            Assert.isTrue(this.fInlineDelegator);
        }
    }

    private static IType getModelClass(ITypeBinding clazz, IJavaProject dependentProject) throws JavaModelException {
        Assert.isTrue(clazz.isClass());
        IType modelClass = Bindings.findType(clazz, dependentProject);
        if (modelClass == null || !modelClass.exists()) {
            return null;
        }
        Assert.isTrue(modelClass.isClass());
        return modelClass;
    }

    public RefactoringStatus checkInitialState() {
        return this.fMethodToMove.checkCanBeMoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RefactoringStatus checkInput(IProgressMonitor pm, Object validationContext) throws JavaModelException {
        pm.beginTask("", 1);
        try {
            Assert.isNotNull(this.fNewReceiver, "New receiver must be chosen before checkInput(..) is called.");
            RefactoringStatus refactoringStatus = this.fNewReceiver.checkMoveOfMethodToMe(this.fMethodToMove, this.fNewMethodName, this.fOriginalReceiverParameterName, this.fInlineDelegator, this.fRemoveDelegator, validationContext);
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            Change change = this.fNewReceiver.moveMethodToMe(this.fMethodToMove, this.fNewMethodName, this.fOriginalReceiverParameterName, this.fInlineDelegator, this.fRemoveDelegator);
            return change;
        }
        finally {
            pm.done();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TextBufferPortion {
        private final TextBuffer fBuffer;
        private final RangeMarker fMarker;

        TextBufferPortion(TextBuffer buffer, RangeMarker marker) {
            Assert.isNotNull(buffer);
            Assert.isNotNull(marker);
            this.fBuffer = buffer;
            this.fMarker = marker;
        }

        public String getContent() {
            return this.fBuffer.getContent(this.fMarker.getOffset(), this.fMarker.getLength());
        }

        public String getUnindentedContentIgnoreFirstLine() {
            return Strings.changeIndent(this.fBuffer.getContent(this.fMarker.getOffset(), this.fMarker.getLength()), this.fBuffer.getLineIndent(this.fBuffer.getLineOfOffset(this.fMarker.getOffset()), CodeFormatterUtil.getTabWidth()), CodeFormatterUtil.getTabWidth(), "", this.fBuffer.getLineDelimiter());
        }
    }

    private static class Parameter
    implements IParameter {
        private final Method fMethod;
        private final IVariableBinding fBinding;

        private Parameter(Method method, IVariableBinding binding) {
            Assert.isNotNull(method);
            Assert.isNotNull(binding);
            Assert.isTrue(!binding.isField());
            this.fMethod = method;
            this.fBinding = binding;
        }

        public String getName() {
            return this.fBinding.getName();
        }

        public ITypeBinding getType() {
            return this.fBinding.getType();
        }

        public Method getMethod() {
            return this.fMethod;
        }

        public boolean isFinal() {
            return Modifier.isFinal((int)this.fBinding.getModifiers());
        }

        public SimpleName createReference() {
            return this.fMethod.createParameterReference(this);
        }

        public IVariableBinding getBinding() {
            return this.fBinding;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            Parameter otherParam = (Parameter)o;
            return this.getName().equals(otherParam.getName()) && this.getMethod().equals(otherParam.getMethod());
        }
    }

    static class Method {
        private final ICompilationUnit fDeclaringCU;
        private final MethodDeclaration fMethodNode;
        private final ITypeBinding fDeclaringClass;
        private final CodeGenerationSettings fCodeGenSettings;
        private NewReceiver[] fPossibleNewReceivers;

        static Method create(MethodDeclaration declaration, ICompilationUnit declaringCU, CodeGenerationSettings codeGenSettings) {
            ITypeBinding declaringClass = Method.getDeclaringClassBinding(declaration);
            if (declaringClass == null) {
                return null;
            }
            return new Method(declaration, declaringCU, codeGenSettings, declaringClass);
        }

        private Method(MethodDeclaration declaration, ICompilationUnit declaringCU, CodeGenerationSettings codeGenSettings, ITypeBinding declaringClass) {
            Assert.isNotNull(declaringCU);
            Assert.isTrue(declaringCU.exists());
            Assert.isNotNull(declaration);
            Assert.isNotNull(codeGenSettings);
            Assert.isNotNull(declaringClass);
            this.fDeclaringCU = declaringCU;
            this.fMethodNode = declaration;
            this.fDeclaringClass = declaringClass;
            this.fCodeGenSettings = codeGenSettings;
        }

        public Expression createFieldReference(IVariableBinding field) {
            Assert.isTrue(field.isField());
            if (this.parameterShadows(field)) {
                return this.createThisFieldAccess(field);
            }
            return this.createFieldName(field);
        }

        private boolean parameterShadows(IVariableBinding field) {
            Parameter[] params = this.getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].getName().equals(field.getName())) continue;
                return true;
            }
            return false;
        }

        private Expression createThisFieldAccess(IVariableBinding field) {
            FieldAccess access = this.fMethodNode.getAST().newFieldAccess();
            access.setExpression((Expression)this.fMethodNode.getAST().newThisExpression());
            access.setName(this.createFieldName(field));
            return access;
        }

        private SimpleName createFieldName(IVariableBinding field) {
            return this.fMethodNode.getAST().newSimpleName(field.getName());
        }

        private Block getBody() {
            Block body = this.fMethodNode.getBody();
            Assert.isNotNull(body);
            return body;
        }

        MethodDeclaration getMethodDeclaration() {
            return this.fMethodNode;
        }

        public SingleVariableDeclaration addNewFirstParameter(ITypeBinding parameterType, String parameterName) {
            Assert.isNotNull(parameterType);
            Assert.isNotNull(parameterName);
            Assert.isTrue(parameterType.isClass() || parameterType.isInterface());
            SingleVariableDeclaration newDecl = this.fMethodNode.getAST().newSingleVariableDeclaration();
            newDecl.setType((Type)this.fMethodNode.getAST().newSimpleType((Name)this.fMethodNode.getAST().newSimpleName(parameterType.getName())));
            newDecl.setName(this.fMethodNode.getAST().newSimpleName(parameterName));
            this.fMethodNode.parameters().add(0, newDecl);
            return newDecl;
        }

        public Delegation getPotentialDelegationTo(NewReceiver newReceiver) {
            Assert.isNotNull(newReceiver);
            Assert.isTrue(Arrays.asList(this.getPossibleNewReceivers()).contains(newReceiver));
            return new Delegation(this, newReceiver);
        }

        private SimpleName getNameNode() {
            return this.fMethodNode.getName();
        }

        Name[] getVariableReferences(IVariableBinding variable) {
            Assert.isNotNull(variable);
            ArrayList result = new ArrayList();
            this.fMethodNode.accept((ASTVisitor)new HierarchicalASTVisitor(this, variable, result){
                private final /* synthetic */ IVariableBinding val$variable;
                private final /* synthetic */ List val$result;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$variable = val$variable;
                    this.val$result = val$result;
                }

                public boolean visit(Name name) {
                    Assert.isNotNull(name);
                    IBinding binding = name.resolveBinding();
                    if (binding == null) {
                        return true;
                    }
                    if (!(binding instanceof IVariableBinding)) {
                        return true;
                    }
                    if (this.areSameVariable(this.val$variable, (IVariableBinding)binding) && !this.isDeclaredNamePartOfDeclaration(name)) {
                        this.val$result.add(name);
                        return false;
                    }
                    return true;
                }

                private boolean isDeclaredNamePartOfDeclaration(Name name) {
                    ASTNode parent = name.getParent();
                    if (!(parent instanceof VariableDeclaration)) {
                        return false;
                    }
                    if (parent instanceof VariableDeclarationFragment) {
                        VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
                        return name.equals((Object)fragment.getName());
                    }
                    if (parent instanceof SingleVariableDeclaration) {
                        SingleVariableDeclaration decl = (SingleVariableDeclaration)parent;
                        return name.equals((Object)decl.getName());
                    }
                    Assert.isTrue(false);
                    return false;
                }

                private boolean areSameVariable(IVariableBinding one, IVariableBinding other) {
                    return one.equals(other);
                }
            });
            return result.toArray(new Name[result.size()]);
        }

        private static ITypeBinding getDeclaringClassBinding(MethodDeclaration decl) {
            Assert.isNotNull(decl);
            IMethodBinding binding = decl.resolveBinding();
            if (binding == null) {
                return null;
            }
            return binding.getDeclaringClass();
        }

        public String getName() {
            return this.fMethodNode.getName().getIdentifier();
        }

        private ITypeBinding[] getParameterTypes() {
            Parameter[] params = this.getParameters();
            ITypeBinding[] types = new ITypeBinding[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getType();
            }
            return types;
        }

        public Parameter[] getParameters() {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            Iterator it = this.fMethodNode.parameters().iterator();
            while (it.hasNext()) {
                IVariableBinding paramBinding = ((SingleVariableDeclaration)it.next()).resolveBinding();
                if (paramBinding == null) {
                    return new Parameter[0];
                }
                parameters.add(new Parameter(this, paramBinding));
            }
            return parameters.toArray(new Parameter[parameters.size()]);
        }

        public ITypeBinding getDeclaringClass() {
            return this.fDeclaringClass;
        }

        public ICompilationUnit getDeclaringCU() {
            return this.fDeclaringCU;
        }

        private IJavaProject getProject() {
            return this.getDeclaringCU().getJavaProject();
        }

        public RefactoringStatus checkCanBeMoved() {
            if (this.isStatic()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.no_static_methods"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.CANNOT_MOVE_STATIC, null);
            }
            if (this.isAbstract()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.single_implementation"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.SELECT_METHOD_IMPLEMENTATION, null);
            }
            if (this.isNative()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.no_native_methods"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.CANNOT_MOVE_NATIVE, null);
            }
            if (this.isSynchronized()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.no_synchronized_methods"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.CANNOT_MOVE_SYNCHRONIZED, null);
            }
            if (this.isConstructor()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.no_constructors"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.CANNOT_MOVE_CONSTRUCTOR, null);
            }
            if (this.hasSuperReferences()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.uses_super"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.SUPER_REFERENCES_NOT_ALLOWED, null);
            }
            if (this.refersToEnclosingInstances()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.refers_enclosing_instances"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.ENCLOSING_INSTANCE_REFERENCES_NOT_ALLOWED, null);
            }
            if (this.mayBeDirectlyRecursive()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.potentially_recursive"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.CANNOT_MOVE_RECURSIVE, null);
            }
            if (this.getPossibleNewReceivers().length == 0) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.cannot_be_moved"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.NO_NEW_RECEIVERS, null);
            }
            return new RefactoringStatus();
        }

        private boolean hasSuperReferences() {
            class SuperReferenceChecker
            extends ASTVisitor {
                private boolean fSuperReferencesFound;
                private final /* synthetic */ Method this$0;

                SuperReferenceChecker(Method this$0) {
                    this.this$0 = this$0;
                    this.fSuperReferencesFound = false;
                }

                public boolean superReferencesFound() {
                    return this.fSuperReferencesFound;
                }

                public boolean visit(AnonymousClassDeclaration node) {
                    return false;
                }

                public boolean visit(TypeDeclaration node) {
                    return false;
                }

                public boolean visit(SuperFieldAccess node) {
                    this.fSuperReferencesFound = true;
                    return false;
                }

                public boolean visit(SuperMethodInvocation node) {
                    this.fSuperReferencesFound = true;
                    return false;
                }
            }
            SuperReferenceChecker checker = new SuperReferenceChecker(this);
            this.fMethodNode.accept((ASTVisitor)checker);
            return checker.superReferencesFound();
        }

        private boolean isStatic() {
            return Modifier.isStatic((int)this.getModifiers());
        }

        private boolean isNative() {
            return Modifier.isNative((int)this.getModifiers());
        }

        private boolean isConstructor() {
            IMethodBinding binding = this.fMethodNode.resolveBinding();
            Assert.isNotNull(binding);
            return binding.isConstructor();
        }

        private boolean isSynchronized() {
            return Modifier.isSynchronized((int)this.getModifiers());
        }

        private boolean isAbstract() {
            return this.getDeclaringClass().isInterface() || Modifier.isAbstract((int)this.getModifiers());
        }

        private boolean refersToEnclosingInstances() {
            class EnclosingInstanceReferenceChecker
            extends ASTVisitor {
                private boolean fEnclosingInstanceReferencesFound;
                private final /* synthetic */ Method this$0;

                EnclosingInstanceReferenceChecker(Method this$0) {
                    this.this$0 = this$0;
                    this.fEnclosingInstanceReferencesFound = false;
                }

                public boolean enclosingInstanceReferencesFound() {
                    return this.fEnclosingInstanceReferencesFound;
                }

                public boolean visit(ThisExpression node) {
                    if (node.getQualifier() != null) {
                        this.fEnclosingInstanceReferencesFound = true;
                    }
                    return false;
                }
            }
            EnclosingInstanceReferenceChecker checker = new EnclosingInstanceReferenceChecker(this);
            this.fMethodNode.accept((ASTVisitor)checker);
            return checker.enclosingInstanceReferencesFound();
        }

        private boolean mayBeDirectlyRecursive() {
            Assert.isTrue(!this.hasSuperReferences());
            class RecursionChecker
            extends ASTVisitor {
                private boolean fMethodMayBeRecursive;
                private final /* synthetic */ Method this$0;

                RecursionChecker(Method this$0) {
                    this.this$0 = this$0;
                    this.fMethodMayBeRecursive = false;
                }

                public boolean mayBeRecursive() {
                    Method.access$1900(this.this$0).accept((ASTVisitor)this);
                    return this.fMethodMayBeRecursive;
                }

                public boolean visit(MethodInvocation invocation) {
                    IMethodBinding binding = invocation.resolveMethodBinding();
                    if (binding == null) {
                        this.fMethodMayBeRecursive = true;
                        return false;
                    }
                    if (!this.isSelfSend(invocation)) {
                        return true;
                    }
                    if (this.hasSameSignature(binding)) {
                        this.fMethodMayBeRecursive = true;
                        return false;
                    }
                    return true;
                }

                private boolean hasSameSignature(IMethodBinding other) {
                    if (!this.this$0.getName().equals(other.getName())) {
                        return false;
                    }
                    return this.hasSameParameterTypes(other);
                }

                private boolean hasSameParameterTypes(IMethodBinding other) {
                    ITypeBinding[] others;
                    ITypeBinding[] mine = Method.access$2000(this.this$0);
                    if (mine.length != (others = other.getParameterTypes()).length) {
                        return false;
                    }
                    for (int i = 0; i < mine.length; ++i) {
                        if (mine[i].getKey().equals(others[i].getKey())) continue;
                        return false;
                    }
                    return true;
                }

                private boolean isSelfSend(MethodInvocation invocation) {
                    if (this.isStatic(invocation)) {
                        return false;
                    }
                    Expression receiver = invocation.getExpression();
                    return receiver == null || receiver instanceof ThisExpression;
                }

                private boolean isStatic(MethodInvocation invocation) {
                    return JdtFlags.isStatic(invocation.resolveMethodBinding());
                }
            }
            RecursionChecker checker = new RecursionChecker(this);
            return checker.mayBeRecursive();
        }

        private int getModifiers() {
            return this.getBinding().getModifiers();
        }

        public NewReceiver[] getPossibleNewReceivers() {
            if (this.fPossibleNewReceivers == null) {
                this.fPossibleNewReceivers = this.findPossibleNewReceivers();
            }
            return this.fPossibleNewReceivers;
        }

        private NewReceiver[] findPossibleNewReceivers() {
            ArrayList newReceivers = new ArrayList();
            this.addPossibleParameterNewReceivers(newReceivers);
            this.addPossibleFieldNewReceivers(newReceivers);
            return newReceivers.toArray(new NewReceiver[newReceivers.size()]);
        }

        private static boolean canAddAsPossibleNewReceiver(ITypeBinding type) {
            return type.isClass() && type.isFromSource();
        }

        private void addPossibleParameterNewReceivers(List target) {
            Assert.isNotNull(target);
            Parameter[] parameters = this.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!Method.canAddAsPossibleNewReceiver(parameters[i].getType())) continue;
                target.add(new ParameterNewReceiver(parameters[i], this.getProject(), this.fCodeGenSettings));
            }
        }

        private void addPossibleFieldNewReceivers(List target) {
            Assert.isNotNull(target);
            IVariableBinding[] fields = this.findFieldsOfSelfReadButNotWritten();
            for (int i = 0; i < fields.length; ++i) {
                if (!Method.canAddAsPossibleNewReceiver(fields[i].getType())) continue;
                target.add(new FieldNewReceiver(fields[i], this.getProject(), this.fCodeGenSettings));
            }
        }

        private IVariableBinding[] findFieldsOfSelfReadButNotWritten() {
            Collection result = this.keepFieldsNotWritten(this.findReferencedFieldsOfSelf());
            return result.toArray(new IVariableBinding[result.size()]);
        }

        private Set getKeysOfAllWrittenFields() {
            HashSet writtenFieldKeys = new HashSet();
            this.fMethodNode.accept(new ASTVisitor(this, writtenFieldKeys){
                private final /* synthetic */ HashSet val$writtenFieldKeys;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$writtenFieldKeys = val$writtenFieldKeys;
                }

                public boolean visit(Assignment assignment) {
                    this.reportExpressionModified(assignment.getLeftHandSide());
                    return true;
                }

                public boolean visit(PostfixExpression node) {
                    this.reportExpressionModified(node.getOperand());
                    return true;
                }

                public boolean visit(PrefixExpression node) {
                    this.reportExpressionModified(node.getOperand());
                    return false;
                }

                private void reportExpressionModified(Expression exp) {
                    IVariableBinding field = this.getFieldBindingIfField(exp);
                    if (field != null) {
                        this.reportFieldWritten(field);
                    }
                }

                private void reportFieldWritten(IVariableBinding field) {
                    Assert.isTrue(field.isField());
                    this.val$writtenFieldKeys.add(field.getKey());
                }

                private IVariableBinding getFieldBindingIfField(Expression exp) {
                    IVariableBinding variable;
                    IBinding binding;
                    if (exp instanceof FieldAccess) {
                        return (IVariableBinding)((FieldAccess)exp).getName().resolveBinding();
                    }
                    if (exp instanceof Name && (binding = ((Name)exp).resolveBinding()) instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField()) {
                        return variable;
                    }
                    return null;
                }
            });
            return writtenFieldKeys;
        }

        private Collection keepFieldsNotWritten(Collection fields) {
            Set writtenFieldKeys = this.getKeysOfAllWrittenFields();
            ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>();
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                IVariableBinding field = (IVariableBinding)it.next();
                Assert.isTrue(field.isField());
                if (writtenFieldKeys.contains(field.getKey())) continue;
                result.add(field);
            }
            return result;
        }

        private Collection findReferencedFieldsOfSelf() {
            HashSet fieldKeys = new HashSet();
            ArrayList result = new ArrayList();
            this.fMethodNode.accept(new ASTVisitor(this, fieldKeys, result){
                private final /* synthetic */ Set val$fieldKeys;
                private final /* synthetic */ List val$result;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$fieldKeys = val$fieldKeys;
                    this.val$result = val$result;
                }

                public boolean visit(FieldAccess node) {
                    IVariableBinding field;
                    if (node.getExpression() instanceof ThisExpression && (field = (IVariableBinding)node.getName().resolveBinding()) != null) {
                        this.fieldFound(field);
                    }
                    return true;
                }

                public boolean visit(SimpleName name) {
                    IBinding binding = name.resolveBinding();
                    if (binding != null && Method.access$2100(name)) {
                        this.fieldFound((IVariableBinding)binding);
                    }
                    return false;
                }

                private void fieldFound(IVariableBinding field) {
                    Assert.isTrue(field.isField());
                    if (!this.val$fieldKeys.contains(field.getKey())) {
                        this.val$fieldKeys.add(field.getKey());
                        this.val$result.add(field);
                    }
                }
            });
            return result;
        }

        private TextBuffer createDeclaringCUBuffer() throws JavaModelException {
            return TextBuffer.create(this.getDeclaringCU().getBuffer().getContents());
        }

        private IRegion createTextRange() {
            return new Region(this.fMethodNode.getStartPosition(), this.fMethodNode.getLength());
        }

        private OldASTRewrite createRewrite() {
            return new OldASTRewrite((ASTNode)this.fMethodNode);
        }

        public MethodEditSession createEditSession() throws JavaModelException {
            return new MethodEditSession(this);
        }

        private ThisExpression[] getExplicitThisReferences() {
            ArrayList result = new ArrayList();
            this.fMethodNode.accept(new ASTVisitor(this, result){
                private final /* synthetic */ List val$result;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$result = val$result;
                }

                public boolean visit(ThisExpression node) {
                    this.val$result.add(node);
                    return false;
                }
            });
            return result.toArray(new ThisExpression[result.size()]);
        }

        private MethodInvocation[] getImplicitThisMethodInvocations() {
            ArrayList result = new ArrayList();
            this.fMethodNode.accept(new ASTVisitor(this, result){
                private final /* synthetic */ List val$result;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$result = val$result;
                }

                public boolean visit(MethodInvocation invocation) {
                    if (invocation.resolveMethodBinding() == null) {
                        return true;
                    }
                    if (this.isImplicitThisMethodInvocation(invocation)) {
                        this.val$result.add(invocation);
                    }
                    return true;
                }

                private boolean isImplicitThisMethodInvocation(MethodInvocation invocation) {
                    return !this.isInvokedMethodStatic(invocation) && invocation.getExpression() == null;
                }

                private boolean isInvokedMethodStatic(MethodInvocation invocation) {
                    return JdtFlags.isStatic(invocation.resolveMethodBinding());
                }
            });
            return result.toArray(new MethodInvocation[result.size()]);
        }

        private SimpleName[] getImplicitThisFieldAccesses() {
            ArrayList result = new ArrayList();
            this.fMethodNode.accept(new ASTVisitor(this, result){
                private final /* synthetic */ List val$result;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$result = val$result;
                }

                public boolean visit(SimpleName name) {
                    if (Method.access$2100(name)) {
                        this.val$result.add(name);
                    }
                    return false;
                }
            });
            return result.toArray(new SimpleName[result.size()]);
        }

        public boolean hasSelfReferences(NewReceiver newReceiver) {
            return this.getExplicitThisReferences().length != 0 || this.getImplicitThisMethodInvocations().length != 0 || newReceiver.hasFieldsAccessesOtherThanToMe(this.getImplicitThisFieldAccesses());
        }

        private MethodDeclaration getDeclaration() {
            return this.fMethodNode;
        }

        private IMethodBinding getBinding() {
            IMethodBinding binding = this.fMethodNode.resolveBinding();
            Assert.isNotNull(binding);
            return binding;
        }

        public ITypeBinding getReturnType() {
            return this.getBinding().getReturnType();
        }

        public boolean hasVoidReturnType() {
            Type returnType = this.fMethodNode.getReturnType();
            if (!(returnType instanceof PrimitiveType)) {
                return false;
            }
            return PrimitiveType.VOID.equals(((PrimitiveType)returnType).getPrimitiveTypeCode());
        }

        public SimpleName createParameterReference(Parameter parameter) {
            Assert.isTrue(parameter.getMethod() == this);
            return this.fMethodNode.getAST().newSimpleName(parameter.getName());
        }

        private AST getAST() {
            return this.fMethodNode.getAST();
        }

        private SingleVariableDeclaration getParameterDeclaration(Parameter parameter) {
            Iterator decls = this.fMethodNode.parameters().iterator();
            while (decls.hasNext()) {
                SingleVariableDeclaration parameterDeclaration = (SingleVariableDeclaration)decls.next();
                if (!parameter.getBinding().equals(parameterDeclaration.resolveBinding())) continue;
                return parameterDeclaration;
            }
            Assert.isTrue(false, "Parameter must be a parameter to this method.");
            return null;
        }

        private TypeReferences getTypeReferences() {
            TypeReferences result = new TypeReferences();
            result.addAllReferences((ASTNode)this.fMethodNode);
            return result;
        }

        private Name[] findOutermostNonRightHandDotOperandNamesInBody() {
            ArrayList result = new ArrayList();
            this.fMethodNode.getBody().accept((ASTVisitor)new HierarchicalASTVisitor(this, result){
                private final /* synthetic */ List val$result;
                private final /* synthetic */ Method this$0;
                {
                    this.this$0 = this$0;
                    this.val$result = val$result;
                }

                public boolean visit(Name name) {
                    if (!Method.access$2400(name)) {
                        this.val$result.add(name);
                    }
                    return false;
                }
            });
            return result.toArray(new Name[result.size()]);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.getDeclaration().equals((Object)((Method)o).getDeclaration());
        }

        private static SimpleName getLeftmost(Name name) {
            if (name instanceof SimpleName) {
                return (SimpleName)name;
            }
            return Method.getLeftmost(((QualifiedName)name).getQualifier());
        }

        private static boolean isImplicitThisFieldAccess(SimpleName name) {
            return Method.isInstanceFieldAccess(name) && !Method.isRightDotOperand((Name)name);
        }

        private static boolean isRightDotOperand(Name name) {
            ASTNode parent = name.getParent();
            if (parent instanceof QualifiedName && ((QualifiedName)parent).getName().equals((Object)name)) {
                return true;
            }
            if (parent instanceof FieldAccess && ((FieldAccess)parent).getName().equals((Object)name)) {
                return true;
            }
            if (parent instanceof SuperFieldAccess) {
                return true;
            }
            if (parent instanceof MethodInvocation) {
                MethodInvocation invocation = (MethodInvocation)parent;
                return invocation.getExpression() != null && invocation.getName().equals((Object)name);
            }
            return false;
        }

        private static boolean isInstanceFieldAccess(SimpleName name) {
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            IVariableBinding variableBinding = (IVariableBinding)binding;
            if (!variableBinding.isField()) {
                return false;
            }
            return !Modifier.isStatic((int)variableBinding.getModifiers());
        }

        static /* synthetic */ MethodDeclaration access$1900(Method x0) {
            return x0.fMethodNode;
        }

        static /* synthetic */ ITypeBinding[] access$2000(Method x0) {
            return x0.getParameterTypes();
        }

        static /* synthetic */ boolean access$2100(SimpleName x0) {
            return Method.isImplicitThisFieldAccess(x0);
        }

        static /* synthetic */ boolean access$2400(Name x0) {
            return Method.isRightDotOperand(x0);
        }

        private static class TypeReferences
        extends HierarchicalASTVisitor {
            private HashMap fTypeKeysToUsageCounts = new HashMap();
            private HashMap fTypeKeysToATypeBinding = new HashMap();

            private TypeReferences() {
            }

            public Collection getTypesReferencedWithoutQualification() {
                return this.fTypeKeysToATypeBinding.values();
            }

            public int getNumberOfUnqualifiedReferencesTo(ITypeBinding classOrInterface) {
                Assert.isTrue(classOrInterface.isClass() || classOrInterface.isInterface());
                Integer references = this.getValueFor(classOrInterface);
                if (references == null) {
                    return 0;
                }
                return references;
            }

            public void addAllReferences(ASTNode tree) {
                tree.accept((ASTVisitor)this);
            }

            public void addOneReference(ITypeBinding classOrInterface) {
                Assert.isTrue(classOrInterface.isClass() || classOrInterface.isInterface());
                this.registerReference(classOrInterface);
            }

            public void removeOneReference(ITypeBinding classOrInterface) {
                Assert.isTrue(classOrInterface.isClass() || classOrInterface.isInterface());
                Integer value = this.getValueFor(classOrInterface);
                Assert.isTrue(value != null, "invalid argument");
                int currentReferences = value;
                Assert.isTrue(currentReferences > 0);
                if (currentReferences == 1) {
                    this.unmap(classOrInterface);
                } else {
                    this.map(classOrInterface, new Integer(currentReferences - 1));
                }
            }

            private void registerReference(ITypeBinding type) {
                Integer referencesSoFar = (Integer)this.fTypeKeysToUsageCounts.get(type.getKey());
                this.map(type, referencesSoFar == null ? new Integer(1) : new Integer(referencesSoFar + 1));
            }

            private void map(ITypeBinding binding, Integer value) {
                this.fTypeKeysToUsageCounts.put(binding.getKey(), value);
                this.fTypeKeysToATypeBinding.put(binding.getKey(), binding);
            }

            private void unmap(ITypeBinding binding) {
                this.fTypeKeysToUsageCounts.remove(binding.getKey());
                this.fTypeKeysToATypeBinding.remove(binding.getKey());
            }

            private Integer getValueFor(ITypeBinding binding) {
                return (Integer)this.fTypeKeysToUsageCounts.get(binding.getKey());
            }

            public boolean visit(Name name) {
                SimpleName leftmost = Method.getLeftmost(name);
                IBinding binding = leftmost.resolveBinding();
                if (binding instanceof ITypeBinding) {
                    this.registerReference((ITypeBinding)binding);
                }
                return false;
            }
        }

        static class MethodEditSession {
            private final Method fMethod;
            private final OldASTRewrite fRewrite;
            private TypeReferences fTypeReferences;

            private MethodEditSession(Method method) throws JavaModelException {
                Assert.isNotNull(method);
                this.fMethod = method;
                this.fRewrite = method.createRewrite();
                this.fTypeReferences = method.getTypeReferences();
            }

            public void replaceSelfReferencesWithReferencesToName(String name) {
                Assert.isNotNull(name);
                this.replaceExplicitThisReferencesWith(name);
                this.replaceImplicitThisInFieldAccessesWith(name);
                this.replaceImplicitThisInMethodInvocationsWith(name);
            }

            private boolean replaceExplicitThisReferencesWith(String name) {
                ThisExpression[] thisReferences = this.fMethod.getExplicitThisReferences();
                for (int i = 0; i < thisReferences.length; ++i) {
                    this.fRewrite.replace((ASTNode)thisReferences[i], (ASTNode)thisReferences[i].getAST().newSimpleName(name), null);
                }
                return thisReferences.length != 0;
            }

            private boolean replaceImplicitThisInFieldAccessesWith(String name) {
                SimpleName[] fieldReferences = this.fMethod.getImplicitThisFieldAccesses();
                for (int i = 0; i < fieldReferences.length; ++i) {
                    SimpleName fieldName = fieldReferences[i];
                    FieldAccess replacement = fieldName.getAST().newFieldAccess();
                    replacement.setExpression((Expression)fieldName.getAST().newSimpleName(name));
                    replacement.setName(fieldName.getAST().newSimpleName(fieldName.getIdentifier()));
                    this.fRewrite.replace((ASTNode)fieldName, (ASTNode)replacement, null);
                }
                return fieldReferences.length != 0;
            }

            private boolean replaceImplicitThisInMethodInvocationsWith(String name) {
                MethodInvocation[] methodInvocations = this.fMethod.getImplicitThisMethodInvocations();
                for (int i = 0; i < methodInvocations.length; ++i) {
                    MethodInvocation original = methodInvocations[i];
                    SimpleName newExpression = original.getAST().newSimpleName(name);
                    Assert.isTrue(original.getExpression() == null);
                    original.setExpression((Expression)newExpression);
                    this.fRewrite.markAsInserted((ASTNode)newExpression);
                }
                return methodInvocations.length != 0;
            }

            public void replaceNewReceiverReferencesWithSelfReferences(NewReceiver newReceiver) {
                Expression[] newReceiverReferences = newReceiver.getReferencesIn(this.fMethod);
                for (int i = 0; i < newReceiverReferences.length; ++i) {
                    this.replaceExpressionWithSelfReference(newReceiverReferences[i]);
                }
            }

            private void replaceExpressionWithSelfReference(Expression expression) {
                Assert.isNotNull(expression);
                ASTNode parent = expression.getParent();
                if (parent instanceof MethodInvocation) {
                    MethodInvocation invocation = (MethodInvocation)parent;
                    if (expression.equals((Object)invocation.getExpression())) {
                        this.replaceReceiverWithImplicitThis(invocation);
                    } else if (invocation.arguments().contains(expression)) {
                        this.replaceExpressionWithExplicitThis(expression);
                    } else {
                        Assert.isTrue(false, "expression should be an expression for which, syntactically, \"this\" could by substituted, so not the name in a method invocation.");
                    }
                } else if (parent instanceof FieldAccess) {
                    FieldAccess fieldAccess = (FieldAccess)parent;
                    if (fieldAccess.getExpression() instanceof ThisExpression) {
                        Assert.isTrue(expression.equals((Object)fieldAccess.getName()), "expression should syntactically be substitutable by \"this\"");
                        this.replaceExpressionWithSelfReference((Expression)fieldAccess);
                    } else {
                        Assert.isTrue(expression.equals((Object)fieldAccess.getExpression()), "expression should be an expression for which, syntactically, \"this\" could by substituted, so not the field name in a field access.");
                        this.replaceReceiverWithImplicitThis(fieldAccess);
                    }
                } else if (parent instanceof QualifiedName) {
                    QualifiedName qualifiedName = (QualifiedName)parent;
                    Assert.isTrue(MethodEditSession.isQualifiedNameUsedAsFieldAccessOnObject(qualifiedName, expression), "expression should be an expression for which, syntactically, \"this\" could by substituted.");
                    this.replaceReceiverWithImplicitThis(qualifiedName);
                } else {
                    this.replaceExpressionWithExplicitThis(expression);
                }
            }

            private void replaceReceiverWithImplicitThis(MethodInvocation invocation) {
                this.fRewrite.remove((ASTNode)invocation.getExpression(), null);
            }

            private void replaceReceiverWithImplicitThis(FieldAccess fieldAccess) {
                this.fRewrite.replace((ASTNode)fieldAccess, this.fRewrite.createCopyTarget((ASTNode)fieldAccess.getName()), null);
            }

            private void replaceReceiverWithImplicitThis(QualifiedName fieldAccess) {
                Assert.isTrue(MethodEditSession.isFieldAccess(fieldAccess));
                this.fRewrite.replace((ASTNode)fieldAccess, this.fRewrite.createCopyTarget((ASTNode)fieldAccess.getName()), null);
            }

            private void replaceExpressionWithExplicitThis(Expression expression) {
                this.fRewrite.replace((ASTNode)expression, (ASTNode)expression.getAST().newThisExpression(), null);
            }

            private static boolean isQualifiedNameUsedAsFieldAccessOnObject(QualifiedName fieldAccess, Expression object) {
                return object.equals((Object)fieldAccess.getQualifier()) && MethodEditSession.isFieldAccess(fieldAccess);
            }

            private static boolean isFieldAccess(QualifiedName qName) {
                IBinding binding = qName.resolveBinding();
                Assert.isNotNull(binding);
                return binding instanceof IVariableBinding && ((IVariableBinding)binding).isField();
            }

            public void classQualifyNonInstanceMemberReferences() {
                Name[] references = this.fMethod.findOutermostNonRightHandDotOperandNamesInBody();
                for (int i = 0; i < references.length; ++i) {
                    SimpleName leftMost = Method.getLeftmost(references[i]);
                    if (!this.isNonInstanceMemberReference(leftMost)) continue;
                    this.classQualify(leftMost);
                }
            }

            private boolean isNonInstanceMemberReference(SimpleName name) {
                if (name.getParent() instanceof ClassInstanceCreation) {
                    return false;
                }
                IBinding binding = name.resolveBinding();
                if (binding instanceof ITypeBinding) {
                    return !((ITypeBinding)binding).isLocal();
                }
                if (binding instanceof IMethodBinding) {
                    return Modifier.isStatic((int)((IMethodBinding)binding).getModifiers());
                }
                if (binding instanceof IVariableBinding) {
                    return Modifier.isStatic((int)((IVariableBinding)binding).getModifiers());
                }
                return false;
            }

            private void classQualify(SimpleName name) {
                IBinding nameBinding = name.resolveBinding();
                ITypeBinding declaring = MethodEditSession.getDeclaringClassIfMember(nameBinding);
                if (declaring == null) {
                    return;
                }
                this.fRewrite.replace((ASTNode)name, (ASTNode)name.getAST().newQualifiedName(MethodEditSession.getClassNameQualifiedToTopLevel(declaring, name.getAST()), (SimpleName)this.fRewrite.createCopyTarget((ASTNode)name)), null);
                this.fTypeReferences.addOneReference(MethodEditSession.getTopLevel(declaring));
                if (nameBinding instanceof ITypeBinding) {
                    this.fTypeReferences.removeOneReference((ITypeBinding)nameBinding);
                }
            }

            private static ITypeBinding getDeclaringClassIfMember(IBinding binding) {
                if (binding instanceof IMethodBinding) {
                    return ((IMethodBinding)binding).getDeclaringClass();
                }
                if (binding instanceof IVariableBinding) {
                    return ((IVariableBinding)binding).getDeclaringClass();
                }
                if (binding instanceof ITypeBinding) {
                    return ((ITypeBinding)binding).getDeclaringClass();
                }
                return null;
            }

            private static Name getClassNameQualifiedToTopLevel(ITypeBinding clazz, AST ast) {
                Assert.isTrue(!clazz.isAnonymous());
                SimpleName clazzName = ast.newSimpleName(clazz.getName());
                if (MethodEditSession.isTopLevel(clazz)) {
                    return clazzName;
                }
                return ast.newQualifiedName(MethodEditSession.getClassNameQualifiedToTopLevel(clazz.getDeclaringClass(), ast), clazzName);
            }

            private static ITypeBinding getTopLevel(ITypeBinding clazz) {
                Assert.isTrue(!clazz.isAnonymous());
                ITypeBinding current = clazz;
                while (!MethodEditSession.isTopLevel(current)) {
                    current = current.getDeclaringClass();
                }
                return current;
            }

            private static boolean isTopLevel(ITypeBinding clazz) {
                Assert.isNotNull(clazz);
                Assert.isTrue(!clazz.isAnonymous());
                ITypeBinding declaring = clazz.getDeclaringClass();
                return clazz.isLocal() || declaring == null || declaring.isAnonymous();
            }

            public void changeMethodName(String newName) {
                Assert.isNotNull(newName);
                SimpleName originalName = this.fMethod.getNameNode();
                if (!originalName.getIdentifier().equals(newName)) {
                    this.fRewrite.replace((ASTNode)originalName, (ASTNode)originalName.getAST().newSimpleName(newName), null);
                }
            }

            public void addNewFirstParameter(ITypeBinding parameterType, String parameterName) {
                SingleVariableDeclaration newDecl = this.fMethod.addNewFirstParameter(parameterType, parameterName);
                this.fRewrite.markAsInserted((ASTNode)newDecl);
                if (parameterType.isClass() || parameterType.isInterface()) {
                    Assert.isNotNull((Object)this.fTypeReferences, "this session has already been destroyed.");
                    this.fTypeReferences.addOneReference(parameterType);
                }
            }

            public void removeParameter(Parameter parameter) {
                this.fRewrite.remove((ASTNode)this.fMethod.getParameterDeclaration(parameter), null);
                ITypeBinding parameterType = parameter.getType();
                if (parameterType.isClass() || parameterType.isInterface()) {
                    Assert.isNotNull((Object)this.fTypeReferences, "this session has already been destroyed.");
                    this.fTypeReferences.removeOneReference(parameterType);
                }
            }

            private Block replaceBody() {
                Block originalBody = this.fMethod.getBody();
                Block newBody = originalBody.getAST().newBlock();
                this.fRewrite.replace((ASTNode)originalBody, (ASTNode)newBody, null);
                return newBody;
            }

            public void replaceBodyWithDelegation(Delegation delegation) {
                Assert.isTrue(delegation.getDelegatingMethod() == this.fMethod);
                Block newBody = this.replaceBody();
                List statements = newBody.statements();
                MethodInvocation delegatingInvocation = delegation.createDelegatingInvocation();
                Statement delegatingStatement = this.fMethod.hasVoidReturnType() ? this.createExpressionStatement((Expression)delegatingInvocation) : this.createReturnStatement((Expression)delegatingInvocation);
                statements.add(delegatingStatement);
            }

            private Statement createReturnStatement(Expression expression) {
                ReturnStatement returnStatement = expression.getAST().newReturnStatement();
                returnStatement.setExpression(expression);
                return returnStatement;
            }

            private Statement createExpressionStatement(Expression expression) {
                return expression.getAST().newExpressionStatement(expression);
            }

            public TextBufferPortion getEdittedMethodText() throws CoreException {
                TextBuffer cuBuffer = this.fMethod.createDeclaringCUBuffer();
                MultiTextEdit dummy = this.getEdits(cuBuffer);
                IRegion range = this.fMethod.createTextRange();
                RangeMarker rangeMarker = new RangeMarker(range.getOffset(), range.getLength());
                TextEdit[] edits = dummy.removeChildren();
                for (int i = 0; i < edits.length; ++i) {
                    rangeMarker.addChild(edits[i]);
                }
                MultiTextEdit allEdits = new MultiTextEdit();
                allEdits.addChild((TextEdit)rangeMarker);
                TextBufferEditor editor = new TextBufferEditor(cuBuffer);
                editor.add((TextEdit)allEdits);
                editor.performEdits(null);
                return new TextBufferPortion(cuBuffer, rangeMarker);
            }

            public MultiTextEdit getEdits() throws JavaModelException {
                return this.getEdits(this.fMethod.createDeclaringCUBuffer());
            }

            private MultiTextEdit getEdits(TextBuffer buffer) {
                MultiTextEdit rootEdit = new MultiTextEdit();
                this.fRewrite.rewriteNode(buffer, (TextEdit)rootEdit);
                return rootEdit;
            }

            public Collection getAllTypesUsedWithoutQualificationInEdittedMethod() {
                Assert.isNotNull((Object)this.fTypeReferences, "this session has already been destroyed.");
                return this.fTypeReferences.getTypesReferencedWithoutQualification();
            }

            public void clear() {
                this.fRewrite.removeModifications();
                this.fTypeReferences = this.fMethod.getTypeReferences();
            }

            public void destroy() {
                this.fRewrite.removeModifications();
                this.fTypeReferences = null;
            }
        }

        static class Delegation {
            private final NewReceiver fNewReceiver2;
            private final Method fDelegatingMethod;
            private String fCalledMethodName;
            private boolean fPassThis;
            private int fArgumentToPassThisAs;
            private final Vector fArgumentToParameterMap = new Vector();

            private Delegation(Method delegatingMethod, NewReceiver newReceiver) {
                Assert.isNotNull(newReceiver);
                this.fNewReceiver2 = newReceiver;
                this.fDelegatingMethod = delegatingMethod;
            }

            public void setCalledMethodName(String called) {
                Assert.isNotNull(called);
                this.fCalledMethodName = called;
            }

            public void passThisAsArgument(int argumentIndex) {
                Assert.isTrue(argumentIndex >= 0);
                this.notifyOfNewArgument(argumentIndex);
                this.fArgumentToPassThisAs = argumentIndex;
                this.fPassThis = true;
            }

            private void notifyOfNewArgument(int argumentIndex) {
                if (argumentIndex + 1 > this.fArgumentToParameterMap.size()) {
                    this.fArgumentToParameterMap.setSize(argumentIndex + 1);
                }
            }

            private int getNumberOfArguments() {
                return this.fArgumentToParameterMap.size();
            }

            public void mapParameterToArgument(int parameterIndex, int argumentIndex) {
                Assert.isTrue(parameterIndex >= 0);
                Assert.isTrue(parameterIndex < this.fDelegatingMethod.getParameters().length);
                Assert.isTrue(argumentIndex >= 0);
                this.notifyOfNewArgument(argumentIndex);
                this.fArgumentToParameterMap.set(argumentIndex, new Integer(parameterIndex));
            }

            private Method getDelegatingMethod() {
                return this.fDelegatingMethod;
            }

            private MethodInvocation createDelegatingInvocation() {
                Assert.isTrue(this.isComplete());
                MethodInvocation invocation = this.fDelegatingMethod.getAST().newMethodInvocation();
                invocation.setExpression(this.fNewReceiver2.createReferenceForContext(this.fDelegatingMethod));
                invocation.setName(this.fDelegatingMethod.getAST().newSimpleName(this.fCalledMethodName));
                Parameter[] params = this.fDelegatingMethod.getParameters();
                for (int i = 0; i < this.getNumberOfArguments(); ++i) {
                    if (this.fPassThis && this.fArgumentToPassThisAs == i) {
                        invocation.arguments().add(this.fDelegatingMethod.getAST().newThisExpression());
                        continue;
                    }
                    Integer parameterIndex = (Integer)this.fArgumentToParameterMap.get(i);
                    Assert.isNotNull(parameterIndex);
                    Parameter parameter = params[parameterIndex];
                    invocation.arguments().add(this.fDelegatingMethod.getAST().newSimpleName(parameter.getName()));
                }
                return invocation;
            }

            private boolean isComplete() {
                return this.fCalledMethodName != null && this.hasAllArguments();
            }

            private boolean hasAllArguments() {
                for (int i = 0; i < this.getNumberOfArguments(); ++i) {
                    if (this.hasArgument(i)) continue;
                    return false;
                }
                return true;
            }

            private boolean hasArgument(int i) {
                return this.fArgumentToParameterMap.get(i) != null || this.fPassThis && this.fArgumentToPassThisAs == i;
            }
        }
    }

    private static class FieldNewReceiver
    extends VariableNewReceiver {
        private final IVariableBinding fField;

        FieldNewReceiver(IVariableBinding fieldBinding, IJavaProject dependentProject, CodeGenerationSettings codeGenSettings) {
            super(dependentProject, codeGenSettings);
            Assert.isNotNull(fieldBinding);
            Assert.isTrue(fieldBinding.isField());
            this.fField = fieldBinding;
        }

        public boolean isField() {
            return true;
        }

        protected IVariableBinding getVariable() {
            return this.getField();
        }

        private IVariableBinding getField() {
            return this.fField;
        }

        Expression createReferenceForContext(Method context) {
            Assert.isNotNull(context);
            return context.createFieldReference(this.fField);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.getField().getKey().equals(((FieldNewReceiver)o).getField().getKey());
        }

        public int hashCode() {
            return this.getField().getKey().hashCode();
        }

        protected void transformNonReferenceMentionsIn(Method.MethodEditSession methodEditSession) {
        }

        Method.Delegation specifyDelegationToNewMethod(Method originalMethod, String newMethodName) {
            Method.Delegation delegation = originalMethod.getPotentialDelegationTo(this);
            delegation.setCalledMethodName(newMethodName);
            boolean hasSelfReferences = originalMethod.hasSelfReferences(this);
            if (hasSelfReferences) {
                delegation.passThisAsArgument(0);
            }
            int numberOfParams = originalMethod.getParameters().length;
            for (int parameterIndex = 0; parameterIndex < numberOfParams; ++parameterIndex) {
                delegation.mapParameterToArgument(parameterIndex, hasSelfReferences ? parameterIndex + 1 : parameterIndex);
            }
            return delegation;
        }

        public boolean hasFieldsAccessesOtherThanToMe(SimpleName[] fieldAccesses) {
            for (int i = 0; i < fieldAccesses.length; ++i) {
                SimpleName access = fieldAccesses[i];
                if (access.resolveBinding() == this.getField()) continue;
                return true;
            }
            return false;
        }
    }

    private static class ParameterNewReceiver
    extends VariableNewReceiver {
        private final Parameter fParameter;

        ParameterNewReceiver(Parameter parameter, IJavaProject dependentProject, CodeGenerationSettings codeGenSettings) {
            super(dependentProject, codeGenSettings);
            Assert.isNotNull(parameter);
            Assert.isTrue(parameter.getType().isClass());
            this.fParameter = parameter;
        }

        public boolean isParameter() {
            return true;
        }

        protected IVariableBinding getVariable() {
            return this.fParameter.getBinding();
        }

        Expression createReferenceForContext(Method context) {
            Assert.isTrue(context == this.fParameter.getMethod());
            return this.fParameter.createReference();
        }

        private Parameter getParameter() {
            return this.fParameter;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.getParameter().equals(((ParameterNewReceiver)o).getParameter());
        }

        public int hashCode() {
            return this.getParameter().hashCode();
        }

        protected void transformNonReferenceMentionsIn(Method.MethodEditSession methodEditSession) {
            methodEditSession.removeParameter(this.getParameter());
        }

        Method.Delegation specifyDelegationToNewMethod(Method originalMethod, String newMethodName) {
            Method.Delegation delegation = originalMethod.getPotentialDelegationTo(this);
            delegation.setCalledMethodName(newMethodName);
            boolean hasSelfReferences = originalMethod.hasSelfReferences(this);
            if (hasSelfReferences) {
                delegation.passThisAsArgument(0);
            }
            Parameter[] params = originalMethod.getParameters();
            int argumentIndex = hasSelfReferences ? 1 : 0;
            for (int parameterIndex = 0; parameterIndex < params.length; ++parameterIndex) {
                if (params[parameterIndex].equals(this.getParameter())) continue;
                delegation.mapParameterToArgument(parameterIndex, argumentIndex);
                ++argumentIndex;
            }
            return delegation;
        }

        public boolean hasFieldsAccessesOtherThanToMe(SimpleName[] fieldAccesses) {
            return fieldAccesses.length != 0;
        }
    }

    private static abstract class VariableNewReceiver
    extends NewReceiver {
        VariableNewReceiver(IJavaProject dependentProject, CodeGenerationSettings codeGenSettings) {
            super(dependentProject, codeGenSettings);
        }

        protected abstract IVariableBinding getVariable();

        public IBinding getBinding() {
            return this.getVariable();
        }

        protected final RefactoringStatus checkVariableNotWrittenInMethod(Method method) {
            return new RefactoringStatus();
        }

        protected ITypeBinding getReceiverClass() {
            return this.getVariable().getType();
        }

        public String getName() {
            return this.getVariable().getName();
        }

        Expression[] getReferencesIn(Method method) {
            return method.getVariableReferences(this.getVariable());
        }
    }

    private static abstract class NewReceiver
    implements MoveInstanceMethodRefactoring.INewReceiver {
        private final IJavaProject fDependentProject;
        private IType fModelClass;

        private NewReceiver(IJavaProject dependentProject, CodeGenerationSettings codeGenSettings) {
            Assert.isNotNull(dependentProject);
            Assert.isNotNull(codeGenSettings);
            this.fDependentProject = dependentProject;
        }

        public abstract String getName();

        public ITypeBinding getType() {
            return this.getReceiverClass();
        }

        public boolean isField() {
            return false;
        }

        public boolean isParameter() {
            return false;
        }

        protected abstract ITypeBinding getReceiverClass();

        protected ICompilationUnit getReceiverClassCU() throws JavaModelException {
            return JavaModelUtil.toWorkingCopy(this.getReceiverModelClass().getCompilationUnit());
        }

        abstract Expression[] getReferencesIn(Method var1);

        abstract Expression createReferenceForContext(Method var1);

        Change moveMethodToMe(Method method, String newMethodName, String originalReceiverParameterName, boolean inlineDelegator, boolean removeDelegator) throws CoreException {
            Assert.isNotNull(method);
            Assert.isNotNull(newMethodName);
            Assert.isNotNull(originalReceiverParameterName);
            Assert.isTrue(inlineDelegator || !removeDelegator);
            Assert.isTrue(Arrays.asList(method.getPossibleNewReceivers()).contains(this));
            TextChangeManager manager = new TextChangeManager();
            this.addMovedMethodToMyClass(manager, method, newMethodName, originalReceiverParameterName);
            this.replaceOriginalMethodBodyWithDelegation(manager, method, newMethodName);
            return NewReceiver.getChange(manager);
        }

        private static Change getChange(TextChangeManager manager) {
            TextChange[] changes = manager.getAllChanges();
            if (changes.length == 1) {
                return changes[0];
            }
            return new DynamicValidationStateChange(RefactoringCoreMessages.getString("InstanceMethodMover.move_method"), (Change[])changes);
        }

        private void replaceOriginalMethodBodyWithDelegation(TextChangeManager manager, Method originalMethod, String newMethodName) throws CoreException {
            Method.MethodEditSession methodEditSession = originalMethod.createEditSession();
            methodEditSession.replaceBodyWithDelegation(this.specifyDelegationToNewMethod(originalMethod, newMethodName));
            TextChange cuChange = manager.get(originalMethod.getDeclaringCU());
            TextChangeCompatibility.addTextEdit(cuChange, RefactoringCoreMessages.getString("InstanceMethodMover.replace_with_delegation"), (TextEdit)methodEditSession.getEdits());
        }

        abstract Method.Delegation specifyDelegationToNewMethod(Method var1, String var2);

        private void addMovedMethodToMyClass(TextChangeManager manager, Method originalMethod, String newMethodName, String originalReceiverParameterName) throws CoreException {
            ArrayList allTypesUsedWithoutQualification = new ArrayList();
            TextBufferPortion newMethodText = this.getNewMethodDeclarationText(originalMethod, newMethodName, originalReceiverParameterName, allTypesUsedWithoutQualification);
            this.addNewMethodToMyClass(manager, newMethodText.getUnindentedContentIgnoreFirstLine(), allTypesUsedWithoutQualification);
        }

        private void addNewMethodToMyClass(TextChangeManager manager, String newMethodText, List allTypesUsedWithoutQualification) throws CoreException {
            TypeDeclaration myClassDeclaration = this.getReceiverClassDeclaration();
            OldASTRewrite rewrite = new OldASTRewrite((ASTNode)myClassDeclaration);
            BodyDeclaration newMethodNode = (BodyDeclaration)rewrite.createStringPlaceholder(newMethodText, 31);
            myClassDeclaration.bodyDeclarations().add(newMethodNode);
            rewrite.markAsInserted((ASTNode)newMethodNode);
            TextBuffer buffer = TextBuffer.create(this.getReceiverClassCU().getBuffer().getContents());
            MultiTextEdit edit = new MultiTextEdit();
            rewrite.rewriteNode(buffer, (TextEdit)edit);
            rewrite.removeModifications();
            TextChange cuChange = manager.get(this.getReceiverClassCU());
            TextChangeCompatibility.addTextEdit(cuChange, RefactoringCoreMessages.getString("InstanceMethodMover.create_in_receiver"), (TextEdit)edit);
            ImportRewrite importRewrite = this.createImportRewrite(allTypesUsedWithoutQualification, this.getReceiverClassCU());
            TextChangeCompatibility.addTextEdit(cuChange, RefactoringCoreMessages.getString("InstanceMethodMover.add_imports"), importRewrite.createEdit(buffer.getDocument()));
        }

        private ImportRewrite createImportRewrite(List types, ICompilationUnit cu) throws CoreException {
            ImportRewrite importEdit = new ImportRewrite(cu);
            Iterator it = types.iterator();
            while (it.hasNext()) {
                importEdit.addImport((ITypeBinding)it.next());
            }
            return importEdit;
        }

        protected TypeDeclaration getReceiverClassDeclaration() throws JavaModelException {
            ASTNode result = JavaElementMapper.perform((IMember)this.getReceiverModelClass(), class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = InstanceMethodMover.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration);
            Assert.isTrue(result instanceof TypeDeclaration);
            return (TypeDeclaration)result;
        }

        private IType getReceiverModelClass() throws JavaModelException {
            if (this.fModelClass == null) {
                this.fModelClass = this.computeReceiverModelClass();
            }
            return this.fModelClass;
        }

        private boolean isReceiverModelClassAvailable() throws JavaModelException {
            if (this.fModelClass == null) {
                this.fModelClass = this.computeReceiverModelClass();
            }
            return this.fModelClass != null;
        }

        private IType computeReceiverModelClass() throws JavaModelException {
            return InstanceMethodMover.getModelClass(this.getReceiverClass(), this.fDependentProject);
        }

        private TextBufferPortion getNewMethodDeclarationText(Method method, String newMethodName, String originalReceiverParameterName, List allTypesUsed) throws CoreException {
            Method.MethodEditSession methodEditSession = method.createEditSession();
            methodEditSession.changeMethodName(newMethodName);
            methodEditSession.classQualifyNonInstanceMemberReferences();
            if (method.hasSelfReferences(this)) {
                methodEditSession.addNewFirstParameter(method.getDeclaringClass(), originalReceiverParameterName);
                methodEditSession.replaceSelfReferencesWithReferencesToName(originalReceiverParameterName);
            }
            methodEditSession.replaceNewReceiverReferencesWithSelfReferences(this);
            this.transformNonReferenceMentionsIn(methodEditSession);
            TextBufferPortion result = methodEditSession.getEdittedMethodText();
            allTypesUsed.addAll(methodEditSession.getAllTypesUsedWithoutQualificationInEdittedMethod());
            methodEditSession.clear();
            return result;
        }

        abstract void transformNonReferenceMentionsIn(Method.MethodEditSession var1);

        IParameter[] getMovedMethodParameterDescriptions(Method originalMethod, String originalReceiverParameterName) {
            Assert.isNotNull(originalMethod);
            Assert.isNotNull(originalReceiverParameterName);
            IParameter[] originalMethodParams = originalMethod.getParameters();
            if (!originalMethod.hasSelfReferences(this)) {
                return originalMethodParams;
            }
            IParameter[] result = new IParameter[1 + originalMethodParams.length];
            result[0] = new IParameter(this, originalMethod, originalReceiverParameterName){
                private final /* synthetic */ Method val$originalMethod;
                private final /* synthetic */ String val$originalReceiverParameterName;
                private final /* synthetic */ NewReceiver this$0;
                {
                    this.this$0 = this$0;
                    this.val$originalMethod = val$originalMethod;
                    this.val$originalReceiverParameterName = val$originalReceiverParameterName;
                }

                public ITypeBinding getType() {
                    return this.val$originalMethod.getDeclaringClass();
                }

                public String getName() {
                    return this.val$originalReceiverParameterName;
                }
            };
            for (int i = 0; i < originalMethodParams.length; ++i) {
                result[i + 1] = originalMethodParams[i];
            }
            return result;
        }

        public int hashCode() {
            Assert.isTrue(false, "hashing of NewReceiver unsupported");
            return 0;
        }

        final RefactoringStatus checkMoveOfMethodToMe(Method method, String newMethodName, String originalReceiverParameterName, boolean inlineDelegator, boolean removeDelegator, Object validationContext) throws JavaModelException {
            Assert.isNotNull(method);
            Assert.isNotNull(newMethodName);
            Assert.isNotNull(originalReceiverParameterName);
            Assert.isTrue(inlineDelegator || !removeDelegator);
            if (!this.isReceiverModelClassAvailable()) {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InstanceMethodMover.to_local_localunsupported"), null, (String)Corext.getPluginId(), (int)RefactoringStatusCodes.CANNOT_MOVE_TO_LOCAL, null);
            }
            RefactoringStatus result = new RefactoringStatus();
            this.checkParameterNames(result, method, originalReceiverParameterName);
            if (result.hasFatalError()) {
                return result;
            }
            result.merge(Checks.validateModifiesFiles(this.getFilesToBeModified(method), validationContext));
            return result;
        }

        private void checkParameterNames(RefactoringStatus result, Method method, String originalReceiverParameterName) {
            Iterator iter = method.getMethodDeclaration().parameters().iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)iter.next();
                if (!originalReceiverParameterName.equals(param.getName().getIdentifier())) continue;
                RefactoringStatusContext context = JavaStatusContext.create(method.getDeclaringCU(), (ASTNode)param);
                String msg = RefactoringCoreMessages.getFormattedString("InstanceMethodMover.parameter_name_used", new String[]{originalReceiverParameterName});
                int code = RefactoringStatusCodes.PARAM_NAME_ALREADY_USED;
                RefactoringStatusEntry entry = new RefactoringStatusEntry(3, msg, context, Corext.getPluginId(), code, null);
                result.addEntry(entry);
                return;
            }
        }

        private IFile[] getFilesToBeModified(Method method) throws JavaModelException {
            IFile file2;
            IFile file1 = NewReceiver.getFile(this.getReceiverClassCU());
            if (file1.equals(file2 = NewReceiver.getFile(method.getDeclaringCU()))) {
                return new IFile[]{file1};
            }
            return new IFile[]{file1, file2};
        }

        private static IFile getFile(ICompilationUnit cunit) throws JavaModelException {
            return ResourceUtil.getFile(cunit);
        }

        public abstract boolean hasFieldsAccessesOtherThanToMe(SimpleName[] var1);
    }

    private static interface IParameter {
        public ITypeBinding getType();

        public String getName();
    }
}

