/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ImportClassNotFoundException;
import org.eclipse.osgi.framework.adaptor.ImportResourceNotFoundException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleResourcePermission;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class BundleLoader
implements ClassLoaderDelegate {
    protected static String DEFAULT_PACKAGE = ".";
    protected BundleHost bundle;
    protected BundleClassLoader classloader;
    protected BundleResourcePermission resourcePermission;
    protected KeyedHashSet importedPackages;
    protected boolean hasDynamicImports = false;
    protected boolean dynamicImportPackageAll;
    protected String[] dynamicImportPackageStems;
    protected String[] dynamicImportPackages;
    protected KeyedHashSet providedPackages;
    protected KeyedHashSet requiredPackagesCache;
    protected BundleLoaderProxy[] requiredBundles;
    protected int[] reexportTable;

    protected static String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return null;
    }

    protected static String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return null;
    }

    protected BundleLoader(BundleHost bundle, BundleDescription description) throws BundleException {
        this.bundle = bundle;
        try {
            bundle.getBundleData().open();
        }
        catch (IOException e) {
            throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
        }
        this.initialize(description);
    }

    protected void initialize(BundleDescription description) {
        int i;
        int i2;
        this.hasDynamicImports = SystemBundleLoader.getSystemPackages() != null;
        Bundle[] fragmentObjects = this.bundle.getFragments();
        BundleDescription[] fragments = new BundleDescription[fragmentObjects == null ? 0 : fragmentObjects.length];
        for (i2 = 0; i2 < fragments.length; ++i2) {
            fragments[i2] = ((AbstractBundle)fragmentObjects[i2]).getBundleDescription();
        }
        this.addImportedPackages(description.getPackages());
        for (i2 = 0; i2 < fragments.length; ++i2) {
            if (!fragments[i2].isResolved()) continue;
            this.addImportedPackages(fragments[i2].getPackages());
        }
        BundleSpecification[] required = description.getRequiredBundles();
        ArrayList<BundleSpecification> bundles = new ArrayList<BundleSpecification>(Arrays.asList(required == null ? new BundleSpecification[]{} : required));
        for (int i3 = 0; i3 < fragments.length; ++i3) {
            BundleSpecification[] fragmentRequires;
            if (!fragments[i3].isResolved() || (fragmentRequires = fragments[i3].getRequiredBundles()) == null) continue;
            bundles.addAll(Arrays.asList(fragmentRequires));
        }
        if (bundles.size() > 0) {
            ArrayList<BundleLoaderProxy> bound = new ArrayList<BundleLoaderProxy>(bundles.size());
            int[] reexported = new int[bundles.size()];
            int reexportIndex = 0;
            for (int i4 = 0; i4 < bundles.size(); ++i4) {
                BundleSpecification spec = bundles.get(i4);
                if (!spec.isResolved()) continue;
                String bundleKey = spec.getName() + "_" + spec.getActualVersion().toString();
                BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.bundle.framework.packageAdmin.exportedBundles.getByKey(bundleKey);
                if (loaderProxy != null) {
                    bound.add(loaderProxy);
                    if (!spec.isExported()) continue;
                    reexported[reexportIndex++] = bound.size() - 1;
                    continue;
                }
                if (spec.isOptional()) continue;
                BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_MISSING_LOADER", bundleKey));
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
            }
            this.requiredBundles = bound.toArray(new BundleLoaderProxy[bound.size()]);
            if (reexportIndex > 0) {
                this.reexportTable = new int[reexportIndex];
                System.arraycopy(reexported, 0, this.reexportTable, 0, reexportIndex);
            }
        }
        String[] provides = description.getProvidedPackages();
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(required == null ? new String[]{} : provides));
        for (i = 0; i < fragments.length; ++i) {
            String[] fragmentProvides;
            if (!fragments[i].isResolved() || (fragmentProvides = fragments[i].getProvidedPackages()) == null) continue;
            packages.addAll(Arrays.asList(fragmentProvides));
        }
        if (packages.size() > 0) {
            this.providedPackages = new KeyedHashSet(packages.size());
            for (i = 0; i < packages.size(); ++i) {
                this.providedPackages.add(new SingleSourcePackage(packages.get(i), this.bundle.getLoaderProxy()));
            }
        }
        try {
            String spec = this.bundle.getBundleData().getDynamicImports();
            ManifestElement[] imports = ManifestElement.parseHeader("DynamicImport-Package", spec);
            this.addDynamicImportPackage(imports);
            for (int i5 = 0; i5 < fragments.length; ++i5) {
                if (!fragments[i5].isResolved()) continue;
                spec = ((AbstractBundle)fragmentObjects[i5]).getBundleData().getDynamicImports();
                imports = ManifestElement.parseHeader("DynamicImport-Package", spec);
                this.addDynamicImportPackage(imports);
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    protected void initializeFragment(AbstractBundle fragment) throws BundleException {
        BundleSpecification[] fragReqBundles;
        BundleDescription description = fragment.getBundleDescription();
        PackageSpecification[] packages = description.getPackages();
        if (packages != null && packages.length > 0) {
            for (int i = 0; i < packages.length; ++i) {
                if (this.importedPackages != null && this.importedPackages.getByKey(packages[i].getName()) != null) continue;
                throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_IMPORT_CONFLICT", new Object[]{fragment.getLocation(), packages[i].getName(), this.bundle.getLocation()}));
            }
        }
        if ((fragReqBundles = description.getRequiredBundles()) != null && fragReqBundles.length > 0) {
            if (this.requiredBundles == null) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_REQUIRE_CONFLICT", new Object[]{fragment.getLocation(), fragReqBundles[0].getName(), this.bundle.getLocation()}));
            }
            for (int i = 0; i < fragReqBundles.length; ++i) {
                boolean found = false;
                for (int j = 0; j < this.requiredBundles.length; ++j) {
                    String fragReqKey = fragReqBundles[i].getName() + "_" + fragReqBundles[i].getActualVersion().toString();
                    if (!fragReqKey.equals(this.requiredBundles[j].getKey())) continue;
                    found = true;
                }
                if (found) continue;
                throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_REQUIRE_CONFLICT", new Object[]{fragment.getLocation(), fragReqBundles[i].getName(), this.bundle.getLocation()}));
            }
        }
        try {
            String spec = fragment.getBundleData().getDynamicImports();
            ManifestElement[] imports = ManifestElement.parseHeader("DynamicImport-Package", spec);
            if (imports != null && imports.length > 0) {
                for (int i = 0; i < imports.length; ++i) {
                    String name = imports[i].getValue();
                    if (this.isDynamicallyImported(name)) continue;
                    throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_IMPORT_CONFLICT", new Object[]{fragment.getLocation(), imports[i], this.bundle.getLocation()}));
                }
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
        String[] provides = description.getProvidedPackages();
        if (provides != null) {
            if (this.providedPackages == null) {
                this.providedPackages = new KeyedHashSet(provides.length);
            }
            for (int i = 0; i < provides.length; ++i) {
                if (this.providedPackages.getByKey(provides[i]) != null) continue;
                this.providedPackages.add(new SingleSourcePackage(provides[i], this.bundle.getLoaderProxy()));
            }
        }
    }

    private void addImportedPackages(PackageSpecification[] packages) {
        if (packages != null && packages.length > 0) {
            if (this.importedPackages == null) {
                this.importedPackages = new KeyedHashSet();
            }
            for (int i = 0; i < packages.length; ++i) {
                SingleSourcePackage packagesource = (SingleSourcePackage)this.bundle.framework.packageAdmin.exportedPackages.getByKey(packages[i].getName());
                if (packagesource == null) continue;
                this.importedPackages.add(packagesource);
            }
        }
    }

    protected void close() {
        if (this.bundle == null) {
            return;
        }
        this.importedPackages = null;
        if (this.classloader != null) {
            this.classloader.close();
        }
        this.classloader = null;
        this.bundle = null;
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(name);
    }

    protected URL getResource(String name) {
        return this.createClassLoader().getResource(name);
    }

    protected Class requireClass(String name, String packageName) {
        Class result = null;
        try {
            result = this.findImportedClass(name, packageName);
        }
        catch (ImportClassNotFoundException e) {
            return null;
        }
        if (result == null) {
            result = this.findLocalClass(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleClassLoader createClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        BundleLoader bundleLoader = this;
        synchronized (bundleLoader) {
            if (this.classloader != null) {
                return this.classloader;
            }
            try {
                String[] classpath = this.getClassPath(this.bundle, SecureAction.getProperties());
                if (classpath != null) {
                    this.classloader = this.createBCLPrevileged(this.bundle.getProtectionDomain(), classpath);
                } else {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
                }
            }
            catch (BundleException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
        }
        return this.classloader;
    }

    protected Class findLocalClass(String name) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(name);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.isClosed()) {
            throw new ClassNotFoundException(name);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + name + ")");
        }
        String packageName = BundleLoader.getPackageName(name);
        Class result = null;
        if (packageName != null) {
            result = this.findImportedClass(name, packageName);
        }
        if (result == null) {
            result = this.findRequiredClass(name, packageName);
        }
        if (result == null && (result = this.findLocalClass(name)) == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    boolean isClosed() {
        return this.bundle == null;
    }

    public URL findResource(String name) {
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException e) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException ee) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(name);
        URL resource = null;
        if (packageName != null) {
            resource = this.findImportedResource(name, packageName);
        }
        if (resource == null) {
            resource = this.findRequiredResource(name, packageName);
        }
        if (resource == null) {
            resource = this.findLocalResource(name);
        }
        return resource;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException e) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException ee) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(name);
        Enumeration result = null;
        if (packageName != null) {
            result = this.findImportedResources(name, packageName);
        }
        if (result == null) {
            result = this.findRequiredResources(name, packageName);
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        return result;
    }

    protected URL requireResource(String name, String packageName) {
        URL result = null;
        try {
            result = this.findImportedResource(name, packageName);
        }
        catch (ImportResourceNotFoundException e) {
            return null;
        }
        if (result == null) {
            result = this.findLocalResource(name);
        }
        return result;
    }

    protected URL findLocalResource(final String name) {
        if (System.getSecurityManager() == null) {
            return this.createClassLoader().findLocalResource(name);
        }
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createClassLoader().findLocalResource(name);
            }
        });
    }

    protected Enumeration requireResources(String name, String packageName) {
        Enumeration result = null;
        try {
            result = this.findImportedResources(name, packageName);
        }
        catch (ImportResourceNotFoundException e) {
            return null;
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        return result;
    }

    protected Enumeration findLocalResources(String name) {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException e) {
            return null;
        }
        return this.createClassLoader().findLocalResources(name);
    }

    public Object findObject(String object) {
        if (this.isClosed()) {
            return null;
        }
        if (object.length() > 1 && object.charAt(0) == '/') {
            object = object.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException e) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException ee) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(object);
        Object result = null;
        if (packageName != null) {
            result = this.findImportedObject(object, packageName);
        }
        if (result == null) {
            result = this.findRequiredObject(object, packageName);
        }
        if (result == null) {
            result = this.findLocalObject(object);
        }
        return result;
    }

    protected Object requireObject(String object, String packageName) {
        Object result = null;
        try {
            result = this.findImportedObject(object, packageName);
        }
        catch (ImportResourceNotFoundException e) {
            return null;
        }
        if (result == null) {
            result = this.findLocalObject(object);
        }
        return result;
    }

    protected Object findLocalObject(String object) {
        return this.createClassLoader().findLocalObject(object);
    }

    public String findLibrary(final String name) {
        if (this.isClosed()) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(name);
            }
        });
    }

    protected String findLocalLibrary(String name) {
        String result = this.bundle.getBundleData().findLibrary(name);
        if (result != null) {
            return result;
        }
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        for (int i = 0; i < fragments.length; ++i) {
            result = ((AbstractBundle)fragments[i]).getBundleData().findLibrary(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    protected AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final ProtectionDomain pd, final String[] cp) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(pd, cp);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(pd, cp);
            }
        });
    }

    private BundleClassLoader createBCL(ProtectionDomain pd, String[] cp) {
        BundleClassLoader bcl = this.bundle.getBundleData().createClassLoader(this, pd, cp);
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments != null) {
            for (int i = 0; i < fragments.length; ++i) {
                AbstractBundle fragment = (AbstractBundle)fragments[i];
                try {
                    bcl.attachFragment(fragment.getBundleData(), fragment.domain, this.getClassPath(fragment, SecureAction.getProperties()));
                    continue;
                }
                catch (BundleException be) {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
                }
            }
        }
        bcl.initialize();
        return bcl;
    }

    public String toString() {
        BundleData result = this.bundle.getBundleData();
        return result == null ? "BundleLoader.bundledata == null!" : result.toString();
    }

    protected void checkResourcePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.resourcePermission == null) {
                this.resourcePermission = new BundleResourcePermission(this.bundle.getBundleId());
            }
            sm.checkPermission(this.resourcePermission);
        }
    }

    protected BundleLoader getPackageExporter(String pkgname) {
        PackageSource exporter;
        if (pkgname == null) {
            return null;
        }
        if (this.importedPackages != null && (exporter = (PackageSource)this.importedPackages.getByKey(pkgname)) != null) {
            return exporter.getSupplier().getBundleLoader();
        }
        if (this.isDynamicallyImported(pkgname) && (exporter = (PackageSource)this.bundle.framework.packageAdmin.exportedPackages.getByKey(pkgname)) != null) {
            exporter.getSupplier().markUsed(this.bundle.getLoaderProxy());
            this.importedPackages.add(exporter);
            return exporter.getSupplier().getBundleLoader();
        }
        return null;
    }

    protected boolean isDynamicallyImported(String pkgname) {
        int i;
        if (pkgname.startsWith("java.")) {
            return true;
        }
        if (!this.hasDynamicImports) {
            return false;
        }
        if (this.dynamicImportPackageAll) {
            return true;
        }
        String[] systemPackages = SystemBundleLoader.getSystemPackages();
        if (systemPackages != null) {
            for (i = 0; i < systemPackages.length; ++i) {
                if (!pkgname.equals(systemPackages[i])) continue;
                return true;
            }
        }
        if (this.dynamicImportPackages != null) {
            for (i = 0; i < this.dynamicImportPackages.length; ++i) {
                if (!pkgname.equals(this.dynamicImportPackages[i])) continue;
                return true;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            for (i = 0; i < this.dynamicImportPackageStems.length; ++i) {
                if (!pkgname.startsWith(this.dynamicImportPackageStems[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findImportedClass(String name, String packageName) throws ImportClassNotFoundException {
        Class result;
        block5: {
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "].findImportedClass(" + name + ")");
            }
            result = null;
            try {
                BundleLoader exporter = this.getPackageExporter(packageName);
                if (exporter != null && (result = exporter.findLocalClass(name)) == null) {
                    throw new ImportClassNotFoundException(name);
                }
                Object var6_5 = null;
                if (result != null) break block5;
                if (!Debug.DEBUG_LOADER) return result;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (result == null) {
                    if (!Debug.DEBUG_LOADER) throw throwable;
                    Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
                    throw throwable;
                }
                if (!Debug.DEBUG_LOADER) throw throwable;
                Debug.println("BundleLoader[" + this + "] found imported class " + name);
                throw throwable;
            }
            Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
            return result;
        }
        if (!Debug.DEBUG_LOADER) return result;
        Debug.println("BundleLoader[" + this + "] found imported class " + name);
        return result;
    }

    protected void addExportedProvidersFor(String packageName, ArrayList result, KeyedHashSet visited) {
        if (!visited.add(this.bundle)) {
            return;
        }
        PackageSource local = this.getProvidedPackage(packageName);
        if (this.requiredBundles != null) {
            int size = this.reexportTable == null ? 0 : this.reexportTable.length;
            int reexportIndex = 0;
            for (int i = 0; i < this.requiredBundles.length; ++i) {
                if (local != null) {
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
                    continue;
                }
                if (reexportIndex >= size || this.reexportTable[reexportIndex] != i) continue;
                ++reexportIndex;
                this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
            }
        }
        if (local != null) {
            result.add(local.getSupplier());
        }
    }

    protected PackageSource getProvidersFor(String packageName) {
        PackageSource source;
        PackageSource result;
        if (packageName == null) {
            packageName = DEFAULT_PACKAGE;
        }
        if (this.requiredPackagesCache != null && (result = (PackageSource)this.requiredPackagesCache.getByKey(packageName)) != null) {
            if (result.isNullSource()) {
                return null;
            }
            return result;
        }
        if (this.requiredBundles == null) {
            return null;
        }
        KeyedHashSet visited = new KeyedHashSet(false);
        ArrayList result2 = new ArrayList(3);
        for (int i = 0; i < this.requiredBundles.length; ++i) {
            BundleLoader requiredLoader = this.requiredBundles[i].getBundleLoader();
            requiredLoader.addExportedProvidersFor(packageName, result2, visited);
        }
        if (this.requiredPackagesCache == null) {
            this.requiredPackagesCache = new KeyedHashSet();
        }
        if (result2.size() == 0) {
            this.requiredPackagesCache.add(new NullPackageSource(packageName));
            return null;
        }
        if (result2.size() == 1) {
            BundleLoaderProxy proxy = (BundleLoaderProxy)result2.get(0);
            source = proxy.getPackageSource(packageName);
            this.requiredPackagesCache.add(source);
            return source;
        }
        BundleLoaderProxy[] bundles = result2.toArray(new BundleLoaderProxy[result2.size()]);
        source = new MultiSourcePackage(packageName, bundles);
        this.requiredPackagesCache.add(source);
        return source;
    }

    protected Class findRequiredClass(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredClass(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            for (int i = 0; i < bundles.length; ++i) {
                Class result = bundles[i].getBundleLoader().requireClass(name, packageName);
                if (result == null) continue;
                return result;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireClass(name, packageName);
        }
        return null;
    }

    protected PackageSource getProvidedPackage(String name) {
        return this.providedPackages == null ? null : (PackageSource)this.providedPackages.getByKey(name);
    }

    protected URL findImportedResource(String name, String packageName) {
        BundleLoader exporter;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResource(" + name + ")");
        }
        if ((exporter = this.getPackageExporter(packageName)) != null) {
            URL url = exporter.findLocalResource(name);
            if (url != null) {
                return url;
            }
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "] resource " + name + " not found in imported package " + packageName);
            }
            throw new ImportResourceNotFoundException(name);
        }
        return null;
    }

    protected URL findRequiredResource(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResource(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            for (int i = 0; i < bundles.length; ++i) {
                URL result = bundles[i].getBundleLoader().requireResource(name, packageName);
                if (result == null) continue;
                return result;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireResource(name, packageName);
        }
        return null;
    }

    protected Enumeration findImportedResources(String name, String packageName) {
        BundleLoader exporter;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResources(" + name + ")");
        }
        if ((exporter = this.getPackageExporter(packageName)) != null) {
            return exporter.findLocalResources(name);
        }
        return null;
    }

    protected Enumeration findRequiredResources(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResources(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            for (int i = 0; i < bundles.length; ++i) {
                Enumeration result = bundles[i].getBundleLoader().requireResources(name, packageName);
                if (result == null) continue;
                return result;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireResources(name, packageName);
        }
        return null;
    }

    protected Object findImportedObject(String object, String packageName) {
        BundleLoader exporter;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedObject(" + object + ")");
        }
        if ((exporter = this.getPackageExporter(packageName)) != null) {
            Object result = exporter.findLocalObject(object);
            if (result != null) {
                return result;
            }
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "] object " + object + " not found in imported package " + packageName);
            }
            throw new ImportResourceNotFoundException(object);
        }
        return null;
    }

    protected Object findRequiredObject(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResource(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            for (int i = 0; i < bundles.length; ++i) {
                Object result = bundles[i].getBundleLoader().requireObject(name, packageName);
                if (result == null) continue;
                return result;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireObject(name, packageName);
        }
        return null;
    }

    public void addDynamicImportPackage(ManifestElement[] packages) {
        int i;
        ArrayList<String> names;
        ArrayList<String> stems;
        if (packages == null && SystemBundleLoader.getSystemPackages() == null) {
            return;
        }
        this.hasDynamicImports = true;
        if (this.importedPackages == null) {
            this.importedPackages = new KeyedHashSet();
        }
        if (packages == null) {
            return;
        }
        int size = packages.length;
        if (this.dynamicImportPackageStems == null) {
            stems = new ArrayList<String>(size);
        } else {
            stems = new ArrayList(size + this.dynamicImportPackageStems.length);
            for (int i2 = 0; i2 < this.dynamicImportPackageStems.length; ++i2) {
                stems.add(this.dynamicImportPackageStems[i2]);
            }
        }
        if (this.dynamicImportPackages == null) {
            names = new ArrayList<String>(size);
        } else {
            names = new ArrayList(size + this.dynamicImportPackages.length);
            for (i = 0; i < this.dynamicImportPackages.length; ++i) {
                names.add(this.dynamicImportPackages[i]);
            }
        }
        for (i = 0; i < size; ++i) {
            String name = packages[i].getValue();
            if (this.isDynamicallyImported(name)) continue;
            if (name.equals("*")) {
                this.dynamicImportPackageAll = true;
                return;
            }
            if (name.endsWith(".*")) {
                stems.add(name.substring(0, name.length() - 1));
                continue;
            }
            names.add(name);
        }
        size = stems.size();
        if (size > 0) {
            this.dynamicImportPackageStems = stems.toArray(new String[size]);
        }
        if ((size = names.size()) > 0) {
            this.dynamicImportPackages = names.toArray(new String[size]);
        }
    }

    protected void clear() {
        this.providedPackages = null;
        this.requiredBundles = null;
        this.importedPackages = null;
        this.dynamicImportPackages = null;
        this.dynamicImportPackageStems = null;
    }

    protected void attachFragment(BundleFragment fragment, Properties props) throws BundleException {
        this.initializeFragment(fragment);
        if (this.classloader == null) {
            return;
        }
        try {
            String[] classpath = this.getClassPath(fragment, props);
            if (classpath != null) {
                this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, classpath);
            } else {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    protected String[] getClassPath(AbstractBundle bundle, Properties props) throws BundleException {
        String spec = bundle.getBundleData().getClassPath();
        ManifestElement[] classpathElements = ManifestElement.parseHeader("Bundle-ClassPath", spec);
        return this.matchClassPath(classpathElements, props);
    }

    protected String[] matchClassPath(ManifestElement[] classpath, Properties props) {
        if (classpath == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  no classpath");
            }
            return new String[]{"."};
        }
        ArrayList<String> result = new ArrayList<String>(classpath.length);
        for (int i = 0; i < classpath.length; ++i) {
            try {
                FilterImpl filter = this.createFilter(classpath[i].getAttribute("selection-filter"));
                if (filter != null && !filter.match(props)) continue;
                if (Debug.DEBUG_LOADER) {
                    Debug.println("  found match for classpath entry " + classpath[i].getValueComponents());
                }
                String[] matchPaths = classpath[i].getValueComponents();
                for (int j = 0; j < matchPaths.length; ++j) {
                    result.add(matchPaths[j]);
                }
                continue;
            }
            catch (InvalidSyntaxException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected FilterImpl createFilter(String filterString) throws InvalidSyntaxException {
        if (filterString == null) {
            return null;
        }
        int length = filterString.length();
        if (length <= 2) {
            throw new InvalidSyntaxException(Msg.formatter.getString("FILTER_INVALID"), filterString);
        }
        return new FilterImpl(filterString);
    }
}

