/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ISnippetStateChangedListener;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class EvaluateAction
implements IEvaluationListener,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IEditorActionDelegate,
IPartListener,
IViewActionDelegate,
ISnippetStateChangedListener {
    private IAction fAction;
    private IWorkbenchPart fTargetPart;
    private IWorkbenchWindow fWindow;
    private Object fSelection;
    private IRegion fRegion;
    private boolean fEvaluating;
    private IWorkbenchPart fNewTargetPart = null;
    private IDebugModelPresentation fPresentation;
    static /* synthetic */ Class class$org$eclipse$debug$ui$IDebugView;
    static /* synthetic */ Class class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay;

    protected IJavaObject getObjectContext() {
        IStructuredSelection structuredSelection;
        ISelection s;
        IDebugView a;
        IWorkbenchPart activePart;
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null && (a = (IDebugView)activePart.getAdapter(class$org$eclipse$debug$ui$IDebugView == null ? (class$org$eclipse$debug$ui$IDebugView = EvaluateAction.class$("org.eclipse.debug.ui.IDebugView")) : class$org$eclipse$debug$ui$IDebugView)) != null && a.getViewer() != null && (s = a.getViewer().getSelection()) instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)s).size() == 1) {
            IValue value;
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof IJavaVariable) {
                IJavaVariable var = (IJavaVariable)selection;
                try {
                    IValue value2;
                    if (!var.getName().equals("this") && (value2 = var.getValue()) instanceof IJavaObject && !(value2 instanceof IJavaArray)) {
                        return (IJavaObject)value2;
                    }
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                }
            } else if (selection instanceof JavaInspectExpression && (value = ((JavaInspectExpression)((Object)selection)).getValue()) instanceof IJavaObject && !(value instanceof IJavaArray)) {
                return (IJavaObject)value;
            }
        }
        return null;
    }

    protected IJavaStackFrame getStackFrameContext() {
        IWorkbenchPart part = this.getTargetPart();
        IJavaStackFrame frame = null;
        frame = part == null ? EvaluationContextManager.getEvaluationContext(this.getWindow()) : EvaluationContextManager.getEvaluationContext(part);
        return frame;
    }

    public void evaluationComplete(IEvaluationResult result) {
        if (JDIDebugUIPlugin.getDefault() == null) {
            return;
        }
        IJavaValue value = result.getValue();
        if (result.hasErrors() || value != null) {
            Display display = JDIDebugUIPlugin.getStandardDisplay();
            if (display.isDisposed()) {
                return;
            }
            this.displayResult(result);
        }
    }

    protected void evaluationCleanup() {
        this.setEvaluating(false);
        this.setTargetPart(this.fNewTargetPart);
    }

    protected abstract void displayResult(IEvaluationResult var1);

    protected void run() {
        IJavaObject object = this.getObjectContext();
        IJavaStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame == null) {
            this.reportError(ActionMessages.getString("Evaluate.error.message.stack_frame_context"));
            return;
        }
        IJavaThread thread = (IJavaThread)stackFrame.getThread();
        if (thread.isPerformingEvaluation()) {
            this.reportError(ActionMessages.getString("EvaluateAction.Cannot_perform_nested_evaluations._1"));
            return;
        }
        this.setNewTargetPart(this.getTargetPart());
        if (stackFrame.isSuspended()) {
            IJavaElement javaElement = this.getJavaElement((IStackFrame)stackFrame);
            if (javaElement != null) {
                IJavaProject project = javaElement.getJavaProject();
                IAstEvaluationEngine engine = null;
                try {
                    Object selection = this.getSelectedObject();
                    if (!(selection instanceof String)) {
                        return;
                    }
                    String expression = (String)selection;
                    engine = JDIDebugUIPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)stackFrame.getDebugTarget());
                    this.setEvaluating(true);
                    boolean hitBreakpoints = JDIDebugModel.getPreferences().getBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION);
                    if (object == null) {
                        engine.evaluate(expression, stackFrame, (IEvaluationListener)this, 64, hitBreakpoints);
                    } else {
                        engine.evaluate(expression, object, (IJavaThread)stackFrame.getThread(), (IEvaluationListener)this, 64, hitBreakpoints);
                    }
                    return;
                }
                catch (CoreException e) {
                    this.reportError(this.getExceptionMessage(e));
                }
            } else {
                this.reportError(ActionMessages.getString("Evaluate.error.message.src_context"));
            }
        } else {
            this.reportError(ActionMessages.getString("EvaluateAction.Thread_not_suspended_-_unable_to_perform_evaluation._1"));
        }
        this.evaluationCleanup();
    }

    protected IJavaElement getJavaElement(IStackFrame stackFrame) {
        IJavaProject project;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement instanceof IJavaElement) {
            return (IJavaElement)sourceElement;
        }
        if (sourceElement instanceof IResource && (project = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            return project;
        }
        return null;
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            this.resolveSelectedObject();
        }
    }

    protected void resolveSelectedObject() {
        Object selectedObject = null;
        this.fRegion = null;
        ISelection selection = this.getTargetSelection();
        if (selection instanceof ITextSelection) {
            IEditorPart editor;
            ITextSelection ts = (ITextSelection)selection;
            String text = ts.getText();
            if (this.textHasContent(text)) {
                selectedObject = text;
                this.fRegion = new Region(ts.getOffset(), ts.getLength());
            } else if (this.getTargetPart() instanceof IEditorPart && (editor = (IEditorPart)this.getTargetPart()) instanceof ITextEditor) {
                selectedObject = this.resolveSelectedObjectUsingToken(selectedObject, ts, editor);
            }
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (this.getTargetPart().getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                IEditorPart editor = this.getTargetPart().getSite().getPage().getActiveEditor();
                this.setTargetPart((IWorkbenchPart)editor);
                selection = this.getTargetSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection ts = (ITextSelection)selection;
                    String text = ts.getText();
                    if (this.textHasContent(text)) {
                        selectedObject = text;
                    } else if (editor instanceof ITextEditor) {
                        selectedObject = this.resolveSelectedObjectUsingToken(selectedObject, ts, editor);
                    }
                }
            } else {
                IStructuredSelection ss = (IStructuredSelection)selection;
                Iterator elements = ss.iterator();
                while (elements.hasNext()) {
                    if (elements.next() instanceof IJavaVariable) continue;
                    this.setSelectedObject(null);
                    return;
                }
                selectedObject = ss;
            }
        }
        this.setSelectedObject(selectedObject);
    }

    private Object resolveSelectedObjectUsingToken(Object selectedObject, ITextSelection ts, IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fRegion = JavaWordFinder.findWord(doc, ts.getOffset());
        if (this.fRegion != null) {
            try {
                selectedObject = doc.get(this.fRegion.getOffset(), this.fRegion.getLength());
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return selectedObject;
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    protected boolean compareToEditorInput(IStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return false;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return false;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement == null) {
            return false;
        }
        IEditorInput sfEditorInput = this.getDebugModelPresentation().getEditorInput(sourceElement);
        if (this.getTargetPart() instanceof IEditorPart) {
            return ((IEditorPart)this.getTargetPart()).getEditorInput().equals(sfEditorInput);
        }
        return false;
    }

    protected Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDataDisplay getDataDisplay() {
        IWorkbenchPart activePart;
        IDataDisplay display = this.getDirectDataDisplay();
        if (display != null) {
            return display;
        }
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null) {
            IViewPart view = page.findView(IJavaDebugUIConstants.ID_DISPLAY_VIEW);
            if (view == null) {
                try {
                    view = page.showView(IJavaDebugUIConstants.ID_DISPLAY_VIEW);
                }
                catch (PartInitException e) {
                    JDIDebugUIPlugin.errorDialog(ActionMessages.getString("EvaluateAction.Cannot_open_Display_view"), e);
                }
                finally {
                    page.activate(activePart);
                }
            }
            if (view != null) {
                page.bringToTop((IWorkbenchPart)view);
                return (IDataDisplay)view.getAdapter(class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay == null ? (class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay = EvaluateAction.class$("org.eclipse.jdt.internal.debug.ui.display.IDataDisplay")) : class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay);
            }
        }
        return null;
    }

    protected IDataDisplay getDirectDataDisplay() {
        IDataDisplay display;
        IWorkbenchPart activePart;
        IDataDisplay display2;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (display2 = (IDataDisplay)part.getAdapter(class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay == null ? (class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay = EvaluateAction.class$("org.eclipse.jdt.internal.debug.ui.display.IDataDisplay")) : class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay)) != null) {
            IWorkbenchPart activePart2;
            IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
            if (page != null && (activePart2 = page.getActivePart()) != null && activePart2 != part) {
                page.activate(part);
            }
            return display2;
        }
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null && (display = (IDataDisplay)activePart.getAdapter(class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay == null ? (class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay = EvaluateAction.class$("org.eclipse.jdt.internal.debug.ui.display.IDataDisplay")) : class$org$eclipse$jdt$internal$debug$ui$display$IDataDisplay)) != null) {
            return display;
        }
        return null;
    }

    protected boolean textHasContent(String text) {
        int length;
        if (text != null && (length = text.length()) > 0) {
            for (int i = 0; i < length; ++i) {
                if (!Character.isLetterOrDigit(text.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected void reportErrors(IEvaluationResult result) {
        String message = this.getErrorMessage(result);
        this.reportError(message);
    }

    protected void reportError(String message) {
        IDataDisplay dataDisplay = this.getDirectDataDisplay();
        if (dataDisplay != null) {
            if (message.length() != 0) {
                dataDisplay.displayExpressionValue(MessageFormat.format(ActionMessages.getString("EvaluateAction.(evaluation_failed)_Reason"), this.format(message)));
            } else {
                dataDisplay.displayExpressionValue(ActionMessages.getString("EvaluateAction.(evaluation_failed)_1"));
            }
        } else {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, message, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)ActionMessages.getString("Evaluate.error.title.eval_problems"), null, (IStatus)status);
        }
    }

    private String format(String message) {
        int pos;
        StringBuffer result = new StringBuffer();
        int index = 0;
        while ((pos = message.indexOf(10, index)) != -1) {
            int n = index;
            index = pos + 1;
            result.append("\t\t").append(message.substring(n, index));
        }
        if (index < message.length()) {
            result.append("\t\t").append(message.substring(index));
        }
        return result.toString();
    }

    protected String getExceptionMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            Throwable throwable = ce.getStatus().getException();
            if (throwable instanceof InvocationException) {
                return this.getInvocationExceptionMessage((InvocationException)throwable);
            }
            if (throwable instanceof CoreException) {
                return this.getExceptionMessage(throwable);
            }
            return ce.getStatus().getMessage();
        }
        String message = MessageFormat.format(ActionMessages.getString("Evaluate.error.message.direct_exception"), exception.getClass());
        if (exception.getMessage() != null) {
            message = MessageFormat.format(ActionMessages.getString("Evaluate.error.message.exception.pattern"), message, exception.getMessage());
        }
        return message;
    }

    protected String getInvocationExceptionMessage(InvocationException exception) {
        InvocationException ie = exception;
        ObjectReference ref = ie.exception();
        return MessageFormat.format(ActionMessages.getString("Evaluate.error.message.wrapped_exception"), ref.referenceType().name());
    }

    protected String getErrorMessage(IEvaluationResult result) {
        String[] errors = result.getErrorMessages();
        if (errors.length == 0) {
            return this.getExceptionMessage(result.getException());
        }
        return this.getErrorMessage(errors);
    }

    protected String getErrorMessage(String[] errors) {
        String message = "";
        for (int i = 0; i < errors.length; ++i) {
            String msg = errors[i];
            message = i == 0 ? msg : MessageFormat.format(ActionMessages.getString("Evaluate.error.problem_append_pattern"), message, msg);
        }
        return message;
    }

    public void run(IAction action) {
        this.update();
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void dispose() {
        this.disposeDebugModelPresentation();
        IWorkbenchWindow win = this.getWindow();
        if (win != null) {
            win.getPartService().removePartListener((IPartListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
        this.update();
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IDebugModelPresentation getDebugModelPresentation() {
        if (this.fPresentation == null) {
            this.fPresentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
        }
        return this.fPresentation;
    }

    protected void disposeDebugModelPresentation() {
        if (this.fPresentation != null) {
            this.fPresentation.dispose();
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        this.setTargetPart((IWorkbenchPart)targetEditor);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setTargetPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTargetPart()) {
            this.setTargetPart(null);
        }
        if (part == this.getNewTargetPart()) {
            this.setNewTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void init(IViewPart view) {
        this.setTargetPart((IWorkbenchPart)view);
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart part) {
        if (this.isEvaluating()) {
            this.setNewTargetPart(part);
        } else {
            if (this.getTargetPart() instanceof JavaSnippetEditor) {
                ((JavaSnippetEditor)this.getTargetPart()).removeSnippetStateChangedListener(this);
            }
            this.fTargetPart = part;
            if (part instanceof JavaSnippetEditor) {
                ((JavaSnippetEditor)part).addSnippetStateChangedListener(this);
            }
        }
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setAction(action);
        this.setTargetPart(targetPart);
        this.update();
    }

    protected Object getSelectedObject() {
        return this.fSelection;
    }

    protected void setSelectedObject(Object selection) {
        this.fSelection = selection;
    }

    public void snippetStateChanged(JavaSnippetEditor editor) {
        if (editor != null && !editor.isEvaluating() && editor.getFile() != null) {
            this.update();
        } else {
            this.getAction().setEnabled(false);
        }
    }

    protected IWorkbenchPart getNewTargetPart() {
        return this.fNewTargetPart;
    }

    protected void setNewTargetPart(IWorkbenchPart newTargetPart) {
        this.fNewTargetPart = newTargetPart;
    }

    protected boolean isEvaluating() {
        return this.fEvaluating;
    }

    protected void setEvaluating(boolean evaluating) {
        this.fEvaluating = evaluating;
    }

    protected IRegion getRegion() {
        return this.fRegion;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

