/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class ShowInAction
extends Action {
    private IWorkbenchWindow window;
    private IViewDescriptor desc;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInSource;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInTarget;

    protected ShowInAction(IWorkbenchWindow window, IViewDescriptor desc) {
        super(desc.getLabel());
        this.setImageDescriptor(desc.getImageDescriptor());
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.show_in_action_context");
        this.window = window;
        this.desc = desc;
    }

    public void run() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            this.beep();
            return;
        }
        IWorkbenchPart sourcePart = page.getActivePart();
        if (sourcePart == null) {
            this.beep();
            return;
        }
        ShowInContext context = this.getContext(sourcePart);
        if (context == null) {
            this.beep();
            return;
        }
        try {
            IViewPart view = page.showView(this.desc.getId());
            IShowInTarget target = this.getShowInTarget(view);
            if (target == null || !target.show(context)) {
                this.beep();
            }
            ((WorkbenchPage)page).performedShowIn(this.desc.getId());
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log("Error showing view in ShowInAction.run", e.getStatus());
        }
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        if (sourcePart instanceof IShowInSource) {
            return (IShowInSource)((Object)sourcePart);
        }
        Object o = sourcePart.getAdapter(class$org$eclipse$ui$part$IShowInSource == null ? (class$org$eclipse$ui$part$IShowInSource = ShowInAction.class$("org.eclipse.ui.part.IShowInSource")) : class$org$eclipse$ui$part$IShowInSource);
        if (o instanceof IShowInSource) {
            return (IShowInSource)o;
        }
        return null;
    }

    private IShowInTarget getShowInTarget(IWorkbenchPart targetPart) {
        if (targetPart instanceof IShowInTarget) {
            return (IShowInTarget)((Object)targetPart);
        }
        Object o = targetPart.getAdapter(class$org$eclipse$ui$part$IShowInTarget == null ? (class$org$eclipse$ui$part$IShowInTarget = ShowInAction.class$("org.eclipse.ui.part.IShowInTarget")) : class$org$eclipse$ui$part$IShowInTarget);
        if (o instanceof IShowInTarget) {
            return (IShowInTarget)o;
        }
        return null;
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext(input, sel);
        }
        return null;
    }

    private void beep() {
        this.window.getShell().getDisplay().beep();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

