/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFontStruct;

public final class TextLayout {
    Device device;
    Font font;
    String text;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int defaultAscent;
    int defaultDescent;

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        XFontStruct fontStruct = this.getFontHeigth(device.getSystemFont());
        this.defaultAscent = fontStruct.ascent;
        this.defaultDescent = fontStruct.descent;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    int stringWidth(StyleItem run, char[] ch) {
        if (ch.length == 0) {
            return 0;
        }
        int fontList = this.getItemFont((StyleItem)run).handle;
        byte[] buffer = Converter.wcsToMbcs(null, ch, true);
        int xmString = OS.XmStringCreateLocalized(buffer);
        int width = OS.XmStringWidth(fontList, xmString);
        OS.XmStringFree(xmString);
        return width;
    }

    void computeRuns() {
        if (this.runs != null) {
            return;
        }
        StyleItem[] allRuns = this.itemize();
        for (int i = 0; i < allRuns.length - 1; ++i) {
            StyleItem run = allRuns[i];
            this.place(run);
        }
        int lineWidth = 0;
        int lineStart = 0;
        int lineCount = 1;
        for (int i = 0; i < allRuns.length - 1; ++i) {
            StyleItem run = allRuns[i];
            if (run.length == 1) {
                char ch = this.text.charAt(run.start);
                switch (ch) {
                    case '\t': {
                        int tabX;
                        int lastTabWidth;
                        int j;
                        run.tab = true;
                        run.baseline = 0;
                        if (this.tabs == null) break;
                        int tabsLength = this.tabs.length;
                        for (j = 0; j < tabsLength; ++j) {
                            if (this.tabs[j] <= lineWidth) continue;
                            run.width = this.tabs[j] - lineWidth;
                            break;
                        }
                        if (j != tabsLength) break;
                        int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        if (lastTabWidth <= 0) break;
                        for (tabX = this.tabs[tabsLength - 1]; tabX <= lineWidth; tabX += lastTabWidth) {
                        }
                        run.width = tabX - lineWidth;
                        break;
                    }
                    case '\n': {
                        run.lineBreak = true;
                        run.width = 0;
                        run.baseline = 0;
                        break;
                    }
                    case '\r': {
                        run.lineBreak = true;
                        run.width = 0;
                        run.baseline = 0;
                        StyleItem next = allRuns[i + 1];
                        if (next.length == 0 || this.text.charAt(next.start) != '\n') break;
                        ++run.length;
                        ++i;
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab) {
                int start = 0;
                char[] chars = new char[run.length];
                this.text.getChars(run.start, run.start + run.length, chars, 0);
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                char[] buffer = new char[]{chars[start]};
                int charWidth = this.stringWidth(run, buffer);
                while (width + charWidth < maxWidth) {
                    width += charWidth;
                    buffer[0] = chars[++start];
                    charWidth = this.stringWidth(run, buffer);
                }
                int firstStart = start;
                int firstIndice = i;
                while (i >= lineStart) {
                    chars = new char[run.length];
                    this.text.getChars(run.start, run.start + run.length, chars, 0);
                    while (start >= 0 && !Compatibility.isSpaceChar(chars[start]) && !Compatibility.isWhitespace(chars[start])) {
                        --start;
                    }
                    if (start >= 0 || i == lineStart) break;
                    run = allRuns[--i];
                    start = run.length - 1;
                }
                if (start == 0 && i != lineStart) {
                    run = allRuns[--i];
                } else if (start <= 0 && i == lineStart) {
                    i = firstIndice;
                    run = allRuns[i];
                    start = Math.max(1, firstStart);
                }
                chars = new char[run.length];
                this.text.getChars(run.start, run.start + run.length, chars, 0);
                while (start < run.length && Compatibility.isWhitespace(chars[start])) {
                    ++start;
                }
                if (0 < start && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    run.length = start;
                    this.place(run);
                    this.place(newRun);
                    StyleItem[] newAllRuns = new StyleItem[allRuns.length + 1];
                    System.arraycopy(allRuns, 0, newAllRuns, 0, i + 1);
                    System.arraycopy(allRuns, i + 1, newAllRuns, i + 2, allRuns.length - i - 1);
                    allRuns = newAllRuns;
                    allRuns[i + 1] = newRun;
                }
                if (i != allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (!run.lineBreak) continue;
            lineStart = i + 1;
            lineWidth = 0;
            ++lineCount;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascent = Math.max(this.defaultAscent, this.ascent);
        int descent = Math.max(this.defaultDescent, this.descent);
        StyleItem[] lineRuns = new StyleItem[allRuns.length];
        for (int i = 0; i < allRuns.length; ++i) {
            StyleItem run = allRuns[i];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            if (run.style != null && run.style.font != null) {
                XFontStruct fontStruct = this.getFontHeigth(run.style.font);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
            }
            if (!run.lineBreak && i != allRuns.length - 1) continue;
            this.runs[line] = new StyleItem[lineRunCount];
            System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
            StyleItem lastRun = this.runs[line][lineRunCount - 1];
            this.lineWidth[line] = lineWidth;
            this.lineY[++line] = this.lineY[line - 1] + ascent + descent + this.lineSpacing;
            this.lineOffset[line] = lastRun.start + lastRun.length;
            lineWidth = 0;
            lineRunCount = 0;
            ascent = Math.max(this.defaultAscent, this.ascent);
            descent = Math.max(this.defaultDescent, this.descent);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.tabs = null;
        this.styles = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean hasSelection;
        int length;
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0) {
            return;
        }
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (hasSelection) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
        }
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        Font gcFont = gc.getFont();
        Rectangle clip = gc.getClipping();
        block4: for (int line = 0; line < this.runs.length; ++line) {
            int drawX = x;
            int drawY = y + this.lineY[line];
            StyleItem[] lineRuns = this.runs[line];
            if (this.wrapWidth != -1) {
                switch (this.alignment) {
                    case 0x1000000: {
                        drawX += (this.wrapWidth - this.lineWidth[line]) / 2;
                        break;
                    }
                    case 131072: {
                        drawX += this.wrapWidth - this.lineWidth[line];
                    }
                }
            }
            if (drawX > clip.x + clip.width || drawX + this.lineWidth[line] < clip.x) continue;
            int baseline = Math.max(0, this.ascent);
            for (int i = 0; i < lineRuns.length; ++i) {
                baseline = Math.max(baseline, lineRuns[i].baseline);
            }
            int lineHeight = this.lineY[line + 1] - this.lineY[line];
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) continue block4;
                if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                    boolean fullSelection;
                    String string = this.text.substring(run.start, run.start + run.length);
                    int drawRunY = drawY + (baseline - run.baseline);
                    int end = run.start + run.length - 1;
                    gc.setFont(this.getItemFont(run));
                    boolean bl2 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                    if (fullSelection) {
                        gc.setBackground(selectionBackground);
                        gc.fillRectangle(drawX, drawY, run.width, lineHeight);
                        if (!run.tab) {
                            gc.setForeground(selectionForeground);
                            gc.drawString(string, drawX, drawRunY, true);
                        }
                    } else {
                        if (run.style != null && run.style.background != null) {
                            Color bg = run.style.background;
                            gc.setBackground(bg);
                            gc.fillRectangle(drawX, drawRunY, run.width, run.height);
                        }
                        if (!run.tab) {
                            boolean partialSelection;
                            Color fg = foreground;
                            if (run.style != null && run.style.foreground != null) {
                                fg = run.style.foreground;
                            }
                            gc.setForeground(fg);
                            gc.drawString(string, drawX, drawRunY, true);
                            boolean bl3 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                            if (partialSelection) {
                                int selStart = Math.max(selectionStart, run.start);
                                int selEnd = Math.min(selectionEnd, end);
                                string = this.text.substring(run.start, selStart);
                                int selX = drawX + gc.stringExtent((String)string).x;
                                string = this.text.substring(selStart, selEnd + 1);
                                int selWidth = gc.stringExtent((String)string).x;
                                gc.setBackground(selectionBackground);
                                gc.fillRectangle(selX, drawY, selWidth, lineHeight);
                                if (fg != selectionForeground) {
                                    gc.setForeground(selectionForeground);
                                    gc.drawString(string, selX, drawRunY, true);
                                }
                            }
                        }
                    }
                }
                drawX += run.width;
            }
        }
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.setFont(gcFont);
    }

    void freeRuns() {
        this.runs = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            for (int line = 0; line < this.runs.length; ++line) {
                width = Math.max(width, this.lineWidth[line]);
            }
        }
        return new Rectangle(0, 0, width, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int startLine = this.getLineIndex(start);
        int endLine = this.getLineIndex(end);
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        rect.y = this.lineY[startLine];
        rect.height = this.lineY[endLine + 1] - rect.y;
        if (startLine == endLine) {
            rect.x = this.getLocation((int)start, (boolean)false).x;
            rect.width = this.getLocation((int)end, (boolean)true).x - rect.x;
        } else {
            while (startLine <= endLine) {
                rect.width = Math.max(rect.width, this.lineWidth[startLine++]);
            }
        }
        return rect;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    XFontStruct getFontHeigth(Font font) {
        int fontListEntry;
        int[] buffer = new int[1];
        int fontList = font.handle;
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        int ascent = 0;
        int descent = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            for (int i = 0; i < nFonts; ++i) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
            }
        }
        OS.XmFontListFreeFontContext(context);
        fontStruct.ascent = ascent;
        fontStruct.descent = descent;
        return fontStruct;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        return 0;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] offsets = new int[this.lineOffset.length];
        System.arraycopy(this.lineOffset, 0, offsets, 0, offsets.length);
        return offsets;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x = 0;
        int y = this.lineY[lineIndex];
        int width = this.lineWidth[lineIndex];
        int height = this.lineY[lineIndex + 1] - y;
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    x = (this.wrapWidth - width) / 2;
                    break;
                }
                case 131072: {
                    x = this.wrapWidth - width;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.runs.length;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        for (int line = 0; line < this.runs.length; ++line) {
            if (this.lineOffset[line + 1] <= offset) continue;
            return line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        GC gc = new GC(this.device);
        Font font = this.font != null ? this.font : this.device.getSystemFont();
        FontMetrics metrics = null;
        if (this.text.length() == 0) {
            gc.setFont(font);
            metrics = gc.getFontMetrics();
            metrics.ascent = Math.max(metrics.ascent, this.ascent);
            metrics.descent = Math.max(metrics.descent, this.descent);
        } else {
            int ascent = this.ascent;
            int descent = this.descent;
            int leading = 0;
            int aveCharWidth = 0;
            int height = 0;
            StyleItem[] lineRuns = this.runs[lineIndex];
            for (int i = 0; i < lineRuns.length; ++i) {
                Font runFont;
                StyleItem run = lineRuns[i];
                Font font2 = runFont = run.style != null ? run.style.font : null;
                if (runFont == null) {
                    runFont = font;
                }
                gc.setFont(font);
                metrics = gc.getFontMetrics();
                ascent = Math.max(ascent, metrics.getAscent());
                descent = Math.max(descent, metrics.getDescent());
                height = Math.max(height, metrics.getHeight());
                leading = Math.max(leading, metrics.getLeading());
                aveCharWidth += metrics.getAverageCharWidth();
            }
            metrics = FontMetrics.motif_new(ascent, descent, aveCharWidth / lineRuns.length, leading, height);
        }
        gc.dispose();
        return metrics;
    }

    public Point getLocation(int offset, boolean trailing) {
        int line;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        for (line = 0; line < this.runs.length && this.lineOffset[line + 1] <= offset; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        Point result = null;
        if (offset == length) {
            result = new Point(this.lineWidth[line], this.lineY[line]);
        } else {
            int width = 0;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                int end = run.start + run.length;
                if (run.start <= offset && offset < end) {
                    if (run.tab) {
                        if (trailing || offset == length) {
                            width += run.width;
                        }
                    } else {
                        if (trailing) {
                            ++offset;
                        }
                        char[] chars = new char[offset - run.start];
                        this.text.getChars(run.start, offset, chars, 0);
                        width += this.stringWidth(run, chars);
                    }
                    result = new Point(width, this.lineY[line]);
                    break;
                }
                width += run.width;
            }
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    result.x += (this.wrapWidth - this.lineWidth[line]) / 2;
                    break;
                }
                case 131072: {
                    result.x += this.wrapWidth - this.lineWidth[line];
                }
            }
        }
        return result;
    }

    Font getItemFont(StyleItem item) {
        if (item.style != null && item.style.font != null) {
            return item.style.font;
        }
        if (this.font != null) {
            return this.font;
        }
        return this.device.getSystemFont();
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        if (offset == length) {
            return length;
        }
        if ((movement & 3) != 0) {
            return offset + 1;
        }
        int lineEnd = 0;
        for (int i = 1; i < this.lineOffset.length; ++i) {
            if (this.lineOffset[i] <= offset) continue;
            lineEnd = Math.max(this.lineOffset[i - 1], this.lineOffset[i] - 1);
            if (i != this.runs.length) break;
            ++lineEnd;
            break;
        }
        boolean previousSpaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(offset));
        ++offset;
        while (offset < lineEnd) {
            boolean spaceChar;
            boolean bl = spaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(offset));
            if (!spaceChar && previousSpaceChar) break;
            previousSpaceChar = spaceChar;
            ++offset;
        }
        return offset;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int line;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        for (line = 0; line < lineCount && this.lineY[line + 1] <= y; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    x -= (this.wrapWidth - this.lineWidth[line]) / 2;
                    break;
                }
                case 131072: {
                    x -= this.wrapWidth - this.lineWidth[line];
                }
            }
        }
        if (x < 0) {
            return this.lineOffset[line];
        }
        if (x > this.lineWidth[line]) {
            if (this.lineOffset[line + 1] > this.lineOffset[line]) {
                if (trailing != null) {
                    trailing[0] = 1;
                }
                return this.lineOffset[line + 1] - 1;
            }
            if (trailing != null) {
                trailing[0] = 0;
            }
            return this.lineOffset[line + 1];
        }
        StyleItem[] lineRuns = this.runs[line];
        int width = 0;
        for (int i = 0; i < lineRuns.length; ++i) {
            StyleItem run = lineRuns[i];
            if (run.lineBreak && !run.softBreak) {
                return run.start;
            }
            if (width + run.width > x) {
                if (run.tab) {
                    if (trailing != null) {
                        trailing[0] = x < width + run.width / 2 ? 0 : 1;
                    }
                    return run.start;
                }
                int offset = 0;
                char[] buffer = new char[1];
                char[] chars = new char[run.length];
                this.text.getChars(run.start, run.start + run.length, chars, 0);
                for (offset = 0; offset < chars.length; ++offset) {
                    buffer[0] = chars[offset];
                    int charWidth = this.stringWidth(run, buffer);
                    if (width + charWidth > x) {
                        if (trailing == null) break;
                        trailing[0] = x < width + charWidth / 2 ? 0 : 1;
                        break;
                    }
                    width += charWidth;
                }
                return run.start + offset;
            }
            width += run.width;
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        return this.lineOffset[line + 1];
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        boolean previousSpaceChar;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        if (offset == 0) {
            return 0;
        }
        if ((movement & 3) != 0) {
            return offset - 1;
        }
        int lineStart = 0;
        for (int i = 0; i < this.lineOffset.length - 1; ++i) {
            int lineEnd = this.lineOffset[i + 1];
            if (i == this.runs.length - 1) {
                ++lineEnd;
            }
            if (lineEnd <= offset) continue;
            lineStart = this.lineOffset[i];
            break;
        }
        boolean bl = previousSpaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(--offset));
        while (lineStart < offset) {
            boolean spaceChar;
            boolean bl2 = spaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(offset - 1));
            if (spaceChar && !previousSpaceChar) break;
            --offset;
            previousSpaceChar = spaceChar;
        }
        return offset;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset >= length) {
            SWT.error(6);
        }
        for (int i = 1; i < this.styles.length; ++i) {
            StyleItem item = this.styles[i];
            if (item.start <= offset) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int length = this.text.length();
        if (length == 0) {
            return new StyleItem[]{new StyleItem(), new StyleItem()};
        }
        int runCount = 0;
        int start = 0;
        StyleItem[] runs = new StyleItem[length];
        char[] chars = this.text.toCharArray();
        for (int i = 0; i < length; ++i) {
            StyleItem item;
            char ch = chars[i];
            if (ch != '\t' && ch != '\r' && ch != '\n') continue;
            if (i != start) {
                item = new StyleItem();
                item.start = start;
                runs[runCount++] = item;
            }
            item = new StyleItem();
            item.start = i;
            runs[runCount++] = item;
            start = i + 1;
        }
        char lastChar = chars[length - 1];
        if (lastChar != '\t' && lastChar != '\r' && lastChar != '\n') {
            StyleItem item = new StyleItem();
            item.start = start;
            runs[runCount++] = item;
        }
        if (runCount != length) {
            StyleItem[] newRuns = new StyleItem[runCount];
            System.arraycopy(runs, 0, newRuns, 0, runCount);
            runs = newRuns;
        }
        runs = this.merge(runs, runCount);
        return runs;
    }

    StyleItem[] merge(StyleItem[] items, int itemCount) {
        StyleItem item;
        int length = this.text.length();
        int count = 0;
        int start = 0;
        int end = length;
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.styles.length];
        while (start < end) {
            int styleLimit;
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            int itemLimit = itemIndex + 1 < items.length ? items[itemIndex + 1].start : length;
            int n = styleLimit = styleIndex + 1 < this.styles.length ? this.styles[styleIndex + 1].start : length;
            if (styleLimit <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
            }
            if (itemLimit <= styleLimit) {
                ++itemIndex;
                start = itemLimit;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    void place(StyleItem run) {
        if (run.length == 0) {
            return;
        }
        char[] chars = new char[run.length];
        this.text.getChars(run.start, run.start + run.length, chars, 0);
        int fontList = this.getItemFont((StyleItem)run).handle;
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        short[] width = new short[1];
        short[] height = new short[1];
        int xmString = OS.XmStringCreateLocalized(buffer);
        OS.XmStringExtent(fontList, xmString, width, height);
        run.width = width[0] & 0xFFFF;
        run.height = height[0] & 0xFFFF;
        run.baseline = OS.XmStringBaseline(fontList, xmString);
        OS.XmStringFree(xmString);
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
        XFontStruct fontStruct = this.getFontHeigth(font != null ? font : this.device.getSystemFont());
        this.defaultAscent = fontStruct.ascent;
        this.defaultDescent = fontStruct.descent;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        this.orientation = orientation;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i;
            for (i = 0; i < segments.length && this.segments[i] == segments[i]; ++i) {
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setStyle(TextStyle style, int start, int end) {
        StyleItem item;
        int i;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (start <= this.styles[index].start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (0 <= high && high < this.styles.length) {
            StyleItem item2 = this.styles[high];
            if (item2.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item2.style == null : style.equals(item2.style))) {
                return;
            }
        }
        this.freeRuns();
        int count = 0;
        StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
        for (i = 0; i < this.styles.length; ++i) {
            StyleItem item3 = this.styles[i];
            if (item3.start >= start) break;
            newStyles[count++] = item3;
        }
        StyleItem newItem = new StyleItem();
        newItem.start = start;
        newItem.style = style;
        newStyles[count++] = newItem;
        if (this.styles[i].start > end) {
            newItem = new StyleItem();
            newItem.start = end + 1;
            newItem.style = this.styles[i - 1].style;
            newStyles[count++] = newItem;
        } else {
            while (i < this.styles.length) {
                item = this.styles[i];
                if (item.start > end) break;
                ++i;
            }
            if (end != this.styles[i].start - 1) {
                this.styles[--i].start = end + 1;
            }
        }
        while (i < this.styles.length) {
            item = this.styles[i];
            if (item.start > end) {
                newStyles[count++] = item;
            }
            ++i;
        }
        if (newStyles.length != count) {
            this.styles = new StyleItem[count];
            System.arraycopy(newStyles, 0, this.styles, 0, count);
        } else {
            this.styles = newStyles;
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i;
            for (i = 0; i < tabs.length && this.tabs[i] == tabs[i]; ++i) {
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int length;
        int width;
        int height;
        int baseline;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;

        StyleItem() {
        }
    }
}

