/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ViewForm
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int horizontalSpacing = 1;
    public int verticalSpacing = 1;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    private Control topLeft;
    private Control topCenter;
    private Control topRight;
    private Control content;
    private boolean separateTopCenter = false;
    private boolean showBorder = false;
    private int separator = -1;
    private int borderTop = 0;
    private int borderBottom = 0;
    private int borderLeft = 0;
    private int borderRight = 0;
    private int highlight = 0;
    private Rectangle oldArea;
    private Color selectionBackground;
    static final int OFFSCREEN = -200;
    static final int BORDER1_COLOR = 18;
    static final int SELECTION_BACKGROUND = 25;

    public ViewForm(Composite parent, int style) {
        super(parent, ViewForm.checkStyle(style));
        this.setBorderVisible((style & 0x800) != 0);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        ViewForm.this.onDispose();
                        break;
                    }
                    case 9: {
                        ViewForm.this.onPaint(e.gc);
                        break;
                    }
                    case 11: {
                        ViewForm.this.onResize();
                    }
                }
            }
        };
        int[] events = new int[]{12, 9, 11};
        for (int i = 0; i < events.length; ++i) {
            this.addListener(events[i], listener);
        }
    }

    static int checkStyle(int style) {
        int mask = 0x6800000;
        return style & mask | 0x100000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point leftSize = new Point(0, 0);
        if (this.topLeft != null) {
            leftSize = this.topLeft.computeSize(-1, -1);
        }
        Point centerSize = new Point(0, 0);
        if (this.topCenter != null) {
            centerSize = this.topCenter.computeSize(-1, -1);
        }
        Point rightSize = new Point(0, 0);
        if (this.topRight != null) {
            rightSize = this.topRight.computeSize(-1, -1);
        }
        Point size = new Point(0, 0);
        if (this.separateTopCenter || wHint != -1 && leftSize.x + centerSize.x + rightSize.x > wHint) {
            size.x = leftSize.x + rightSize.x;
            if (leftSize.x > 0 && rightSize.x > 0) {
                size.x += this.horizontalSpacing;
            }
            size.x = Math.max(centerSize.x, size.x);
            size.y = Math.max(leftSize.y, rightSize.y);
            if (this.topCenter != null) {
                size.y += centerSize.y;
                if (this.topLeft != null || this.topRight != null) {
                    size.y += this.verticalSpacing;
                }
            }
        } else {
            size.x = leftSize.x + centerSize.x + rightSize.x;
            int count = -1;
            if (leftSize.x > 0) {
                ++count;
            }
            if (centerSize.x > 0) {
                ++count;
            }
            if (rightSize.x > 0) {
                ++count;
            }
            if (count > 0) {
                size.x += count * this.horizontalSpacing;
            }
            size.y = Math.max(leftSize.y, Math.max(centerSize.y, rightSize.y));
        }
        if (this.content != null) {
            if (this.topLeft != null || this.topRight != null || this.topCenter != null) {
                ++size.y;
            }
            Point contentSize = new Point(0, 0);
            contentSize = this.content.computeSize(-1, -1);
            size.x = Math.max(size.x, contentSize.x);
            size.y += contentSize.y;
            if (size.y > contentSize.y) {
                size.y += this.verticalSpacing;
            }
        }
        size.x += 2 * this.marginWidth;
        size.y += 2 * this.marginHeight;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.borderLeft - this.highlight;
        int trimY = y - this.borderTop - this.highlight;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.highlight;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.highlight;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle clientArea = super.getClientArea();
        clientArea.x += this.borderLeft;
        clientArea.y += this.borderTop;
        clientArea.width -= this.borderLeft + this.borderRight;
        clientArea.height -= this.borderTop + this.borderBottom;
        return clientArea;
    }

    public Control getContent() {
        return this.content;
    }

    public Control getTopCenter() {
        return this.topCenter;
    }

    public Control getTopLeft() {
        return this.topLeft;
    }

    public Control getTopRight() {
        return this.topRight;
    }

    public void layout(boolean changed) {
        int topHeight;
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        Point leftSize = new Point(0, 0);
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            leftSize = this.topLeft.computeSize(-1, -1);
        }
        Point centerSize = new Point(0, 0);
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            centerSize = this.topCenter.computeSize(-1, -1);
        }
        Point rightSize = new Point(0, 0);
        if (this.topRight != null && !this.topRight.isDisposed()) {
            rightSize = this.topRight.computeSize(-1, -1);
        }
        int minTopWidth = leftSize.x + centerSize.x + rightSize.x + 2 * this.marginWidth + 2 * this.highlight;
        int count = -1;
        if (leftSize.x > 0) {
            ++count;
        }
        if (centerSize.x > 0) {
            ++count;
        }
        if (rightSize.x > 0) {
            ++count;
        }
        if (count > 0) {
            minTopWidth += count * this.horizontalSpacing;
        }
        int x = rect.x + rect.width - this.marginWidth - this.highlight;
        int y = rect.y + this.marginHeight + this.highlight;
        boolean top = false;
        if (this.separateTopCenter || minTopWidth > rect.width) {
            topHeight = Math.max(rightSize.y, leftSize.y);
            if (this.topRight != null && !this.topRight.isDisposed()) {
                top = true;
                this.topRight.setBounds(x -= rightSize.x, y, rightSize.x, topHeight);
                x -= this.horizontalSpacing;
            }
            if (this.topLeft != null && !this.topLeft.isDisposed()) {
                top = true;
                leftSize = this.topLeft.computeSize(x - rect.x - this.marginWidth - this.highlight, -1);
                this.topLeft.setBounds(rect.x + this.marginWidth + this.highlight, y, leftSize.x, topHeight);
            }
            if (top) {
                y += topHeight + this.verticalSpacing;
            }
            if (this.topCenter != null && !this.topCenter.isDisposed()) {
                top = true;
                int w = rect.width - 2 * this.marginWidth - 2 * this.highlight;
                int trim = this.topCenter.computeSize((int)w, (int)-1).x - w;
                centerSize = this.topCenter.computeSize(w - trim, -1);
                this.topCenter.setBounds(rect.x + rect.width - this.marginWidth - this.highlight - centerSize.x, y, centerSize.x, centerSize.y);
                y += centerSize.y + this.verticalSpacing;
            }
        } else {
            topHeight = Math.max(rightSize.y, Math.max(centerSize.y, leftSize.y));
            if (this.topRight != null && !this.topRight.isDisposed()) {
                top = true;
                this.topRight.setBounds(x -= rightSize.x, y, rightSize.x, topHeight);
                x -= this.horizontalSpacing;
            }
            if (this.topCenter != null && !this.topCenter.isDisposed()) {
                top = true;
                this.topCenter.setBounds(x -= centerSize.x, y, centerSize.x, topHeight);
                x -= this.horizontalSpacing;
            }
            if (this.topLeft != null && !this.topLeft.isDisposed()) {
                top = true;
                leftSize = this.topLeft.computeSize(x - rect.x - this.marginWidth - this.highlight, topHeight);
                this.topLeft.setBounds(rect.x + this.marginWidth + this.highlight, y, leftSize.x, topHeight);
            }
            if (top) {
                y += topHeight + this.verticalSpacing;
            }
        }
        int oldSeperator = this.separator;
        this.separator = -1;
        if (this.content != null && !this.content.isDisposed()) {
            if (this.topLeft != null || this.topRight != null || this.topCenter != null) {
                this.separator = y++;
            }
            this.content.setBounds(rect.x + this.marginWidth + this.highlight, y, rect.width - 2 * this.marginWidth - 2 * this.highlight, rect.y + rect.height - y - this.marginHeight - this.highlight);
        }
        if (oldSeperator != -1 && this.separator != -1) {
            int t = Math.min(this.separator, oldSeperator);
            int b = Math.max(this.separator, oldSeperator);
            this.redraw(this.borderLeft, t, this.getSize().x - this.borderLeft - this.borderRight, b - t, false);
        }
    }

    void onDispose() {
        this.topLeft = null;
        this.topCenter = null;
        this.topRight = null;
        this.content = null;
        this.oldArea = null;
        this.selectionBackground = null;
    }

    void onPaint(GC gc) {
        Color gcForeground = gc.getForeground();
        Point size = this.getSize();
        Color border = this.getDisplay().getSystemColor(18);
        if (this.showBorder) {
            gc.setForeground(border);
            gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
            if (this.highlight > 0) {
                int x1 = 1;
                int y1 = 1;
                int x2 = size.x - 1;
                int y2 = size.y - 1;
                int[] shape = new int[]{x1, y1, x2, y1, x2, y2, x1, y2, x1, y1 + this.highlight, x1 + this.highlight, y1 + this.highlight, x1 + this.highlight, y2 - this.highlight, x2 - this.highlight, y2 - this.highlight, x2 - this.highlight, y1 + this.highlight, x1, y1 + this.highlight};
                Color highlightColor = this.getDisplay().getSystemColor(26);
                gc.setBackground(highlightColor);
                gc.fillPolygon(shape);
            }
        }
        if (this.separator > -1) {
            gc.setForeground(border);
            gc.drawLine(this.borderLeft + this.highlight, this.separator, size.x - this.borderLeft - this.borderRight - this.highlight, this.separator);
        }
        gc.setForeground(gcForeground);
    }

    void onResize() {
        this.layout();
        Rectangle area = super.getClientArea();
        if (this.oldArea == null || this.oldArea.width == 0 || this.oldArea.height == 0) {
            this.redraw();
        } else {
            int width = 0;
            if (this.oldArea.width < area.width) {
                width = area.width - this.oldArea.width + this.borderRight + this.highlight;
            } else if (this.oldArea.width > area.width) {
                width = this.borderRight + this.highlight;
            }
            this.redraw(area.x + area.width - width, area.y, width, area.height, false);
            int height = 0;
            if (this.oldArea.height < area.height) {
                height = area.height - this.oldArea.height + this.borderBottom + this.highlight;
            }
            if (this.oldArea.height > area.height) {
                height = this.borderBottom + this.highlight;
            }
            this.redraw(area.x, area.y + area.height - height, area.width, height, false);
        }
        this.oldArea = area;
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (content != null && content.getParent() != this) {
            SWT.error(5);
        }
        if (this.content != null && !this.content.isDisposed()) {
            this.content.setBounds(-200, -200, 0, 0);
        }
        this.content = content;
        this.layout();
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            this.topLeft.setFont(f);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            this.topCenter.setFont(f);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.topRight.setFont(f);
        }
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    void setSelectionBackground(Color color) {
        this.checkWidget();
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.redraw();
    }

    public void setTopCenter(Control topCenter) {
        this.checkWidget();
        if (topCenter != null && topCenter.getParent() != this) {
            SWT.error(5);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            Point size = this.topCenter.getSize();
            this.topCenter.setLocation(-200 - size.x, -200 - size.y);
        }
        this.topCenter = topCenter;
        this.layout();
    }

    public void setTopLeft(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error(5);
        }
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            Point size = this.topLeft.getSize();
            this.topLeft.setLocation(-200 - size.x, -200 - size.y);
        }
        this.topLeft = c;
        this.layout();
    }

    public void setTopRight(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error(5);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            Point size = this.topRight.getSize();
            this.topRight.setLocation(-200 - size.x, -200 - size.y);
        }
        this.topRight = c;
        this.layout();
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.showBorder == show) {
            return;
        }
        this.showBorder = show;
        if (this.showBorder) {
            this.borderBottom = 1;
            this.borderRight = 1;
            this.borderTop = 1;
            this.borderLeft = 1;
            if ((this.getStyle() & 0x800000) == 0) {
                this.highlight = 2;
            }
        } else {
            this.borderRight = 0;
            this.borderLeft = 0;
            this.borderTop = 0;
            this.borderBottom = 0;
            this.highlight = 0;
        }
        this.layout();
        this.redraw();
    }

    public void setTopCenterSeparate(boolean show) {
        this.checkWidget();
        this.separateTopCenter = show;
        this.layout();
    }
}

