/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;

public class OrganizeImportsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public OrganizeImportsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("OrganizeImportsAction.label"));
        this.setToolTipText(ActionMessages.getString("OrganizeImportsAction.tooltip"));
        this.setDescription(ActionMessages.getString("OrganizeImportsAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.organize_imports_action_context");
    }

    public OrganizeImportsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(OrganizeImportsAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(OrganizeImportsAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        Object[] selected = selection.toArray();
        for (int i = 0; i < selected.length; ++i) {
            try {
                if (selected[i] instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)selected[i];
                    if (!elem.exists()) continue;
                    switch (elem.getElementType()) {
                        case 7: {
                            if (elem.getParent().getElementType() != 5) break;
                            result.add(elem.getParent());
                            break;
                        }
                        case 5: {
                            result.add(elem);
                            break;
                        }
                        case 12: {
                            result.add(elem.getParent());
                            break;
                        }
                        case 4: {
                            this.collectCompilationUnits((IPackageFragment)elem, result);
                            break;
                        }
                        case 3: {
                            this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                            break;
                        }
                        case 2: {
                            IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                            for (int k = 0; k < roots.length; ++k) {
                                this.collectCompilationUnits(roots[k], result);
                            }
                            break;
                        }
                    }
                    continue;
                }
                if (!(selected[i] instanceof LogicalPackage)) continue;
                IPackageFragment[] packageFragments = ((LogicalPackage)((Object)selected[i])).getFragments();
                for (int k = 0; k < packageFragments.length; ++k) {
                    IPackageFragment pack = packageFragments[k];
                    if (!pack.exists()) continue;
                    this.collectCompilationUnits(pack, result);
                }
                continue;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
            }
        }
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        for (int i = 0; i < selected.length; ++i) {
            try {
                if (selected[i] instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)selected[i];
                    if (elem.exists()) {
                        switch (elem.getElementType()) {
                            case 7: {
                                return elem.getParent().getElementType() == 5;
                            }
                            case 5: {
                                return true;
                            }
                            case 12: {
                                return true;
                            }
                            case 3: 
                            case 4: {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                return root.getKind() == 1;
                            }
                            case 2: {
                                return true;
                            }
                        }
                    }
                    continue;
                }
                if (!(selected[i] instanceof LogicalPackage)) continue;
                return true;
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) continue;
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private boolean hasSourceFolders(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() != 1) continue;
            return true;
        }
        return false;
    }

    public void run(ITextSelection selection) {
        ICompilationUnit cu = OrganizeImportsAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }

    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            return;
        }
        if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    public void runOnMultiple(final ICompilationUnit[] cus) {
        try {
            String message = ActionMessages.getString("OrganizeImportsAction.multi.status.description");
            final MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, message, null);
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    OrganizeImportsAction.this.doRunOnMultiple(cus, status, monitor);
                }
            }));
            if (!status.isOK()) {
                String title = ActionMessages.getString("OrganizeImportsAction.multi.status.title");
                ProblemDialog.open(this.getShell(), title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("OrganizeImportsAction.error.title"), ActionMessages.getString("OrganizeImportsAction.error.message"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunOnMultiple(ICompilationUnit[] cus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.getString("OrganizeImportsAction.multi.op.description"));
        monitor.beginTask("", cus.length);
        try {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference(store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold(store);
            boolean ignoreLowerCaseNames = store.getBoolean("org.eclipse.jdt.ui.ignorelowercasenames");
            OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

                public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                    throw new OrganizeImportError();
                }
            };
            for (int i = 0; i < cus.length; ++i) {
                ICompilationUnit cu = cus[i];
                if (!this.testOnBuildPath(cu, status)) continue;
                String cuLocation = cu.getPath().makeRelative().toString();
                monitor.subTask(cuLocation);
                try {
                    OrganizeImportsOperation op = new OrganizeImportsOperation(cu, prefOrder, threshold, ignoreLowerCaseNames, !cu.isWorkingCopy(), true, query);
                    this.runInSync(op, cuLocation, status, monitor);
                    IProblem parseError = op.getParseError();
                    if (parseError != null) {
                        String message = ActionMessages.getFormattedString("OrganizeImportsAction.multi.error.parse", cuLocation);
                        status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    String message = ActionMessages.getFormattedString("OrganizeImportsAction.multi.error.unexpected", e.getStatus().getMessage());
                    status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean testOnBuildPath(ICompilationUnit cu, MultiStatus status) {
        IJavaProject project = cu.getJavaProject();
        if (!project.isOnClasspath((IJavaElement)cu)) {
            String cuLocation = cu.getPath().makeRelative().toString();
            String message = ActionMessages.getFormattedString("OrganizeImportsAction.multi.error.notoncp", cuLocation);
            status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
            return false;
        }
        return true;
    }

    private void runInSync(final OrganizeImportsOperation op, final String cuLocation, final MultiStatus status, final IProgressMonitor monitor) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (ValidateEditException e) {
                    status.add(e.getStatus());
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    String message = ActionMessages.getFormattedString("OrganizeImportsAction.multi.error.unexpected", e.getStatus().getMessage());
                    status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
                }
                catch (OrganizeImportError e) {
                    String message = ActionMessages.getFormattedString("OrganizeImportsAction.multi.error.unresolvable", cuLocation);
                    status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
                }
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ICompilationUnit cu) {
        if (!ElementValidator.check((IJavaElement)cu, this.getShell(), ActionMessages.getString("OrganizeImportsAction.error.title"), this.fEditor != null)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        try {
            IEditorPart editor;
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference(store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold(store);
            boolean ignoreLowerCaseNames = store.getBoolean("org.eclipse.jdt.ui.ignorelowercasenames");
            if (this.fEditor == null && EditorUtility.isOpenInEditor(cu) == null && (editor = EditorUtility.openInEditor(cu)) instanceof JavaEditor) {
                this.fEditor = (JavaEditor)editor;
            }
            OrganizeImportsOperation op = new OrganizeImportsOperation(cu, prefOrder, threshold, ignoreLowerCaseNames, !cu.isWorkingCopy(), true, this.createChooseImportQuery());
            IRewriteTarget target = null;
            if (this.fEditor != null && (target = (IRewriteTarget)this.fEditor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = OrganizeImportsAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget)) != null) {
                target.beginCompoundChange();
            }
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                IProblem parseError = op.getParseError();
                if (parseError != null) {
                    String message = ActionMessages.getFormattedString("OrganizeImportsAction.single.error.parse", parseError.getMessage());
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.getString("OrganizeImportsAction.error.title"), (String)message);
                    if (this.fEditor != null && parseError.getSourceStart() != -1) {
                        this.fEditor.selectAndReveal(parseError.getSourceStart(), parseError.getSourceEnd() - parseError.getSourceStart() + 1);
                    }
                } else if (this.fEditor != null) {
                    this.setStatusBarMessage(this.getOrganizeInfo(op));
                }
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("OrganizeImportsAction.error.title"), ActionMessages.getString("OrganizeImportsAction.error.message"));
            }
            catch (InterruptedException e) {
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("OrganizeImportsAction.error.title"), ActionMessages.getString("OrganizeImportsAction.error.message"));
        }
    }

    private String getOrganizeInfo(OrganizeImportsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        if (nImportsAdded >= 0) {
            return ActionMessages.getFormattedString("OrganizeImportsAction.summary_added", String.valueOf(nImportsAdded));
        }
        return ActionMessages.getFormattedString("OrganizeImportsAction.summary_removed", String.valueOf(-nImportsAdded));
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery() {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                return OrganizeImportsAction.this.doChooseImports(openChoices, ranges);
            }
        };
    }

    private TypeInfo[] doChooseImports(TypeInfo[][] openChoices, final ISourceRange[] ranges) {
        ISelection sel = this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : null;
        TypeInfo[] result = null;
        TypeInfoLabelProvider labelProvider = new TypeInfoLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeImportsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges);
            }
        };
        dialog.setTitle(ActionMessages.getString("OrganizeImportsAction.selectiondialog.title"));
        dialog.setMessage(ActionMessages.getString("OrganizeImportsAction.selectiondialog.message"));
        dialog.setElements(openChoices);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeInfo[res.length];
            for (int i = 0; i < res.length; ++i) {
                Object[] array = (Object[])res[i];
                if (array.length <= 0) continue;
                result[i] = (TypeInfo)array[0];
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            this.fEditor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges) {
        if (this.fEditor != null && ranges != null && page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            this.fEditor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void setStatusBarMessage(String message) {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager manager = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            manager.setMessage(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class OrganizeImportError
    extends RuntimeException {
        OrganizeImportError() {
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private OrganizeImportsAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new OrganizeImportsAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }
}

