/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private static final List EMPTY_LIST = new ArrayList(0);
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public ResourceTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        List resources = this.convertSelection();
        event.data = resources.toArray(new IResource[resources.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail == 2) {
            this.handleFinishedDropMove(event);
        }
    }

    private List convertSelection() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return EMPTY_LIST;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IAdaptable adaptable;
            IResource resource;
            Object element = iter.next();
            if (!(element instanceof IAdaptable) || (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(class$org$eclipse$core$resources$IResource == null ? ResourceTransferDragAdapter.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) == null) continue;
            result.add(resource);
        }
        return result;
    }

    private void handleFinishedDropMove(DragSourceEvent event) {
        MultiStatus status = new MultiStatus(JavaPlugin.getPluginId(), 10001, JavaUIMessages.getString("ResourceTransferDragAdapter.cannot_delete_resource"), null);
        List resources = this.convertSelection();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (status.getChildren().length > 0) {
            Shell parent = SWTUtil.getShell(event.widget);
            ErrorDialog error = new ErrorDialog(parent, JavaUIMessages.getString("ResourceTransferDragAdapter.moving_resource"), JavaUIMessages.getString("ResourceTransferDragAdapter.cannot_delete_files"), (IStatus)status, 4);
            error.open();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

