/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public final class FuzzyTermEnum
extends FilteredTermEnum {
    double distance;
    boolean fieldMatch = false;
    boolean endEnum = false;
    Term searchTerm = null;
    String field = "";
    String text = "";
    int textlen;
    public static final double FUZZY_THRESHOLD = 0.5;
    public static final double SCALE_FACTOR = 2.0;
    private int[][] e = new int[1][1];

    public FuzzyTermEnum(IndexReader reader, Term term) throws IOException {
        super(reader, term);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        this.text = this.searchTerm.text();
        this.textlen = this.text.length();
        this.setEnum(reader.terms(new Term(this.searchTerm.field(), "")));
    }

    protected final boolean termCompare(Term term) {
        if (this.field == term.field()) {
            String target = term.text();
            int targetlen = target.length();
            int dist = this.editDistance(this.text, target, this.textlen, targetlen);
            this.distance = 1.0 - (double)dist / (double)Math.min(this.textlen, targetlen);
            return this.distance > 0.5;
        }
        this.endEnum = true;
        return false;
    }

    protected final float difference() {
        return (float)((this.distance - 0.5) * 2.0);
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    private final int editDistance(String s, String t, int n, int m) {
        int j;
        int i;
        if (this.e.length <= n || this.e[0].length <= m) {
            this.e = new int[Math.max(this.e.length, n + 1)][Math.max(this.e[0].length, m + 1)];
        }
        int[][] d = this.e;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                d[i][j] = s_i != t.charAt(j - 1) ? FuzzyTermEnum.min(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1]) + 1 : FuzzyTermEnum.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1]);
            }
        }
        return d[n][m];
    }

    public void close() throws IOException {
        super.close();
        this.searchTerm = null;
        this.field = null;
        this.text = null;
    }
}

