/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.util.Util;

public class ReconcileWorkingCopyOperation
extends JavaModelOperation {
    boolean createAST;
    int astLevel;
    boolean forceProblemDetection;
    WorkingCopyOwner workingCopyOwner;
    org.eclipse.jdt.core.dom.CompilationUnit ast;

    public ReconcileWorkingCopyOperation(IJavaElement workingCopy, boolean creatAST, int astLevel, boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner) {
        super(new IJavaElement[]{workingCopy});
        this.createAST = creatAST;
        this.astLevel = astLevel;
        this.forceProblemDetection = forceProblemDetection;
        this.workingCopyOwner = workingCopyOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeOperation() throws JavaModelException {
        if (this.progressMonitor != null) {
            if (this.progressMonitor.isCanceled()) {
                return;
            }
            this.progressMonitor.beginTask(Util.bind("element.reconciling"), 2);
        }
        CompilationUnit workingCopy = this.getWorkingCopy();
        boolean wasConsistent = workingCopy.isConsistent();
        try {
            JavaModelManager.PerWorkingCopyInfo problemRequestor;
            if (!wasConsistent) {
                JavaElementDeltaBuilder deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
                this.ast = workingCopy.makeConsistent(this.createAST, this.astLevel, this.progressMonitor);
                deltaBuilder.buildDeltas();
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(2);
                }
                if (deltaBuilder.delta != null) {
                    this.addReconcileDelta(workingCopy, deltaBuilder.delta);
                }
            } else if (this.forceProblemDetection && (problemRequestor = workingCopy.getPerWorkingCopyInfo()) != null && problemRequestor.isActive()) {
                CompilationUnitDeclaration unit = null;
                try {
                    problemRequestor.beginReporting();
                    char[] contents = workingCopy.getContents();
                    unit = CompilationUnitProblemFinder.process(workingCopy, contents, this.workingCopyOwner, problemRequestor, false, this.progressMonitor);
                    problemRequestor.endReporting();
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                    if (this.createAST && unit != null) {
                        Map options = workingCopy.getJavaProject().getOptions(true);
                        this.ast = AST.convertCompilationUnit(this.astLevel, unit, contents, options, true, this.progressMonitor);
                        if (this.progressMonitor != null) {
                            this.progressMonitor.worked(1);
                        }
                    }
                }
                finally {
                    if (unit != null) {
                        unit.cleanUp();
                    }
                }
            }
            Object var9_9 = null;
            if (this.progressMonitor == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.progressMonitor == null) throw throwable;
            this.progressMonitor.done();
            throw throwable;
        }
        this.progressMonitor.done();
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        CompilationUnit workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new JavaModelStatus(969, workingCopy);
        }
        return status;
    }
}

