/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLWhitespaceDetector;

public class XMLScanner
extends RuleBasedScanner {
    private Token fProcInstr;

    public XMLScanner(IColorManager manager) {
        this.fProcInstr = new Token((Object)new TextAttribute(manager.getColor("editor.color.instr")));
        IRule[] rules = new IRule[]{new SingleLineRule("<?", "?>", (IToken)this.fProcInstr), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
        this.setRules(rules);
    }

    protected void adaptToColorChange(ColorManager colorManager, PropertyChangeEvent event, Token token) {
        colorManager.updateProperty(event.getProperty());
        TextAttribute attr = (TextAttribute)token.getData();
        token.setData((Object)new TextAttribute(colorManager.getColor(event.getProperty()), attr.getBackground(), attr.getStyle()));
    }

    private Token getTokenAffected(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("editor.color.instr")) {
            return this.fProcInstr;
        }
        return (Token)this.fDefaultReturnToken;
    }

    public void adaptToPreferenceChange(ColorManager colorManager, PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.startsWith("editor.color.default") || property.startsWith("editor.color.instr")) {
            this.adaptToColorChange(colorManager, event, this.getTokenAffected(event));
        }
    }
}

