/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class SystemFileMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IResourceDeltaVisitor fResourceDeltaVisitor = new ResourceDeltaVisitor();
    private File file;

    public SystemFileMarkerAnnotationModel(File file) {
        this.fWorkspace = PDEPlugin.getWorkspace();
        this.fResource = this.fWorkspace.getRoot();
        this.file = file;
    }

    protected boolean isAcceptable(IMarker marker) {
        if (marker == null) {
            return false;
        }
        if (!this.fResource.equals(marker.getResource())) {
            return false;
        }
        try {
            String path = (String)marker.getAttribute("org.eclipse.pde.ui.systemFilePath");
            if (path == null) {
                return false;
            }
            return path.equals(this.file.getPath());
        }
        catch (CoreException e) {
            return false;
        }
    }

    private void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        block5: for (int i = 0; i < markerDeltas.length; ++i) {
            IMarkerDelta delta = markerDeltas[i];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    continue block5;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    continue block5;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                }
            }
        }
        this.fireModelChanged();
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (int i = 0; i < markers.length; ++i) {
                    markers[i].delete();
                }
            }
        }, null);
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] markers = this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
        if (markers.length == 0) {
            return markers;
        }
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        for (int i = 0; i < markers.length; ++i) {
            IMarker marker = markers[i];
            String path = (String)marker.getAttribute("org.eclipse.pde.ui.systemFilePath");
            if (path == null || !path.equals(this.file.getPath())) continue;
            result.add(marker);
        }
        return result.toArray(new IMarker[result.size()]);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && SystemFileMarkerAnnotationModel.this.fResource.equals(delta.getResource())) {
                SystemFileMarkerAnnotationModel.this.update(delta.getMarkerDeltas());
                return false;
            }
            return true;
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null) {
                    delta.accept(SystemFileMarkerAnnotationModel.this.fResourceDeltaVisitor);
                }
            }
            catch (CoreException x) {
                PDEPlugin.logException(x);
            }
        }
    }
}

