/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportJob;

public class BuildSiteJob
extends FeatureExportJob {
    private IProject fSiteProject;

    public BuildSiteJob(IFeatureModel[] models, IProject project, ISiteBuildModel buildModel) {
        super(2, false, project.getLocation().toOSString(), null, models);
        this.fSiteProject = project;
        this.setRule(MultiRule.combine((ISchedulingRule)this.fSiteProject, (ISchedulingRule)this.getRule()));
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.touchSite(monitor);
        IStatus status = super.run(monitor);
        this.refresh(monitor);
        return status;
    }

    private void touchSite(IProgressMonitor monitor) {
        File file = new File(this.fSiteProject.getLocation().toOSString(), "site.xml");
        file.setLastModified(System.currentTimeMillis());
    }

    private void refresh(IProgressMonitor monitor) {
        try {
            this.fSiteProject.refreshLocal(2, monitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected String getLogFoundMessage() {
        return PDEPlugin.getResourceString("BuildSiteJob.message");
    }
}

