/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.b;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.en;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
extends en
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new a();
    private final int iM;
    private final String nb;
    private final String ol;
    private final long nN;
    private final int om;
    private final String mo;
    private final int nR;
    private final Bundle oh;
    private final ArrayList<ParticipantEntity> nQ;
    private final int on;

    public RoomEntity(Room room) {
        this.iM = 2;
        this.nb = room.getRoomId();
        this.ol = room.getCreatorId();
        this.nN = room.getCreationTimestamp();
        this.om = room.getStatus();
        this.mo = room.getDescription();
        this.nR = room.getVariant();
        this.oh = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.nQ = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.nQ.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.on = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.iM = versionCode;
        this.nb = roomId;
        this.ol = creatorId;
        this.nN = creationTimestamp;
        this.om = roomStatus;
        this.mo = description;
        this.nR = variant;
        this.oh = autoMatchCriteria;
        this.nQ = participants;
        this.on = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.iM;
    }

    @Override
    public String getRoomId() {
        return this.nb;
    }

    @Override
    public String getCreatorId() {
        return this.ol;
    }

    @Override
    public long getCreationTimestamp() {
        return this.nN;
    }

    @Override
    public int getStatus() {
        return this.om;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        int n2 = this.nQ.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.nQ.get(i2);
            if (!participant.getParticipantId().equals(participantId)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + participantId + " is not in room " + this.getRoomId());
    }

    @Override
    public String getDescription() {
        return this.mo;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        eg.b(this.mo, dataOut);
    }

    @Override
    public int getVariant() {
        return this.nR;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.oh;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.nQ);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        int n2 = this.nQ.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.nQ.get(i2).getParticipantId());
        }
        return arrayList;
    }

    @Override
    public String getParticipantId(String playerId) {
        String string2 = null;
        int n2 = this.nQ.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.nQ.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(playerId)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.on;
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return dl.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a(this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return dl.equal(room2.getRoomId(), room.getRoomId()) && dl.equal(room2.getCreatorId(), room.getCreatorId()) && dl.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && dl.equal(room2.getStatus(), room.getStatus()) && dl.equal(room2.getDescription(), room.getDescription()) && dl.equal(room2.getVariant(), room.getVariant()) && dl.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && dl.equal(room2.getParticipants(), room.getParticipants()) && dl.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return dl.d(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.aX()) {
            b.a(this, dest, flags);
        } else {
            dest.writeString(this.nb);
            dest.writeString(this.ol);
            dest.writeLong(this.nN);
            dest.writeInt(this.om);
            dest.writeString(this.mo);
            dest.writeInt(this.nR);
            dest.writeBundle(this.oh);
            int n2 = this.nQ.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.nQ.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends b {
        a() {
        }

        public RoomEntity y(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.aW());
            if (bl2 || RoomEntity.y(RoomEntity.class.getCanonicalName())) {
                return super.y(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string4 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string2, string3, l2, n3, string4, n4, bundle, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.y(x0);
        }
    }
}

