/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.eg;

public final class c
implements LeaderboardScore {
    private final long nx;
    private final String ny;
    private final String nz;
    private final long nA;
    private final long nB;
    private final String nC;
    private final Uri nD;
    private final Uri nE;
    private final PlayerEntity nF;
    private final String nG;

    public c(LeaderboardScore leaderboardScore) {
        this.nx = leaderboardScore.getRank();
        this.ny = dm.e(leaderboardScore.getDisplayRank());
        this.nz = dm.e(leaderboardScore.getDisplayScore());
        this.nA = leaderboardScore.getRawScore();
        this.nB = leaderboardScore.getTimestampMillis();
        this.nC = leaderboardScore.getScoreHolderDisplayName();
        this.nD = leaderboardScore.getScoreHolderIconImageUri();
        this.nE = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.nF = player == null ? null : (PlayerEntity)player.freeze();
        this.nG = leaderboardScore.getScoreTag();
    }

    public long getRank() {
        return this.nx;
    }

    public String getDisplayRank() {
        return this.ny;
    }

    public void getDisplayRank(CharArrayBuffer dataOut) {
        eg.b(this.ny, dataOut);
    }

    public String getDisplayScore() {
        return this.nz;
    }

    public void getDisplayScore(CharArrayBuffer dataOut) {
        eg.b(this.nz, dataOut);
    }

    public long getRawScore() {
        return this.nA;
    }

    public long getTimestampMillis() {
        return this.nB;
    }

    public String getScoreHolderDisplayName() {
        if (this.nF == null) {
            return this.nC;
        }
        return this.nF.getDisplayName();
    }

    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.nF == null) {
            eg.b(this.nC, dataOut);
            return;
        }
        this.nF.getDisplayName(dataOut);
    }

    public Uri getScoreHolderIconImageUri() {
        if (this.nF == null) {
            return this.nD;
        }
        return this.nF.getIconImageUri();
    }

    public Uri getScoreHolderHiResImageUri() {
        if (this.nF == null) {
            return this.nE;
        }
        return this.nF.getHiResImageUri();
    }

    public Player getScoreHolder() {
        return this.nF;
    }

    public String getScoreTag() {
        return this.nG;
    }

    public LeaderboardScore cd() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return c.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return dl.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return c.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return dl.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && dl.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && dl.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && dl.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && dl.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && dl.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && dl.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && dl.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && dl.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && dl.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return c.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return dl.d(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.cd();
    }
}

