/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.MembershipKeyImpl;
import sun.nio.ch.MembershipRegistry;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd = new DatagramDispatcher();
    private final FileDescriptor fd;
    private final int fdVal;
    private final ProtocolFamily family;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private InetAddress cachedSenderInetAddress;
    private int cachedSenderPort;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_CONNECTED = 1;
    private static final int ST_KILLED = 2;
    private int state = -1;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private DatagramSocket socket;
    private MembershipRegistry registry;
    private SocketAddress sender;

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.fd = Net.socket(this.family, false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    public DatagramChannelImpl(SelectorProvider selectorProvider, ProtocolFamily protocolFamily) {
        super(selectorProvider);
        if (protocolFamily != StandardProtocolFamily.INET && protocolFamily != StandardProtocolFamily.INET6) {
            throw new UnsupportedOperationException("Protocol family not supported");
        }
        if (protocolFamily == StandardProtocolFamily.INET6 && !Net.isIPv6Available()) {
            throw new UnsupportedOperationException("IPv6 not available");
        }
        this.family = protocolFamily;
        this.fd = Net.socket(protocolFamily, false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    public DatagramChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) throws IOException {
        super(selectorProvider);
        this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        this.localAddress = Net.localAddress(fileDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                return null;
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getConnectedAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                return null;
            }
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel setOption(SocketOption socketOption, Object object) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.options().contains(socketOption)) {
            throw new IllegalArgumentException("Invalid option name");
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            if (socketOption == StandardSocketOption.IP_TOS) {
                if (this.family == StandardProtocolFamily.INET) {
                    Net.setSocketOption(this.fd, this.family, socketOption, object);
                }
                return this;
            }
            if (socketOption == StandardSocketOption.IP_MULTICAST_TTL || socketOption == StandardSocketOption.IP_MULTICAST_LOOP) {
                Net.setSocketOption(this.fd, this.family, socketOption, object);
                return this;
            }
            if (socketOption == StandardSocketOption.IP_MULTICAST_IF) {
                if (object == null) {
                    throw new IllegalArgumentException("Cannot set IP_MULTICAST_IF to 'null'");
                }
                NetworkInterface networkInterface = (NetworkInterface)object;
                if (this.family == StandardProtocolFamily.INET6) {
                    int n = networkInterface.getIndex();
                    if (n == -1) {
                        throw new IOException("Network interface cannot be identified");
                    }
                    Net.setInterface6(this.fd, n);
                } else {
                    Inet4Address inet4Address = Net.anyInet4Address(networkInterface);
                    if (inet4Address == null) {
                        throw new IOException("Network interface not configured for IPv4");
                    }
                    int n = Net.inet4AsInt(inet4Address);
                    Net.setInterface4(this.fd, n);
                }
                return this;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, object);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.options().contains(socketOption)) {
            throw new IllegalArgumentException("Invalid option name");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (socketOption == StandardSocketOption.IP_TOS) {
                if (this.family == StandardProtocolFamily.INET) {
                    return (T)Net.getSocketOption(this.fd, this.family, socketOption);
                }
                return (T)Integer.valueOf(0);
            }
            if (socketOption == StandardSocketOption.IP_MULTICAST_TTL || socketOption == StandardSocketOption.IP_MULTICAST_LOOP) {
                return (T)Net.getSocketOption(this.fd, this.family, socketOption);
            }
            if (socketOption == StandardSocketOption.IP_MULTICAST_IF) {
                if (this.family == StandardProtocolFamily.INET) {
                    int n = Net.getInterface4(this.fd);
                    if (n == 0) {
                        return null;
                    }
                    InetAddress inetAddress = Net.inet4FromInt(n);
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
                    if (networkInterface == null) {
                        throw new IOException("Unable to map address to interface");
                    }
                    return (T)networkInterface;
                }
                int n = Net.getInterface6(this.fd);
                if (n == 0) {
                    return null;
                }
                NetworkInterface networkInterface = NetworkInterface.getByIndex(n);
                if (networkInterface == null) {
                    throw new IOException("Unable to map index to interface");
                }
                return (T)networkInterface;
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
        }
    }

    @Override
    public final Set<SocketOption<?>> options() {
        return LazyInitialization.defaultOptions;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            SocketAddress socketAddress;
            ByteBuffer byteBuffer2;
            int n;
            block30: {
                SocketAddress socketAddress2;
                block29: {
                    SocketAddress socketAddress3;
                    block27: {
                        block28: {
                            this.ensureOpen();
                            if (this.localAddress() == null) {
                                return null;
                            }
                            n = 0;
                            byteBuffer2 = null;
                            try {
                                this.begin();
                                if (!this.isOpen()) {
                                    socketAddress3 = null;
                                    Object var9_7 = null;
                                    if (byteBuffer2 == null) break block27;
                                    break block28;
                                }
                                SecurityManager securityManager = System.getSecurityManager();
                                this.readerThread = NativeThread.current();
                                if (this.isConnected() || securityManager == null) {
                                    while ((n = this.receive(this.fd, byteBuffer)) == -3 && this.isOpen()) {
                                    }
                                    if (n == -2) {
                                        socketAddress2 = null;
                                        break block29;
                                    }
                                } else {
                                    byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
                                    while (true) {
                                        if ((n = this.receive(this.fd, byteBuffer2)) == -3 && this.isOpen()) {
                                            continue;
                                        }
                                        if (n == -2) {
                                            socketAddress = null;
                                            Object var9_9 = null;
                                            if (byteBuffer2 != null) {
                                                Util.releaseTemporaryDirectBuffer(byteBuffer2);
                                            }
                                            this.readerThread = 0L;
                                            this.end(n > 0 || n == -2);
                                            assert (IOStatus.check(n));
                                            return socketAddress;
                                        }
                                        socketAddress = (InetSocketAddress)this.sender;
                                        try {
                                            securityManager.checkAccept(((InetSocketAddress)socketAddress).getAddress().getHostAddress(), ((InetSocketAddress)socketAddress).getPort());
                                        }
                                        catch (SecurityException securityException) {
                                            byteBuffer2.clear();
                                            n = 0;
                                            continue;
                                        }
                                        break;
                                    }
                                    byteBuffer2.flip();
                                    byteBuffer.put(byteBuffer2);
                                }
                                socketAddress = this.sender;
                                break block30;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                if (byteBuffer2 != null) {
                                    Util.releaseTemporaryDirectBuffer(byteBuffer2);
                                }
                                this.readerThread = 0L;
                                this.end(n > 0 || n == -2);
                                assert (IOStatus.check(n));
                                throw throwable;
                            }
                        }
                        Util.releaseTemporaryDirectBuffer(byteBuffer2);
                    }
                    this.readerThread = 0L;
                    this.end(n > 0 || n == -2);
                    assert (IOStatus.check(n));
                    return socketAddress3;
                }
                Object var9_8 = null;
                if (byteBuffer2 != null) {
                    Util.releaseTemporaryDirectBuffer(byteBuffer2);
                }
                this.readerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return socketAddress2;
            }
            Object var9_10 = null;
            if (byteBuffer2 != null) {
                Util.releaseTemporaryDirectBuffer(byteBuffer2);
            }
            this.readerThread = 0L;
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
            return socketAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        assert (n3 <= n4);
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (byteBuffer instanceof DirectBuffer && n2 > 0) {
            return this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer, n2, n3);
        }
        int n6 = Math.max(n2, 1);
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
            int n7 = this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer2, n6, 0);
            byteBuffer2.flip();
            if (n7 > 0 && n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            n = n7;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private int receiveIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, int n2) throws IOException {
        int n3 = this.receive0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, this.isConnected());
        if (n3 > 0) {
            byteBuffer.position(n2 + n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int n2;
            block26: {
                boolean bl;
                int n3;
                block25: {
                    Object object2;
                    this.ensureOpen();
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    if (inetAddress == null) {
                        throw new IOException("Target address not resolved");
                    }
                    Object object3 = this.stateLock;
                    synchronized (object3) {
                        if (!this.isConnected()) {
                            if (socketAddress == null) {
                                throw new NullPointerException();
                            }
                            object2 = System.getSecurityManager();
                            if (object2 != null) {
                                if (inetAddress.isMulticastAddress()) {
                                    ((SecurityManager)object2).checkMulticast(inetSocketAddress.getAddress());
                                } else {
                                    ((SecurityManager)object2).checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                                }
                            }
                        } else {
                            if (!socketAddress.equals(this.remoteAddress)) {
                                throw new IllegalArgumentException("Connected address not equal to target address");
                            }
                            return this.write(byteBuffer);
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var11_11 = null;
                            this.writerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block25;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n2 = this.send(this.fd, byteBuffer, socketAddress)) == -3 && this.isOpen()) {
                        }
                        object2 = this.stateLock;
                        synchronized (object2) {
                            if (this.isOpen() && this.localAddress == null) {
                                this.localAddress = Net.localAddress(this.fd);
                            }
                        }
                        n = IOStatus.normalize(n2);
                        break block26;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        this.writerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var11_12 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n;
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fileDescriptor, byteBuffer, socketAddress);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n2);
            int n5 = this.sendFromNativeBuffer(fileDescriptor, byteBuffer2, socketAddress);
            if (n5 > 0) {
                byteBuffer.position(n2 + n5);
            }
            n = n5;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private int sendFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        boolean bl = this.family != StandardProtocolFamily.INET;
        int n4 = this.send0(bl, fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, socketAddress);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n;
            int n2;
            block15: {
                boolean bl;
                int n3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_7 = null;
                            this.readerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.readerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var6_8 = null;
            this.readerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            long l;
            long l2;
            block15: {
                boolean bl;
                long l3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    l2 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var8_7 = null;
                            this.readerThread = 0L;
                            bl = l2 > 0L || l2 == -2L;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((l2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.readerThread = 0L;
                        this.end(l2 > 0L || l2 == -2L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var8_8 = null;
            this.readerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int n2;
            block15: {
                boolean bl;
                int n3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_7 = null;
                            this.writerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.writerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var6_8 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            long l;
            long l2;
            block15: {
                boolean bl;
                long l3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    l2 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var8_7 = null;
                            this.writerThread = 0L;
                            bl = l2 > 0L || l2 == -2L;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((l2 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.writerThread = 0L;
                        this.end(l2 > 0L || l2 == -2L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var8_8 = null;
            this.writerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(byteBufferArray, n, n2));
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    Object object4;
                    InetSocketAddress inetSocketAddress;
                    this.ensureOpen();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    if (socketAddress == null) {
                        inetSocketAddress = new InetSocketAddress(0);
                    } else {
                        inetSocketAddress = Net.checkAddress(socketAddress);
                        if (this.family == StandardProtocolFamily.INET && !((object4 = inetSocketAddress.getAddress()) instanceof Inet4Address)) {
                            throw new UnsupportedAddressTypeException();
                        }
                    }
                    object4 = System.getSecurityManager();
                    if (object4 != null) {
                        ((SecurityManager)object4).checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.family, this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != 0) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        boolean bl = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    if ((n = Net.connect(this.family, this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort())) <= 0) {
                        throw new Error();
                    }
                    this.state = 1;
                    this.remoteAddress = socketAddress;
                    this.sender = inetSocketAddress;
                    this.cachedSenderInetAddress = inetSocketAddress.getAddress();
                    this.cachedSenderPort = inetSocketAddress.getPort();
                    if (this.localAddress == null) {
                        this.localAddress = Net.localAddress(this.fd);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)this.remoteAddress;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    DatagramChannelImpl.disconnect0(this.fd);
                    this.remoteAddress = null;
                    this.state = 0;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MembershipKey innerJoin(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) throws IOException {
        SecurityManager securityManager;
        if (!inetAddress.isMulticastAddress()) {
            throw new IllegalArgumentException("Group not a multicast address");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            if (this.family == StandardProtocolFamily.INET) {
                throw new IllegalArgumentException("Group is not IPv4 address");
            }
            if (!(inetAddress instanceof Inet6Address)) {
                throw new IllegalArgumentException("Address type not supported");
            }
        }
        if (inetAddress2 != null) {
            if (inetAddress2.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (inetAddress2.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (inetAddress2.getClass() != inetAddress.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkMulticast(inetAddress);
        }
        Object object = this.stateLock;
        synchronized (object) {
            MembershipKey membershipKey;
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.registry == null) {
                this.registry = new MembershipRegistry();
            } else {
                membershipKey = this.registry.checkMembership(inetAddress, networkInterface, inetAddress2);
                if (membershipKey != null) {
                    return membershipKey;
                }
            }
            if (this.family == StandardProtocolFamily.INET6) {
                byte[] byArray;
                int n = networkInterface.getIndex();
                if (n == -1) {
                    throw new IOException("Network interface cannot be identified");
                }
                byte[] byArray2 = Net.inet6AsByteArray(inetAddress);
                int n2 = Net.join6(this.fd, byArray2, n, byArray = inetAddress2 == null ? null : Net.inet6AsByteArray(inetAddress2));
                if (n2 == -2) {
                    throw new UnsupportedOperationException();
                }
                membershipKey = new MembershipKeyImpl.Type6(this, inetAddress, networkInterface, inetAddress2, byArray2, n, byArray);
            } else {
                int n;
                int n3;
                Inet4Address inet4Address = Net.anyInet4Address(networkInterface);
                if (inet4Address == null) {
                    throw new IOException("Network interface not configured for IPv4");
                }
                int n4 = Net.inet4AsInt(inetAddress);
                int n5 = Net.join4(this.fd, n4, n3 = Net.inet4AsInt(inet4Address), n = inetAddress2 == null ? 0 : Net.inet4AsInt(inetAddress2));
                if (n5 == -2) {
                    throw new UnsupportedOperationException();
                }
                membershipKey = new MembershipKeyImpl.Type4(this, inetAddress, networkInterface, inetAddress2, n4, n3, n);
            }
            this.registry.add((MembershipKeyImpl)membershipKey);
            return membershipKey;
        }
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        return this.innerJoin(inetAddress, networkInterface, null);
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) throws IOException {
        if (inetAddress2 == null) {
            throw new NullPointerException("source address is null");
        }
        return this.innerJoin(inetAddress, networkInterface, inetAddress2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drop(MembershipKeyImpl membershipKeyImpl) throws IOException {
        assert (membershipKeyImpl.getChannel() == this);
        Object object = this.stateLock;
        synchronized (object) {
            if (!membershipKeyImpl.isValid()) {
                return;
            }
            if (this.family == StandardProtocolFamily.INET6) {
                MembershipKeyImpl.Type6 type6 = (MembershipKeyImpl.Type6)membershipKeyImpl;
                Net.drop6(this.fd, type6.group(), type6.index(), type6.source());
            } else {
                MembershipKeyImpl.Type4 type4 = (MembershipKeyImpl.Type4)membershipKeyImpl;
                Net.drop4(this.fd, type4.group(), type4.interfaceAddress(), type4.source());
            }
            membershipKeyImpl.invalidate();
            this.registry.remove(membershipKeyImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void block(MembershipKeyImpl membershipKeyImpl, InetAddress inetAddress) throws IOException {
        assert (membershipKeyImpl.getChannel() == this);
        assert (membershipKeyImpl.getSourceAddress() == null);
        Object object = this.stateLock;
        synchronized (object) {
            int n;
            if (!membershipKeyImpl.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            if (inetAddress.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (inetAddress.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (inetAddress.getClass() != membershipKeyImpl.getGroup().getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            if (this.family == StandardProtocolFamily.INET6) {
                MembershipKeyImpl.Type6 type6 = (MembershipKeyImpl.Type6)membershipKeyImpl;
                n = Net.block6(this.fd, type6.group(), type6.index(), Net.inet6AsByteArray(inetAddress));
            } else {
                MembershipKeyImpl.Type4 type4 = (MembershipKeyImpl.Type4)membershipKeyImpl;
                n = Net.block4(this.fd, type4.group(), type4.interfaceAddress(), Net.inet4AsInt(inetAddress));
            }
            if (n == -2) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblock(MembershipKeyImpl membershipKeyImpl, InetAddress inetAddress) throws IOException {
        assert (membershipKeyImpl.getChannel() == this);
        assert (membershipKeyImpl.getSourceAddress() == null);
        Object object = this.stateLock;
        synchronized (object) {
            if (!membershipKeyImpl.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            if (this.family == StandardProtocolFamily.INET6) {
                MembershipKeyImpl.Type6 type6 = (MembershipKeyImpl.Type6)membershipKeyImpl;
                Net.unblock6(this.fd, type6.group(), type6.index(), Net.inet6AsByteArray(inetAddress));
            } else {
                MembershipKeyImpl.Type4 type4 = (MembershipKeyImpl.Type4)membershipKeyImpl;
                Net.unblock4(this.fd, type4.group(), type4.interfaceAddress(), Net.inet4AsInt(inetAddress));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            long l;
            nd.preClose(this.fd);
            if (this.registry != null) {
                this.registry.invalidateAll();
            }
            if ((l = this.readerThread) != 0L) {
                NativeThread.signal(l);
            }
            if ((l = this.writerThread) != 0L) {
                NativeThread.signal(l);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            if (this.state == -1) {
                this.state = 2;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 2;
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            return false;
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 1) != 0) {
            n5 |= 1;
        }
        if ((n & 4) != 0 && (n3 & 4) != 0) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    private native int send0(boolean var1, FileDescriptor var2, long var3, int var5, SocketAddress var6) throws IOException;

    static {
        Util.load();
        DatagramChannelImpl.initIDs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyInitialization {
        static final Set<SocketOption<?>> defaultOptions = LazyInitialization.defaultOptions();

        private LazyInitialization() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Object>> hashSet = new HashSet<SocketOption<Object>>(8);
            hashSet.add(StandardSocketOption.SO_SNDBUF);
            hashSet.add(StandardSocketOption.SO_RCVBUF);
            hashSet.add(StandardSocketOption.SO_REUSEADDR);
            hashSet.add(StandardSocketOption.SO_BROADCAST);
            hashSet.add(StandardSocketOption.IP_TOS);
            hashSet.add(StandardSocketOption.IP_MULTICAST_IF);
            hashSet.add(StandardSocketOption.IP_MULTICAST_TTL);
            hashSet.add(StandardSocketOption.IP_MULTICAST_LOOP);
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

