/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.FontManager;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.Type1Font;

public final class Type1GlyphMapper
extends CharToGlyphMapper {
    Type1Font font;
    FontScaler scaler;

    public Type1GlyphMapper(Type1Font type1Font) {
        this.font = type1Font;
        this.initMapper();
    }

    private void initMapper() {
        this.scaler = this.font.getScaler();
        try {
            this.missingGlyph = this.scaler.getMissingGlyphCode();
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontManager.getNullScaler();
            try {
                this.missingGlyph = this.scaler.getMissingGlyphCode();
            }
            catch (FontScalerException fontScalerException2) {
                this.missingGlyph = 0;
            }
        }
    }

    public int getNumGlyphs() {
        try {
            return this.scaler.getNumGlyphs();
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontManager.getNullScaler();
            return this.getNumGlyphs();
        }
    }

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public boolean canDisplay(char c) {
        try {
            return this.scaler.getGlyphCode(c) != this.missingGlyph;
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontManager.getNullScaler();
            return this.canDisplay(c);
        }
    }

    public int charToGlyph(char c) {
        try {
            return this.scaler.getGlyphCode(c);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontManager.getNullScaler();
            return this.charToGlyph(c);
        }
    }

    public int charToGlyph(int n) {
        if (n < 0 || n > 65535) {
            return this.missingGlyph;
        }
        try {
            return this.scaler.getGlyphCode((char)n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontManager.getNullScaler();
            return this.charToGlyph(n);
        }
    }

    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = this.charToGlyph(n2);
            if (n2 < 65536) continue;
            ++i;
        }
    }

    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.charToGlyph(nArray[i]);
        }
    }

    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = this.charToGlyph(n2);
            if (n2 < 768) continue;
            if (FontManager.isComplexCharCode(n2)) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }
}

