/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Deadlock {
    private CyclicBarrier barrier = new CyclicBarrier(6);

    public static void main(String[] stringArray) {
        Deadlock deadlock = new Deadlock();
        ThreadMonitor threadMonitor = new ThreadMonitor();
        boolean bl = false;
        while (!bl) {
            bl = threadMonitor.findDeadlock();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                System.exit(1);
            }
        }
        System.out.println("\nPress <Enter> to exit this Deadlock program.\n");
        Deadlock.waitForEnterPressed();
    }

    public Deadlock() {
        DeadlockThread[] deadlockThreadArray = new DeadlockThread[6];
        Monitor monitor = new Monitor("a");
        Monitor monitor2 = new Monitor("b");
        Monitor monitor3 = new Monitor("c");
        deadlockThreadArray[0] = new DeadlockThread("MThread-1", monitor, monitor2);
        deadlockThreadArray[1] = new DeadlockThread("MThread-2", monitor2, monitor3);
        deadlockThreadArray[2] = new DeadlockThread("MThread-3", monitor3, monitor);
        ReentrantLock reentrantLock = new ReentrantLock();
        ReentrantLock reentrantLock2 = new ReentrantLock();
        ReentrantLock reentrantLock3 = new ReentrantLock();
        deadlockThreadArray[3] = new DeadlockThread("SThread-4", reentrantLock, reentrantLock2);
        deadlockThreadArray[4] = new DeadlockThread("SThread-5", reentrantLock2, reentrantLock3);
        deadlockThreadArray[5] = new DeadlockThread("SThread-6", reentrantLock3, reentrantLock);
        for (int i = 0; i < 6; ++i) {
            deadlockThreadArray[i].setDaemon(true);
            deadlockThreadArray[i].start();
        }
    }

    private static void waitForEnterPressed() {
        try {
            boolean bl = false;
            while (!bl) {
                char c = (char)System.in.read();
                if (c >= '\u0000' && c != '\n') continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    class Monitor {
        String name;

        Monitor(String string) {
            this.name = string;
        }
    }

    class DeadlockThread
    extends Thread {
        private Lock lock1;
        private Lock lock2;
        private Monitor mon1;
        private Monitor mon2;
        private boolean useSync;

        DeadlockThread(String string, Lock lock, Lock lock2) {
            super(string);
            this.lock1 = null;
            this.lock2 = null;
            this.mon1 = null;
            this.mon2 = null;
            this.lock1 = lock;
            this.lock2 = lock2;
            this.useSync = true;
        }

        DeadlockThread(String string, Monitor monitor, Monitor monitor2) {
            super(string);
            this.lock1 = null;
            this.lock2 = null;
            this.mon1 = null;
            this.mon2 = null;
            this.mon1 = monitor;
            this.mon2 = monitor2;
            this.useSync = false;
        }

        public void run() {
            if (this.useSync) {
                this.syncLock();
            } else {
                this.monitorLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncLock() {
            this.lock1.lock();
            try {
                try {
                    Deadlock.this.barrier.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    System.exit(1);
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    brokenBarrierException.printStackTrace();
                    System.exit(1);
                }
                this.goSyncDeadlock();
            }
            finally {
                this.lock1.unlock();
            }
        }

        private void goSyncDeadlock() {
            try {
                Deadlock.this.barrier.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                System.exit(1);
            }
            catch (BrokenBarrierException brokenBarrierException) {
                brokenBarrierException.printStackTrace();
                System.exit(1);
            }
            this.lock2.lock();
            throw new RuntimeException("should not reach here.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void monitorLock() {
            Monitor monitor = this.mon1;
            synchronized (monitor) {
                try {
                    Deadlock.this.barrier.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    System.exit(1);
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    brokenBarrierException.printStackTrace();
                    System.exit(1);
                }
                this.goMonitorDeadlock();
            }
        }

        private void goMonitorDeadlock() {
            try {
                Deadlock.this.barrier.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                System.exit(1);
            }
            catch (BrokenBarrierException brokenBarrierException) {
                brokenBarrierException.printStackTrace();
                System.exit(1);
            }
            Monitor monitor = this.mon2;
            synchronized (monitor) {
                throw new RuntimeException(this.getName() + " should not reach here.");
            }
        }
    }
}

