/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JType;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.reader.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    private static final Comparator<JType> typeComparator = new Comparator<JType>(){

        @Override
        public int compare(JType jType, JType jType2) {
            return jType.fullName().compareTo(jType2.fullName());
        }
    };

    public static JType getCommonBaseType(JCodeModel jCodeModel, Collection<? extends JType> collection) {
        return TypeUtil.getCommonBaseType(jCodeModel, collection.toArray(new JType[collection.size()]));
    }

    public static JType getCommonBaseType(JCodeModel jCodeModel, JType ... jTypeArray) {
        Object object;
        TreeSet<JType> treeSet = new TreeSet<JType>(typeComparator);
        for (JType jType2 : jTypeArray) {
            treeSet.add(jType2);
        }
        if (treeSet.size() == 1) {
            return (JType)treeSet.iterator().next();
        }
        assert (!treeSet.isEmpty());
        treeSet.remove(jCodeModel.NULL);
        Object object3 = null;
        for (JType jType : treeSet) {
            JType jType2;
            jType2 = jType.boxify();
            if (object3 == null) {
                object3 = TypeUtil.getAssignableTypes((JClass)jType2);
                continue;
            }
            object3.retainAll(TypeUtil.getAssignableTypes((JClass)jType2));
        }
        object3.add(jCodeModel.ref(Object.class));
        JClass[] jClassArray = object3.toArray(new JClass[object3.size()]);
        object3.clear();
        for (int i = 0; i < jClassArray.length; ++i) {
            int n;
            for (n = 0; !(n >= jClassArray.length || i != n && jClassArray[i].isAssignableFrom(jClassArray[n])); ++n) {
            }
            if (n != jClassArray.length) continue;
            object3.add(jClassArray[i]);
        }
        assert (!object3.isEmpty());
        JClass jClass = TypeUtil.pickOne((Set<JClass>)object3);
        if (jClass.isParameterized()) {
            return jClass;
        }
        ArrayList<List<JClass>> arrayList = new ArrayList<List<JClass>>(treeSet.size());
        int n = -1;
        for (JType object22 : treeSet) {
            JClass i = object22.boxify();
            object = i.getBaseClass(jClass);
            if (object.equals(jClass)) {
                return jClass;
            }
            assert (((JClass)object).isParameterized());
            List<JClass> list = ((JClass)object).getTypeParameters();
            arrayList.add(list);
            assert (n == -1 || n == list.size());
            n = list.size();
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList(arrayList.size());
        for (int i = 0; i < n; ++i) {
            int n2;
            arrayList3.clear();
            for (List bl : arrayList) {
                arrayList3.add(bl.get(i));
            }
            object = (JClass)TypeUtil.getCommonBaseType(jCodeModel, arrayList3);
            boolean bl = true;
            for (JClass jClass2 : arrayList3) {
                n2 &= jClass2.equals(object);
            }
            if (n2 == 0) {
                object = ((JClass)object).wildcard();
            }
            arrayList2.add(object);
        }
        return jClass.narrow(arrayList2);
    }

    private static JClass pickOne(Set<JClass> set) {
        for (JClass jClass : set) {
            if (!(jClass instanceof JDefinedClass)) continue;
            return jClass;
        }
        return set.iterator().next();
    }

    private static Set<JClass> getAssignableTypes(JClass jClass) {
        TreeSet<JType> treeSet = new TreeSet<JType>(typeComparator);
        TypeUtil.getAssignableTypes(jClass, treeSet);
        return treeSet;
    }

    private static void getAssignableTypes(JClass jClass, Set<JClass> set) {
        if (!set.add(jClass)) {
            return;
        }
        set.add(jClass.erasure());
        JClass jClass2 = jClass._extends();
        if (jClass2 != null) {
            TypeUtil.getAssignableTypes(jClass2, set);
        }
        Iterator<JClass> iterator = jClass._implements();
        while (iterator.hasNext()) {
            TypeUtil.getAssignableTypes(iterator.next(), set);
        }
    }

    public static JType getType(JCodeModel jCodeModel, String string, ErrorReceiver errorReceiver, Locator locator) {
        try {
            return jCodeModel.parseType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            errorReceiver.warning(new SAXParseException(Messages.ERR_CLASS_NOT_FOUND.format(string), locator));
            return jCodeModel.directClass(string);
        }
    }
}

