/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.wsdl;

import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.xjc.api.ErrorListener;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
implements ErrorListener {
    private LocalizableMessageFactory messageFactory;
    private ProcessorEnvironment env;
    private boolean printStackTrace;
    private boolean hasError;
    private Exception e;

    public ConsoleErrorReporter(ProcessorEnvironment processorEnvironment, boolean bl) {
        this.env = processorEnvironment;
        this.printStackTrace = bl;
        this.messageFactory = new LocalizableMessageFactory("com.sun.tools.internal.ws.resources.model");
    }

    public boolean hasError() {
        return this.hasError;
    }

    Exception getException() {
        return this.e;
    }

    public void error(SAXParseException sAXParseException) {
        this.hasError = true;
        this.e = sAXParseException;
        if (this.printStackTrace) {
            sAXParseException.printStackTrace();
        }
        this.env.error(this.messageFactory.getMessage("model.saxparser.exception", new Object[]{sAXParseException.getMessage(), this.getLocationString(sAXParseException)}));
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.hasError = true;
        this.e = sAXParseException;
        if (this.printStackTrace) {
            sAXParseException.printStackTrace();
        }
        this.env.error(this.messageFactory.getMessage("model.saxparser.exception", new Object[]{sAXParseException.getMessage(), this.getLocationString(sAXParseException)}));
    }

    public void warning(SAXParseException sAXParseException) {
        this.env.warn(this.messageFactory.getMessage("model.saxparser.exception", new Object[]{sAXParseException.getMessage(), this.getLocationString(sAXParseException)}));
    }

    public void info(SAXParseException sAXParseException) {
        this.env.info(this.messageFactory.getMessage("model.saxparser.exception", new Object[]{sAXParseException.getMessage(), this.getLocationString(sAXParseException)}));
    }

    protected final String getLocationString(SAXParseException sAXParseException) {
        if (sAXParseException.getLineNumber() != -1 || sAXParseException.getSystemId() != null) {
            int n = sAXParseException.getLineNumber();
            return this.format("ConsoleErrorReporter.LineXOfY", n == -1 ? "?" : Integer.toString(n), this.getShortName(sAXParseException.getSystemId()));
        }
        return this.format("ConsoleErrorReporter.UnknownLocation", new Object[0]);
    }

    private String getShortName(String string) {
        if (string == null) {
            return this.format("ConsoleErrorReporter.UnknownLocation", new Object[0]);
        }
        return string;
    }

    private String format(String string, Object ... objectArray) {
        String string2 = ResourceBundle.getBundle("com.sun.tools.internal.ws.resources.model").getString(string);
        return MessageFormat.format(string2, objectArray);
    }
}

