/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JTypeVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JNarrowedClass
extends JClass {
    final JClass basis;
    private final List<JClass> args;

    JNarrowedClass(JClass jClass, JClass jClass2) {
        this(jClass, Collections.singletonList(jClass2));
    }

    JNarrowedClass(JClass jClass, List<JClass> list) {
        super(jClass.owner());
        this.basis = jClass;
        assert (!(jClass instanceof JNarrowedClass));
        this.args = list;
    }

    @Override
    public JClass narrow(JClass jClass) {
        ArrayList<JClass> arrayList = new ArrayList<JClass>(this.args);
        arrayList.add(jClass);
        return new JNarrowedClass(this.basis, arrayList);
    }

    @Override
    public JClass narrow(JClass ... jClassArray) {
        ArrayList<JClass> arrayList = new ArrayList<JClass>(this.args);
        for (JClass jClass : jClassArray) {
            arrayList.add(jClass);
        }
        return new JNarrowedClass(this.basis, arrayList);
    }

    @Override
    public String name() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.basis.name());
        stringBuffer.append('<');
        boolean bl = true;
        for (JClass jClass : this.args) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(jClass.name());
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    @Override
    public String fullName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.basis.fullName());
        stringBuilder.append('<');
        boolean bl = true;
        for (JClass jClass : this.args) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(jClass.fullName());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public String binaryName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.basis.binaryName());
        stringBuilder.append('<');
        boolean bl = true;
        for (JClass jClass : this.args) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(jClass.binaryName());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public void generate(JFormatter jFormatter) {
        jFormatter.t(this.basis).p('<').g(this.args).p('\uffff');
    }

    @Override
    void printLink(JFormatter jFormatter) {
        this.basis.printLink(jFormatter);
        jFormatter.p("{@code <}");
        boolean bl = true;
        for (JClass jClass : this.args) {
            if (bl) {
                bl = false;
            } else {
                jFormatter.p(',');
            }
            jClass.printLink(jFormatter);
        }
        jFormatter.p("{@code >}");
    }

    @Override
    public JPackage _package() {
        return this.basis._package();
    }

    @Override
    public JClass _extends() {
        JClass jClass = this.basis._extends();
        if (jClass == null) {
            return jClass;
        }
        return jClass.substituteParams(this.basis.typeParams(), this.args);
    }

    @Override
    public Iterator<JClass> _implements() {
        return new Iterator<JClass>(){
            private final Iterator<JClass> core;
            {
                this.core = JNarrowedClass.this.basis._implements();
            }

            @Override
            public void remove() {
                this.core.remove();
            }

            @Override
            public JClass next() {
                return this.core.next().substituteParams(JNarrowedClass.this.basis.typeParams(), JNarrowedClass.this.args);
            }

            @Override
            public boolean hasNext() {
                return this.core.hasNext();
            }
        };
    }

    @Override
    public JClass erasure() {
        return this.basis;
    }

    @Override
    public boolean isInterface() {
        return this.basis.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this.basis.isAbstract();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JNarrowedClass)) {
            return false;
        }
        return this.fullName().equals(((JClass)object).fullName());
    }

    public int hashCode() {
        return this.fullName().hashCode();
    }

    @Override
    protected JClass substituteParams(JTypeVar[] jTypeVarArray, List<JClass> list) {
        JClass jClass = this.basis.substituteParams(jTypeVarArray, list);
        boolean bl = jClass != this.basis;
        ArrayList<JClass> arrayList = new ArrayList<JClass>(this.args.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            JClass jClass2 = this.args.get(i).substituteParams(jTypeVarArray, list);
            arrayList.set(i, jClass2);
            bl |= jClass2 != this.args.get(i);
        }
        if (bl) {
            return new JNarrowedClass(jClass, arrayList);
        }
        return this;
    }

    @Override
    public List<JClass> getTypeParameters() {
        return this.args;
    }
}

