/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE_PROP = "ocsp.enable";
    public static final String OCSP_URL_PROP = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final int[] OCSP_NONCE_DATA = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2};
    private static final ObjectIdentifier OCSP_NONCE_OID = ObjectIdentifier.newInternal(OCSP_NONCE_DATA);
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pKIXParameters;
        List<? extends Certificate> list = this.cp.getCertificates();
        this.certs = list.toArray(new X509Certificate[list.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length + 1;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        --this.remainingCerts;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6 = null;
            boolean bl = false;
            X500Principal x500Principal = null;
            X500Principal x500Principal2 = null;
            BigInteger bigInteger = null;
            boolean bl2 = true;
            X509CertImpl x509CertImpl = null;
            X509CertImpl x509CertImpl2 = X509CertImpl.toImpl((X509Certificate)certificate);
            String[] stringArray = OCSPChecker.getOCSPProperties();
            URL uRL = OCSPChecker.getOCSPServerURL(x509CertImpl2, stringArray);
            if (stringArray[1] != null) {
                x500Principal = new X500Principal(stringArray[1]);
            } else if (stringArray[2] != null && stringArray[3] != null) {
                x500Principal2 = new X500Principal(stringArray[2]);
                object5 = OCSPChecker.stripOutSeparators(stringArray[3]);
                bigInteger = new BigInteger((String)object5, 16);
            } else if (stringArray[2] != null || stringArray[3] != null) {
                throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
            }
            if (x500Principal != null || x500Principal2 != null) {
                bl = true;
            }
            if (this.remainingCerts < this.certs.length) {
                x509CertImpl = X509CertImpl.toImpl(this.certs[this.remainingCerts]);
                bl2 = false;
                if (!bl) {
                    object6 = this.certs[this.remainingCerts];
                    if (DEBUG != null) {
                        DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                    }
                }
            }
            if (bl2 || bl) {
                Object object7;
                if (DEBUG != null && bl) {
                    DEBUG.println("Searching trust anchors for responder's certificate");
                }
                if (!(object5 = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                    throw new CertPathValidatorException("Must specify at least one trust anchor");
                }
                object4 = x509CertImpl2.getIssuerX500Principal();
                while (object5.hasNext() && (bl2 || bl)) {
                    object3 = (TrustAnchor)object5.next();
                    object2 = ((TrustAnchor)object3).getTrustedCert();
                    object7 = ((X509Certificate)object2).getSubjectX500Principal();
                    if (bl2 && ((X500Principal)object4).equals(object7)) {
                        x509CertImpl = X509CertImpl.toImpl((X509Certificate)object2);
                        bl2 = false;
                        if (!bl && object6 == null) {
                            object6 = object2;
                            if (DEBUG != null) {
                                DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                            }
                        }
                    }
                    if (!bl || (x500Principal == null || !x500Principal.equals(object7)) && (x500Principal2 == null || bigInteger == null || !x500Principal2.equals(((X509Certificate)object2).getIssuerX500Principal()) || !bigInteger.equals(((X509Certificate)object2).getSerialNumber()))) continue;
                    object6 = object2;
                    bl = false;
                }
                if (x509CertImpl == null) {
                    throw new CertPathValidatorException("No trusted certificate for " + x509CertImpl2.getIssuerDN());
                }
                if (bl) {
                    if (DEBUG != null) {
                        DEBUG.println("Searching cert stores for responder's certificate");
                    }
                    object3 = null;
                    if (x500Principal != null) {
                        object3 = new X509CertSelector();
                        ((X509CertSelector)object3).setSubject(x500Principal.getName());
                    } else if (x500Principal2 != null && bigInteger != null) {
                        object3 = new X509CertSelector();
                        ((X509CertSelector)object3).setIssuer(x500Principal2.getName());
                        ((X509CertSelector)object3).setSerialNumber(bigInteger);
                    }
                    if (object3 != null) {
                        object2 = this.pkixParams.getCertStores();
                        object7 = object2.iterator();
                        while (object7.hasNext()) {
                            object = (CertStore)object7.next();
                            Iterator<? extends Certificate> iterator = ((CertStore)object).getCertificates((CertSelector)object3).iterator();
                            if (!iterator.hasNext()) continue;
                            object6 = (X509Certificate)iterator.next();
                            bl = false;
                            break;
                        }
                    }
                }
            }
            if (bl) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
            object5 = new OCSPRequest(x509CertImpl2, x509CertImpl);
            object4 = (HttpURLConnection)uRL.openConnection();
            if (DEBUG != null) {
                DEBUG.println("connecting to OCSP service at: " + uRL);
            }
            ((URLConnection)object4).setDoOutput(true);
            ((URLConnection)object4).setDoInput(true);
            ((HttpURLConnection)object4).setRequestMethod("POST");
            ((URLConnection)object4).setRequestProperty("Content-type", "application/ocsp-request");
            object3 = ((OCSPRequest)object5).encodeBytes();
            object2 = ((OCSPRequest)object5).getCertId();
            ((URLConnection)object4).setRequestProperty("Content-length", String.valueOf(((Object)object3).length));
            outputStream = ((URLConnection)object4).getOutputStream();
            outputStream.write((byte[])object3);
            outputStream.flush();
            if (DEBUG != null && ((HttpURLConnection)object4).getResponseCode() != 200) {
                DEBUG.println("Received HTTP error: " + ((HttpURLConnection)object4).getResponseCode() + " - " + ((HttpURLConnection)object4).getResponseMessage());
            }
            inputStream = ((URLConnection)object4).getInputStream();
            int n = ((URLConnection)object4).getContentLength();
            if (n == -1) {
                n = Integer.MAX_VALUE;
            }
            object = new byte[n];
            int n2 = 0;
            for (int i = 0; n2 != -1 && i < n; i += n2) {
                n2 = inputStream.read((byte[])object, i, ((Object)object).length - i);
            }
            OCSPResponse oCSPResponse = new OCSPResponse((byte[])object, this.pkixParams, (X509Certificate)object6);
            if (!((CertId)object2).equals(oCSPResponse.getCertId())) {
                throw new CertPathValidatorException("Certificate in the OCSP response does not match the certificate supplied in the OCSP request.");
            }
            SerialNumber serialNumber = x509CertImpl2.getSerialNumberObject();
            int n3 = oCSPResponse.getCertStatus(serialNumber);
            if (DEBUG != null) {
                DEBUG.println("Status of certificate (with serial number " + serialNumber.getNumber() + ") is: " + OCSPResponse.certStatusToText(n3));
            }
            if (n3 == 1) {
                CertificateRevokedException certificateRevokedException = new CertificateRevokedException(oCSPResponse.getRevocationTime(), oCSPResponse.getRevocationReason(), ((X509Certificate)object6).getSubjectX500Principal(), oCSPResponse.getSingleExtensions());
                throw new CertPathValidatorException(((Throwable)certificateRevokedException).getMessage(), certificateRevokedException, null, -1, CertPathValidatorException.BasicReason.REVOKED);
            }
            if (n3 == 2) {
                throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
        }
        catch (Exception exception) {
            throw new CertPathValidatorException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException(iOException);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException(iOException);
                }
            }
        }
    }

    private static URL getOCSPServerURL(X509CertImpl x509CertImpl, String[] stringArray) throws CertificateParsingException, CertPathValidatorException {
        if (stringArray[0] != null) {
            try {
                return new URL(stringArray[0]);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CertPathValidatorException(malformedURLException);
            }
        }
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        for (AccessDescription accessDescription : list) {
            GeneralName generalName;
            if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
            try {
                URIName uRIName = (URIName)generalName.getName();
                return new URL(uRIName.getName());
            }
            catch (MalformedURLException malformedURLException) {
                throw new CertPathValidatorException(malformedURLException);
            }
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] stringArray = new String[4];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                stringArray[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                stringArray[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                stringArray[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                stringArray[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return stringArray;
    }

    private static String stripOutSeparators(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (HEX_DIGITS.indexOf(cArray[i]) == -1) continue;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }
}

