/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.reflect.Constructor;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SystemClassLoaderAction
implements PrivilegedExceptionAction<ClassLoader> {
    private ClassLoader parent;

    SystemClassLoaderAction(ClassLoader classLoader) {
        this.parent = classLoader;
    }

    @Override
    public ClassLoader run() throws Exception {
        String string = System.getProperty("java.system.class.loader");
        if (string == null) {
            return this.parent;
        }
        Constructor<?> constructor = Class.forName(string, true, this.parent).getDeclaredConstructor(ClassLoader.class);
        ClassLoader classLoader = (ClassLoader)constructor.newInstance(this.parent);
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }
}

