/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.client.ClientConfigurationException;
import com.sun.xml.internal.ws.client.EndpointIFContext;
import com.sun.xml.internal.ws.client.ServiceContext;
import com.sun.xml.internal.ws.handler.HandlerResolverImpl;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.modeler.RuntimeModeler;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.wsdl.WSDLContext;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceContextBuilder {
    private ServiceContextBuilder() {
    }

    public static ServiceContext build(URL uRL, QName qName, final Class clazz, EntityResolver entityResolver) throws WebServiceException {
        Object object;
        ServiceContext serviceContext = new ServiceContext(clazz, qName, entityResolver);
        if (uRL != null) {
            object = new WSDLContext(uRL, entityResolver);
            if (!((WSDLContext)object).contains(qName)) {
                throw new ClientConfigurationException("service.invalidServiceName", qName, uRL);
            }
            serviceContext.setWsdlContext((WSDLContext)object);
        }
        if ((object = (HandlerChain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            HandlerResolverImpl handlerResolverImpl = new HandlerResolverImpl(serviceContext);
            serviceContext.setHandlerResolver(handlerResolverImpl);
        }
        return serviceContext;
    }

    public static void completeServiceContext(QName qName, ServiceContext serviceContext, Class clazz) {
        if (clazz != null) {
            ServiceContextBuilder.processAnnotations(qName, serviceContext, clazz);
        }
    }

    private static void processAnnotations(QName qName, ServiceContext serviceContext, Class clazz) throws WebServiceException {
        Object object;
        WSDLContext wSDLContext = serviceContext.getWsdlContext();
        EndpointIFContext endpointIFContext = serviceContext.getEndpointIFContext(clazz.getName());
        if (endpointIFContext != null && endpointIFContext.getRuntimeContext() != null) {
            return;
        }
        if (endpointIFContext == null) {
            endpointIFContext = new EndpointIFContext(clazz);
            serviceContext.addEndpointIFContext(endpointIFContext);
        }
        QName qName2 = serviceContext.getServiceName();
        if (qName == null) {
            object = RuntimeModeler.getPortTypeName(clazz);
            qName = wSDLContext.getWsdlDocument().getPortName(serviceContext.getServiceName(), (QName)object);
        }
        if (qName == null) {
            throw new ClientConfigurationException("service.noPortName", clazz.getName(), wSDLContext.getWsdlLocation().toString());
        }
        endpointIFContext.setPortName(qName);
        object = wSDLContext.getBindingID(qName2, qName);
        RuntimeModeler runtimeModeler = new RuntimeModeler(clazz, qName2, (String)object);
        runtimeModeler.setPortName(qName);
        RuntimeModel runtimeModel = runtimeModeler.buildRuntimeModel();
        endpointIFContext.setRuntimeContext(new RuntimeContext(runtimeModel));
    }

    private ArrayList<Class<?>> getSEI(final Class clazz) {
        if (clazz == null) {
            throw new WebServiceException();
        }
        if (!Service.class.isAssignableFrom(clazz)) {
            throw new WebServiceException("service.interface.required" + clazz.getName());
        }
        final ArrayList arrayList = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method[] methodArray;
                for (Method method : methodArray = clazz.getDeclaredMethods()) {
                    method.setAccessible(true);
                    Class<?> clazz2 = method.getReturnType();
                    if (clazz2 == null || clazz2.equals("void")) continue;
                    arrayList.add(clazz2);
                }
                return null;
            }
        });
        return arrayList;
    }
}

