/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model;

import com.sun.tools.internal.ws.processor.config.HandlerChainInfo;
import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.ModelVisitor;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPStyle;
import com.sun.xml.internal.ws.encoding.soap.SOAPVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Port
extends ModelObject {
    private SOAPStyle _style = null;
    private boolean _isWrapped = true;
    private String portGetter;
    private QName _name;
    private List<Operation> _operations = new ArrayList<Operation>();
    private JavaInterface _javaInterface;
    private String _address;
    private String _serviceImplName;
    private Map operationsByName = new HashMap();
    private HandlerChainInfo _clientHandlerChainInfo;
    private HandlerChainInfo _serverHandlerChainInfo;
    private SOAPVersion _soapVersion = SOAPVersion.SOAP_11;

    public Port() {
    }

    public Port(QName qName) {
        this._name = qName;
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName qName) {
        this._name = qName;
    }

    public void addOperation(Operation operation) {
        this._operations.add(operation);
        this.operationsByName.put(operation.getUniqueName(), operation);
    }

    public Operation getOperationByUniqueName(String string) {
        if (this.operationsByName.size() != this._operations.size()) {
            this.initializeOperationsByName();
        }
        return (Operation)this.operationsByName.get(string);
    }

    private void initializeOperationsByName() {
        this.operationsByName = new HashMap();
        if (this._operations != null) {
            for (Operation operation : this._operations) {
                if (operation.getUniqueName() != null && this.operationsByName.containsKey(operation.getUniqueName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.operationsByName.put(operation.getUniqueName(), operation);
            }
        }
    }

    public List<Operation> getOperations() {
        return this._operations;
    }

    public void setOperations(List<Operation> list) {
        this._operations = list;
    }

    public JavaInterface getJavaInterface() {
        return this._javaInterface;
    }

    public void setJavaInterface(JavaInterface javaInterface) {
        this._javaInterface = javaInterface;
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String string) {
        this._address = string;
    }

    public HandlerChainInfo getClientHandlerChainInfo() {
        if (this._clientHandlerChainInfo == null) {
            this._clientHandlerChainInfo = new HandlerChainInfo();
        }
        return this._clientHandlerChainInfo;
    }

    public void setClientHandlerChainInfo(HandlerChainInfo handlerChainInfo) {
        this._clientHandlerChainInfo = handlerChainInfo;
    }

    public HandlerChainInfo getServerHandlerChainInfo() {
        if (this._serverHandlerChainInfo == null) {
            this._serverHandlerChainInfo = new HandlerChainInfo();
        }
        return this._serverHandlerChainInfo;
    }

    public void setServerHandlerChainInfo(HandlerChainInfo handlerChainInfo) {
        this._serverHandlerChainInfo = handlerChainInfo;
    }

    public SOAPVersion getSOAPVersion() {
        return this._soapVersion;
    }

    public void setSOAPVersion(SOAPVersion sOAPVersion) {
        this._soapVersion = sOAPVersion;
    }

    public String getServiceImplName() {
        return this._serviceImplName;
    }

    public void setServiceImplName(String string) {
        this._serviceImplName = string;
    }

    @Override
    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }

    public boolean isProvider() {
        String string;
        JavaInterface javaInterface = this.getJavaInterface();
        return javaInterface != null && (string = javaInterface.getName()).equals(Provider.class.getName());
    }

    public String getPortGetter() {
        return this.portGetter;
    }

    public void setPortGetter(String string) {
        this.portGetter = string;
    }

    public SOAPStyle getStyle() {
        return this._style;
    }

    public void setStyle(SOAPStyle sOAPStyle) {
        this._style = sOAPStyle;
    }

    public boolean isWrapped() {
        return this._isWrapped;
    }

    public void setWrapped(boolean bl) {
        this._isWrapped = bl;
    }
}

