/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.streaming;

import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.util.FastInfosetReflection;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public class SourceReaderFactory {
    static ThreadLocal<DOMStreamReader> domStreamReader = new ThreadLocal();

    public static XMLStreamReader createSourceReader(Source source, boolean bl) {
        return SourceReaderFactory.createSourceReader(source, bl, null);
    }

    public static XMLStreamReader createSourceReader(Source source, boolean bl, String string) {
        try {
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream != null) {
                    if (string != null) {
                        return XMLStreamReaderFactory.createXMLStreamReader(new InputStreamReader(inputStream, string), bl);
                    }
                    return XMLStreamReaderFactory.createXMLStreamReader(inputStream, bl);
                }
                Reader reader = streamSource.getReader();
                if (reader != null) {
                    return XMLStreamReaderFactory.createXMLStreamReader(reader, bl);
                }
                throw new XMLReaderException("sourceReader.invalidSource", source.getClass().getName());
            }
            if (FastInfosetReflection.isFastInfosetSource(source)) {
                return XMLStreamReaderFactory.createFIStreamReader(FastInfosetReflection.FastInfosetSource_getInputStream(source));
            }
            if (source instanceof DOMSource) {
                DOMStreamReader dOMStreamReader = domStreamReader.get();
                if (dOMStreamReader == null) {
                    dOMStreamReader = new DOMStreamReader();
                    domStreamReader.set(dOMStreamReader);
                }
                dOMStreamReader.setCurrentNode(((DOMSource)source).getNode());
                return dOMStreamReader;
            }
            if (source instanceof SAXSource) {
                Transformer transformer = XmlUtil.newTransformer();
                DOMResult dOMResult = new DOMResult();
                transformer.transform(source, dOMResult);
                return SourceReaderFactory.createSourceReader(new DOMSource(dOMResult.getNode()), bl);
            }
            throw new XMLReaderException("sourceReader.invalidSource", source.getClass().getName());
        }
        catch (Exception exception) {
            throw new XMLReaderException(exception);
        }
    }
}

