/* $Id: cmd.h,v 1.1 2009/05/09 23:01:09 imil Exp $ */

/*
 * Copyright (c) 2009 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Emile "iMil" Heitor <imil@NetBSD.org> .
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#define PKG_LLIST_CMD 0
#define PKG_RLIST_CMD 1
#define PKG_INST_CMD 2
#define PKG_UPDT_CMD 3
#define PKG_REMV_CMD 4
#define PKG_UPGRD_CMD 5
#define PKG_FUPGRD_CMD 6
#define PKG_SHFDP_CMD 7
#define PKG_SHRDP_CMD 8
#define PKG_SHDDP_CMD 9
#define PKG_KEEP_CMD 10
#define PKG_UNKEEP_CMD 11
#define PKG_SHKP_CMD 12
#define PKG_SRCH_CMD 13
#define PKG_CLEAN_CMD 14
#define PKG_AUTORM_CMD 15

static struct command {
	const char	*name;
	const char	*shortcut;
	const char	*descr;
	const int	cmdtype;
} cmd[] = {
	{ "list", "ls", "Lists installed packages.",
	  PKG_LLIST_CMD },
	{ "avail", "av", "Lists available packages.",
	  PKG_RLIST_CMD },
	{ "install", "in", "Performs packages installation or upgrade.",
	  PKG_INST_CMD },
	{ "update", "up" , "Creates and populates the initial database.",
	  PKG_UPDT_CMD },
	{ "remove", "rm", "Remove packages and depending packages.",
	  PKG_REMV_CMD },
	{ "upgrade", "ug", "Upgrade main packages to their newer versions.",
	  PKG_UPGRD_CMD },
	{ "full-upgrade", "fug", "Upgrade all packages to their newer versions.",
	  PKG_FUPGRD_CMD },
	{ "show-deps", "sd", "Display direct dependencies.",
	  PKG_SHDDP_CMD },
	{ "show-full-deps", "sfd", "Display dependencies recursively.",
	  PKG_SHFDP_CMD },
	{ "show-rev-deps", "srd", "Display reverse dependencies recursively.",
	  PKG_SHRDP_CMD },
	{ "keep", "ke", "Marks package as \"non auto-removable\".",
	  PKG_KEEP_CMD },
	{ "unkeep", "uk", "Marks package as \"auto-removable\".",
	  PKG_UNKEEP_CMD },
	{ "show-keep", "sk", "Display \"non auto-removable\" packages.",
	  PKG_SHKP_CMD },
	{ "search", "se", "Search for a package.",
	  PKG_SRCH_CMD },
	{ "clean", "cl", "Clean packages cache.",
	  PKG_CLEAN_CMD },
	{ "autoremove", "ar", "Autoremove orphan dependencies.",
	  PKG_AUTORM_CMD },
	{ NULL, NULL, 0 }
};
