/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import com.sun.prodreg.event.Subprocess;
import com.sun.prodreg.util.ExecuteCommand;
import com.sun.prodreg.util.JarLoader;
import com.sun.prodreg.util.Localizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;

public class TypedSystemSubprocess
extends Subprocess
implements Runnable {
    private String program_dir;
    private String jarMainClass = null;
    public static boolean debug = false;
    public static final int OPTION_JAR_MAINCLASS = 0;
    private String program;
    public static final int TYPE_JAR = 0;
    public static final int TYPE_CLASS = 1;
    public static final int TYPE_NATIVE = 2;
    public static final int MAX_LOG_LENGTH = 100;
    public static final int NOT_COMPLETE = -20;
    private int returnCode = -20;
    private int type = 2;

    public TypedSystemSubprocess(String program_dir, String program) {
        this(program_dir, program, 2);
        this.type = program.endsWith(".jar") ? 0 : (program.endsWith(".class") ? 1 : 2);
    }

    public TypedSystemSubprocess(String program_dir, String program, int type) {
        this.program_dir = program_dir;
        this.program = program;
        this.type = type;
    }

    public static String convertToString(String[] args) {
        if (args == null) {
            return "null";
        }
        String cmd = "";
        int i = 0;
        while (i < args.length) {
            cmd = i == 0 ? String.valueOf(cmd) + args[i] + " " : String.valueOf(cmd) + "'" + args[i] + "' ";
            ++i;
        }
        return cmd.trim();
    }

    public static String escape(char esc, String str) {
        StringBuffer result = new StringBuffer(str);
        int i = 0;
        while (i < result.length()) {
            if (result.charAt(i) == esc) {
                result.insert(i, '\\');
                i += 2;
                continue;
            }
            ++i;
        }
        return result.toString();
    }

    public int getResult() {
        return this.returnCode;
    }

    public void run() {
        switch (this.type) {
            case 1: {
                this.runJavaClass(this.program_dir, this.program);
                break;
            }
            case 0: {
                this.runJarFile(this.program_dir, this.program, this.jarMainClass);
                break;
            }
            case 2: {
                this.runNativeProgram(String.valueOf(this.program_dir) + File.separator + this.program);
                break;
            }
            default: {
                throw new IllegalStateException("Program Runner: invalid type:" + this.type);
            }
        }
    }

    private void runJarFile(String program_dir, String file, String mainClass) {
        String path = String.valueOf(program_dir) + File.separator + file;
        try {
            String[] arglist = new String[]{};
            new JarLoader(path, mainClass, arglist);
        }
        catch (Exception ex) {
            this.returnCode = -1;
            this.notifyListeners(-1, String.valueOf(path) + "::" + mainClass, Localizer.resolve("<L ProdRegResources.JarError>:" + ex.toString()));
        }
    }

    private void runJavaClass(String program_dir, String file) {
        file = file.substring(0, file.length() - ".class".length());
        String innercmd = "cd " + program_dir + "; " + System.getProperty("java.home") + "/bin/java " + file;
        this.runNativeProgram(innercmd);
    }

    private void runNativeProgram(String innercmd) {
        boolean deleteLog = true;
        String returnMessage = "";
        try {
            String log;
            while (new File(log = "/tmp/prodreg.runlog." + Math.random()).exists()) {
            }
            String return_log = "/tmp/prodreg.returnlog." + Math.random();
            while (new File(return_log = "/tmp/prodreg.returnlog." + Math.random()).exists()) {
            }
            if (debug) {
                System.out.println("TypedSystemSubprocess: log: " + log + " return log:" + return_log);
            }
            String wrapped_innercmd = String.valueOf(System.getProperty("prodreg.home")) + "/bin/exitwrapper '" + innercmd + "'" + " " + return_log + " ; sleep 2";
            String[] dtterm = new String[]{"/usr/dt/bin/dtterm", "-l", "-lf", log, "-e", "/usr/bin/ksh", "-c", wrapped_innercmd};
            if (debug) {
                System.out.println("TypedSystemSubprocess: -->" + ExecuteCommand.expandCommand(dtterm) + "<--");
            }
            ExecuteCommand c = new ExecuteCommand(dtterm);
            c.setLogFiles(new String[]{log});
            c.execute();
            FileInputStream fis = new FileInputStream(log);
            byte[] buf = new byte[1024];
            int nbytes = 1;
            StringBuffer sb = new StringBuffer();
            int lineCount = 0;
            while ((nbytes = fis.read(buf)) > 0) {
                if (++lineCount < 100) {
                    sb.append(new String(buf));
                    continue;
                }
                if (!deleteLog) continue;
                deleteLog = false;
                Object[] arg = new String[]{log};
                sb.append(Localizer.resolve("<L ProdRegResources.MoreLogInfo>: ", arg));
            }
            fis.close();
            if (debug) {
                System.out.println("Subprocess done: reading result from " + return_log);
            }
            BufferedReader bin = new BufferedReader(new FileReader(return_log));
            String line = bin.readLine();
            Integer i = new Integer(line);
            int result_code = i;
            bin.close();
            new File(return_log).delete();
            if (deleteLog) {
                new File(log).delete();
            }
            this.returnCode = result_code;
            returnMessage = sb.toString();
            if (debug) {
                System.out.println("Subprocess done: result: " + this.returnCode + " read from " + return_log);
            }
        }
        catch (Exception ex) {
            if (debug) {
                System.out.println("Subprocess done: FAILED reading result:" + ex.toString());
                ex.printStackTrace();
            }
            this.returnCode = -1;
            returnMessage = Localizer.resolve("<L ProdRegResources.ProcessError>:" + ex.toString());
        }
        this.notifyListeners(this.returnCode, innercmd, returnMessage);
    }

    public void setOption(int optionType, String option) {
        if (false) {
            this.jarMainClass = option;
        }
    }
}

