/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.licen;

import com.sun.forte.licen.SerialConstants;
import com.sun.forte.licen.SerialNumber;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class SNValidation
implements SerialConstants {
    static ResourceBundle snRes = ResourceBundle.getBundle("com.sun.forte.licen.SerInstallResource");
    private static int takeoffdays = 0;

    static void validateSer(SerialNumber serialNumber) {
        int n;
        boolean bl = false;
        if (serialNumber.getSerialNo() == null) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Serial_null"));
            return;
        }
        if (serialNumber.getSerialNo().length() != 26) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Serial_number"));
            return;
        }
        SNValidation.validateProdVersion(serialNumber);
        if (!serialNumber.getValid()) {
            return;
        }
        SNValidation.validateSerialInfo(serialNumber);
        if (!serialNumber.getValid()) {
            return;
        }
        boolean bl2 = SNValidation.isTrialSer(serialNumber.getSerialNo());
        if (serialNumber.getSerialNo().charAt(6) != '-' || serialNumber.getSerialNo().charAt(16) != '-') {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Dash_character"));
            return;
        }
        if (!(Character.isDigit(serialNumber.getSerialNo().charAt(17)) && Character.isDigit(serialNumber.getSerialNo().charAt(18)) && Character.isDigit(serialNumber.getSerialNo().charAt(19)) && Character.isDigit(serialNumber.getSerialNo().charAt(20)) && Character.isDigit(serialNumber.getSerialNo().charAt(21)) && Character.isDigit(serialNumber.getSerialNo().charAt(22)) && Character.isDigit(serialNumber.getSerialNo().charAt(23)) && Character.isDigit(serialNumber.getSerialNo().charAt(24)) && Character.isDigit(serialNumber.getSerialNo().charAt(25)))) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Not_a_valid"));
            return;
        }
        int n2 = SNValidation.generateCheck(serialNumber.getSerialNo());
        if (n2 != (n = new Integer(serialNumber.getSerialNo().substring(24)).intValue())) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Not_a_valid"));
            return;
        }
        if (bl2) {
            if (SNValidation.isExpired(serialNumber.getSerialNo())) {
                serialNumber.setValid(false);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy");
                serialNumber.setStatusMsg(snRes.getString("Error_This_serial") + simpleDateFormat.format(SNValidation.getExpireDate(serialNumber.getSerialNo())) + snRes.getString("URL_serial_number"));
            } else {
                serialNumber.setValid(true);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy");
                serialNumber.setStatusMsg(snRes.getString("This_serial_number") + simpleDateFormat.format(SNValidation.getExpireDate(serialNumber.getSerialNo())));
            }
        } else {
            serialNumber.setValid(true);
            serialNumber.setStatusMsg(snRes.getString("Valid_permanent"));
        }
    }

    static void generateTrialNumber(SerialNumber serialNumber) {
        int n = 0;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        if (serialNumber.getSerialNo() == null || serialNumber.getSerialNo().length() != 16) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_prefix"));
            return;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat.setMaximumIntegerDigits(7);
        numberFormat.setMinimumIntegerDigits(7);
        numberFormat.setGroupingUsed(false);
        numberFormat2.setMaximumIntegerDigits(2);
        numberFormat2.setMinimumIntegerDigits(2);
        String string2 = serialNumber.getSerialNo().substring(10, 11);
        if (SNValidation.checkCode(string2, "A B C D E F G P") && !string2.equals("P")) {
            n2 = SerialConstants.SN_DURATION_TIMES[string2.charAt(0) - 65];
            n3 = SNValidation.getExpireCode(n2);
            string = serialNumber.getSerialNo() + '-' + numberFormat.format(n3);
            n = SNValidation.generateCheck(string);
            string = string + numberFormat2.format(n);
            serialNumber.setSerialNo(string);
        } else {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_prefix"));
        }
    }

    static void validateSerialInfo(SerialNumber serialNumber) {
        String string = serialNumber.getSerialNo();
        serialNumber.setValid(true);
        if (!SNValidation.checkCode(string.substring(7, 8), "9 A B C D E F G H J K L M N P Q R S")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(8, 9), "S I L J N W B H V E 9")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(9, 10), "1 2 3 9")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(10, 11), "A B C D E F G P")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(11, 12), "O E K I L R P D C T G 9")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(12, 13), "I X Y L T C E F U G H J K N S A M B D")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(13, 14), "S E 9")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(14, 15), "N U T S 9")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
        if (!SNValidation.checkCode(string.substring(15, 16), "U E S G 9")) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Invalid_serial"));
            return;
        }
    }

    static void validateProdVersion(SerialNumber serialNumber) {
        String string = serialNumber.getSerialNo().substring(0, 3);
        String string2 = serialNumber.getSerialNo().substring(3, 6);
        serialNumber.setValid(true);
        if (!(Character.isDigit(string2.charAt(0)) && Character.isDigit(string2.charAt(1)) && Character.isLetterOrDigit(string2.charAt(2)) || SNValidation.checkCode(string2, "SUB MNT REN SUS SUX SUC SUM SUP"))) {
            serialNumber.setValid(false);
            serialNumber.setStatusMsg(snRes.getString("Error_Illegal_version"));
        }
    }

    static int generateCheck(String string) {
        int n = SNValidation.charToInt(string.charAt(0)) + 1;
        int n2 = SNValidation.charToInt(string.charAt(1)) + 1;
        int n3 = SNValidation.charToInt(string.charAt(2)) + 1;
        int n4 = string.charAt(3) - 48;
        int n5 = string.charAt(4) - 48;
        int n6 = string.charAt(5) - 48;
        int n7 = SNValidation.charToInt(string.charAt(7));
        int n8 = SNValidation.charToInt(string.charAt(8));
        int n9 = SNValidation.charToInt(string.charAt(9));
        int n10 = SNValidation.charToInt(string.charAt(10));
        int n11 = SNValidation.charToInt(string.charAt(11));
        int n12 = SNValidation.charToInt(string.charAt(12));
        int n13 = SNValidation.charToInt(string.charAt(13));
        int n14 = SNValidation.charToInt(string.charAt(14));
        int n15 = SNValidation.charToInt(string.charAt(15));
        int n16 = n + (27 - n2) + n3;
        n16 += n4 + (9 - n5) + n6;
        n16 += n7 + (13 - n8) + n9;
        n16 -= n10 + (27 - n11) + n12;
        n16 += n13 + (13 - n14) + n15;
        n16 += string.charAt(17) - 48;
        n16 += 9 - (string.charAt(18) - 48);
        n16 += string.charAt(19) - 48;
        n16 += 9 - (string.charAt(20) - 48);
        n16 += string.charAt(21) - 48;
        n16 += 9 - (string.charAt(22) - 48);
        if ((n16 += string.charAt(23) - 48) < 0) {
            n16 *= -1;
        }
        return n16 % 100;
    }

    static boolean isExpired(String string) {
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        l2 = System.currentTimeMillis() / 3600000L;
        String string2 = string.substring(17, 24);
        l = new Integer(string2).intValue();
        if (l < l2) {
            bl = true;
        }
        return bl;
    }

    static Date getExpireDate(String string) {
        boolean bl = false;
        long l = 0L;
        String string2 = string.substring(17, 24);
        l = new Integer(string2).intValue();
        return new Date(l * 60L * 60L * 1000L);
    }

    static boolean checkCode(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    static int charToInt(char c) {
        int n = -1;
        int n2 = -1;
        if (Character.isDigit(c)) {
            n2 = Character.getNumericValue(c);
        } else if (Character.isLetter(c) && Character.isUpperCase(c)) {
            n2 = Character.getNumericValue(c) - Character.getNumericValue('A');
        }
        if (c <= 'Z' && c >= 'A') {
            n = c - 65;
        } else if (c <= '9' && c >= '0') {
            n = c - 48;
        }
        if (n != n2) {
            System.out.println("Error: in charToInt(), retval:" + n2 + "  temp:" + n);
            System.exit(1);
        }
        return n;
    }

    static boolean isTrialSer(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        if (string.length() != 26) {
            return bl;
        }
        if (!string.substring(10, 11).equals("P")) {
            bl = true;
        }
        return bl;
    }

    static boolean isProdSpec(String string) {
        boolean bl = false;
        if (Character.isDigit(string.charAt(3)) && Character.isDigit(string.charAt(4)) && Character.isLetter(string.charAt(5))) {
            bl = true;
        }
        return bl;
    }

    static int getExpireCode(int n) {
        int n2 = 0;
        n2 = (int)(System.currentTimeMillis() / 3600000L) + 24 * n + 12 - takeoffdays * 24;
        return n2;
    }
}

