/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class WriteTagCheck
extends Check {
    private Pattern mTagRE;
    private Pattern mTagFormatRE;
    private String mTag;
    private String mTagFormat;
    private SeverityLevel mTagSeverityLevel = SeverityLevel.INFO;

    public void setTag(String aTag) throws ConversionException {
        try {
            this.mTag = aTag;
            this.mTagRE = Utils.getPattern(aTag + "\\s+(.*$)");
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aTag, (Throwable)e);
        }
    }

    public void setTagFormat(String aFormat) throws ConversionException {
        try {
            this.mTagFormat = aFormat;
            this.mTagFormatRE = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public final void setTagSeverity(String aSeverity) {
        this.mTagSeverityLevel = SeverityLevel.getInstance(aSeverity);
    }

    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 155, 161};
    }

    public void visitToken(DetailAST aAST) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
        if (cmt == null) {
            this.log(lineNo, "type.missingTag", this.mTag);
        } else {
            this.checkTag(lineNo, cmt.getText(), this.mTag, this.mTagRE, this.mTagFormatRE, this.mTagFormat);
        }
    }

    private void checkTag(int aLineNo, String[] aComment, String aTag, Pattern aTagRE, Pattern aFormatRE, String aFormat) {
        if (aTagRE == null) {
            return;
        }
        int tagCount = 0;
        for (int i = 0; i < aComment.length; ++i) {
            String s = aComment[i];
            Matcher matcher = aTagRE.matcher(s);
            if (!matcher.find()) continue;
            ++tagCount;
            int contentStart = matcher.start(1);
            String content = s.substring(contentStart);
            if (aFormatRE != null && !aFormatRE.matcher(content).find()) {
                this.log(aLineNo + i - aComment.length, "type.tagFormat", aTag, aFormat);
                continue;
            }
            this.logTag(aLineNo + i - aComment.length, aTag, content);
        }
        if (tagCount == 0) {
            this.log(aLineNo, "type.missingTag", aTag);
        }
    }

    protected final void logTag(int aLine, String aTag, String aTagValue) {
        String originalSeverity = this.getSeverity();
        this.setSeverity(this.mTagSeverityLevel.getName());
        this.log(aLine, "javadoc.writeTag", aTag, aTagValue);
        this.setSeverity(originalSeverity);
    }
}

