/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.converter.schema;

import org.apache.directory.api.converter.schema.SchemaElementImpl;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.UsageEnum;

public class AttributeTypeHolder
extends SchemaElementImpl {
    private boolean singleValue = false;
    private boolean collective = false;
    private boolean noUserModification = false;
    private String superior;
    private String equality;
    private String ordering;
    private String substr;
    private String syntax;
    private long oidLen = -1L;
    private UsageEnum usage = UsageEnum.USER_APPLICATIONS;

    public AttributeTypeHolder(String oid) {
        this.oid = oid;
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public void setSingleValue(boolean singleValue) {
        this.singleValue = singleValue;
    }

    public boolean isCollective() {
        return this.collective;
    }

    public void setCollective(boolean collective) {
        this.collective = collective;
    }

    public boolean isNoUserModification() {
        return this.noUserModification;
    }

    public void setNoUserModification(boolean noUserModification) {
        this.noUserModification = noUserModification;
    }

    public String getSuperior() {
        return this.superior;
    }

    public void setSuperior(String superior) {
        this.superior = superior;
    }

    public String getEquality() {
        return this.equality;
    }

    public void setEquality(String equality) {
        this.equality = equality;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public String getSubstr() {
        return this.substr;
    }

    public void setSubstr(String substr) {
        this.substr = substr;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public UsageEnum getUsage() {
        return this.usage;
    }

    public void setUsage(UsageEnum usage) {
        this.usage = usage;
    }

    public long getOidLen() {
        return this.oidLen;
    }

    public void setOidLen(long oidLen) {
        this.oidLen = oidLen;
    }

    @Override
    public String toLdif(String schemaName) throws LdapException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.schemaToLdif(schemaName, "metaAttributeType"));
        if (this.superior != null) {
            sb.append("m-supAttributeType: ").append(this.superior).append('\n');
        }
        if (this.equality != null) {
            sb.append("m-equality: ").append(this.equality).append('\n');
        }
        if (this.ordering != null) {
            sb.append("m-ordering: ").append(this.ordering).append('\n');
        }
        if (this.substr != null) {
            sb.append("m-substr: ").append(this.substr).append('\n');
        }
        if (this.syntax != null) {
            sb.append("m-syntax: ").append(this.syntax).append('\n');
            if (this.oidLen != -1L) {
                sb.append("m-length: ").append(this.oidLen).append('\n');
            }
        }
        if (this.singleValue) {
            sb.append("m-singleValue: TRUE\n");
        }
        if (this.collective) {
            sb.append("m-collective: TRUE\n");
        }
        if (this.noUserModification) {
            sb.append("m-noUserModification: TRUE\n");
        }
        if (this.usage != UsageEnum.USER_APPLICATIONS) {
            sb.append("m-usage: ").append(this.usage.render()).append('\n');
        }
        if (this.extensions.size() != 0) {
            this.extensionsToLdif("m-extensionAttributeType");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getOid();
    }

    @Override
    public String dnToLdif(String schemaName) throws LdapException {
        StringBuilder sb = new StringBuilder();
        String dn = "m-oid=" + this.oid + ", " + "ou=attributetypes" + ", cn=" + Rdn.escapeValue(schemaName) + ", ou=schema";
        DefaultEntry entry = new DefaultEntry(dn);
        sb.append(LdifUtils.convertToLdif(entry));
        return sb.toString();
    }
}

