/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.filters.IntFilter;

class IntRangeFilter
implements IntFilter {
    private static final int HASH_MULT = 29;
    private final Integer mLowerBound;
    private final Integer mUpperBound;

    public IntRangeFilter(int aLowerBound, int aUpperBound) {
        this.mLowerBound = aLowerBound;
        this.mUpperBound = aUpperBound;
    }

    @Override
    public boolean accept(int aInt) {
        return this.mLowerBound.compareTo(aInt) <= 0 && this.mUpperBound.compareTo(aInt) >= 0;
    }

    public int hashCode() {
        return 29 * this.mLowerBound + this.mUpperBound;
    }

    public boolean equals(Object aObject) {
        if (aObject instanceof IntRangeFilter) {
            IntRangeFilter other = (IntRangeFilter)aObject;
            return this.mLowerBound.equals(other.mLowerBound) && this.mUpperBound.equals(other.mUpperBound);
        }
        return false;
    }

    public String toString() {
        return "IntRangeFilter[" + this.mLowerBound + "," + this.mUpperBound + "]";
    }
}

