/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.regex.Matcher;

public class SuppressWarningsCheck
extends AbstractFormatCheck {
    private static final String SUPPRESS_WARNINGS = "SuppressWarnings";
    private static final String FQ_SUPPRESS_WARNINGS = "java.lang.SuppressWarnings";

    public SuppressWarningsCheck() {
        super("^$|^\\s+$");
    }

    @Override
    public final int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{14, 15, 158, 161, 165, 159, 21, 10, 9, 8};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST annotation = this.getSuppressWarnings(aAST);
        if (annotation == null) {
            return;
        }
        DetailAST warningHolder = this.findWarningsHolder(annotation);
        DetailAST warning = warningHolder.findFirstToken(29);
        if (warning == null) {
            this.logMatch(warningHolder.getLineNo(), warningHolder.getColumnNo(), "");
            return;
        }
        while (warning != null) {
            if (warning.getType() == 29) {
                DetailAST fChild = warning.getFirstChild();
                if (fChild.getType() == 141) {
                    String warningText = this.removeQuotes(warning.getFirstChild().getText());
                    this.logMatch(warning.getLineNo(), warning.getColumnNo(), warningText);
                } else if (fChild.getType() == 111) {
                    this.walkConditional(fChild);
                } else assert (false) : "Should never get here, type: " + fChild.getType() + " text: " + fChild.getText();
            }
            warning = warning.getNextSibling();
        }
    }

    private DetailAST getSuppressWarnings(DetailAST aAST) {
        DetailAST annotation = AnnotationUtility.getAnnotation(aAST, SUPPRESS_WARNINGS);
        return annotation != null ? annotation : AnnotationUtility.getAnnotation(aAST, FQ_SUPPRESS_WARNINGS);
    }

    private void logMatch(int aLineNo, int aColNum, String aWarningText) {
        Matcher matcher = this.getRegexp().matcher(aWarningText);
        if (matcher.matches()) {
            this.log(aLineNo, aColNum, "suppressed.warning.not.allowed", aWarningText);
        }
    }

    private DetailAST findWarningsHolder(DetailAST aAnnotation) {
        DetailAST annValuePair = aAnnotation.findFirstToken(164);
        DetailAST annArrayInit = annValuePair != null ? annValuePair.findFirstToken(166) : aAnnotation.findFirstToken(166);
        if (annArrayInit != null) {
            return annArrayInit;
        }
        return aAnnotation;
    }

    private String removeQuotes(String aWarning) {
        assert (aWarning != null) : "the aWarning was null";
        assert (aWarning.charAt(0) == '\"');
        assert (aWarning.charAt(aWarning.length() - 1) == '\"');
        return aWarning.substring(1, aWarning.length() - 1);
    }

    private void walkConditional(DetailAST aCond) {
        if (aCond.getType() != 111) {
            String warningText = this.removeQuotes(aCond.getText());
            this.logMatch(aCond.getLineNo(), aCond.getColumnNo(), warningText);
            return;
        }
        this.walkConditional(this.getCondLeft(aCond));
        this.walkConditional(this.getCondRight(aCond));
    }

    private DetailAST getCondLeft(DetailAST aCond) {
        DetailAST colon = aCond.findFirstToken(83);
        return colon.getPreviousSibling();
    }

    private DetailAST getCondRight(DetailAST aCond) {
        DetailAST colon = aCond.findFirstToken(83);
        return colon.getNextSibling();
    }
}

