/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueContainer;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncRequestValueGrammar
extends AbstractGrammar<SyncRequestValueContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SyncRequestValueGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<SyncRequestValueContainer> instance = new SyncRequestValueGrammar();

    private SyncRequestValueGrammar() {
        this.setName(SyncRequestValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncRequestValueStatesEnum.LAST_SYNC_REQUEST_VALUE_STATE.ordinal()][256];
        this.transitions[SyncRequestValueStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SyncRequestValueStatesEnum.START_STATE, (Enum)SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE, (Enum)SyncRequestValueStatesEnum.MODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl mode"){

            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int mode = IntegerDecoder.parse((BerValue)value, (int)SynchronizationModeEnum.UNUSED.getValue(), (int)SynchronizationModeEnum.REFRESH_AND_PERSIST.getValue());
                    SynchronizationModeEnum modeEnum = SynchronizationModeEnum.getSyncMode((int)mode);
                    if (IS_DEBUG) {
                        LOG.debug("Mode = " + modeEnum);
                    }
                    container.getSyncRequestValueControl().setMode(modeEnum);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04028, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncRequestValueStatesEnum.MODE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncRequestValueStatesEnum.MODE_STATE, (Enum)SyncRequestValueStatesEnum.COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl cookie"){

            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + Strings.dumpBytes((byte[])cookie));
                }
                container.getSyncRequestValueControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncRequestValueStatesEnum.MODE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncRequestValueStatesEnum.MODE_STATE, (Enum)SyncRequestValueStatesEnum.RELOAD_HINT_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl reloadHint flag"){

            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse((BerValue)value);
                    if (IS_DEBUG) {
                        LOG.debug("reloadHint = " + reloadHint);
                    }
                    container.getSyncRequestValueControl().setReloadHint(reloadHint);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04029, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncRequestValueStatesEnum.COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncRequestValueStatesEnum.COOKIE_STATE, (Enum)SyncRequestValueStatesEnum.RELOAD_HINT_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl reloadHint flag"){

            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse((BerValue)value);
                    if (IS_DEBUG) {
                        LOG.debug("reloadHint = " + reloadHint);
                    }
                    container.getSyncRequestValueControl().setReloadHint(reloadHint);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04029, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static Grammar<SyncRequestValueContainer> getInstance() {
        return instance;
    }
}

