/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import java.util.BitSet;

public class IndentLevel {
    private final BitSet mLevels = new BitSet();

    public IndentLevel(int aIndent) {
        this.mLevels.set(aIndent);
    }

    public IndentLevel(IndentLevel aBase, int ... aOffsets) {
        BitSet src = aBase.mLevels;
        int i = src.nextSetBit(0);
        while (i >= 0) {
            for (int offset : aOffsets) {
                this.mLevels.set(i + offset);
            }
            i = src.nextSetBit(i + 1);
        }
    }

    public final boolean isMultiLevel() {
        return this.mLevels.cardinality() > 1;
    }

    public boolean accept(int aIndent) {
        return this.mLevels.get(aIndent);
    }

    public boolean gt(int aIndent) {
        return this.mLevels.nextSetBit(0) > aIndent;
    }

    public void addAcceptedIndent(int aIndent) {
        this.mLevels.set(aIndent);
    }

    public void addAcceptedIndent(IndentLevel aIndent) {
        this.mLevels.or(aIndent.mLevels);
    }

    public int getFirstIndentLevel() {
        return this.mLevels.nextSetBit(0);
    }

    public int getLastIndentLevel() {
        return this.mLevels.length() - 1;
    }

    public String toString() {
        if (this.mLevels.cardinality() == 1) {
            return String.valueOf(this.mLevels.nextSetBit(0));
        }
        StringBuilder sb = new StringBuilder();
        int i = this.mLevels.nextSetBit(0);
        while (i >= 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(i);
            i = this.mLevels.nextSetBit(i + 1);
        }
        return sb.toString();
    }
}

