/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractNestedDepthCheck;

public final class NestedIfDepthCheck
extends AbstractNestedDepthCheck {
    private static final int DEFAULT_MAX = 1;

    public NestedIfDepthCheck() {
        super(1);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{85};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 85: {
                this.visitLiteralIf(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 85: {
                this.leaveLiteralIf(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitLiteralIf(DetailAST aIf) {
        if (!CheckUtils.isElseIf(aIf)) {
            this.nestIn(aIf, "nested.if.depth");
        }
    }

    private void leaveLiteralIf(DetailAST aIf) {
        if (!CheckUtils.isElseIf(aIf)) {
            this.nestOut();
        }
    }
}

