/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IOUtil$ {
    public static IOUtil$ MODULE$;

    static {
        new IOUtil$();
    }

    public <Resource extends AutoCloseable, U> U withResource(Resource resource, Function1<Resource, U> body) {
        Object object;
        try {
            object = body.apply(resource);
        }
        finally {
            resource.close();
        }
        return (U)object;
    }

    public <U> U withTempFile(String name, String suffix, String dir, Function1<File, U> body) {
        Object object;
        File d = new File(dir);
        d.mkdirs();
        File f = File.createTempFile(name, suffix, d);
        try {
            object = body.apply((Object)f);
        }
        finally {
            f.delete();
        }
        return (U)object;
    }

    public <U> String withTempFile$default$2() {
        return ".tmp";
    }

    public <U> String withTempFile$default$3() {
        return "target";
    }

    public int unusedPort() {
        return BoxesRunTime.unboxToInt(this.withResource(new ServerSocket(0), (Function1 & Serializable & scala.Serializable)socket -> BoxesRunTime.boxToInteger((int)socket.getLocalPort())));
    }

    public Option<File> findPath(String path) {
        return this.findPath(new File(path));
    }

    public Option<File> findPath(File path) {
        File defaultPath;
        return path.exists() ? new Some((Object)path) : ((defaultPath = new File(new File(System.getProperty("prog.home", "")), path.getPath())).exists() ? new Some((Object)defaultPath) : None$.MODULE$);
    }

    public String readAsString(String resourcePath) {
        Predef$.MODULE$.require(resourcePath != null, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"resourcePath is null"})).s((Seq)Nil$.MODULE$));
        Option<File> file = this.findPath(new File(resourcePath));
        if (file.isEmpty()) {
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourcePath})));
        }
        return this.readAsString(new FileInputStream((File)file.get()));
    }

    public String readAsString(InputStream in) {
        return (String)this.readFully(in, (Function1 & Serializable & scala.Serializable)data -> new String((byte[])data, StandardCharsets.UTF_8));
    }

    public <U> U readFully(InputStream in, Function1<byte[], U> f) {
        byte[] byteArray = (byte[])this.withResource(new ByteArrayOutputStream(), (Function1 & Serializable & scala.Serializable)b -> {
            byte[] buf = new byte[8192];
            MODULE$.withResource(in, (Function1 & Serializable & scala.Serializable)src -> {
                IOUtil$.$anonfun$readFully$2(buf, b, src);
                return BoxedUnit.UNIT;
            });
            return b.toByteArray();
        });
        return (U)f.apply((Object)byteArray);
    }

    public static final /* synthetic */ void $anonfun$readFully$2(byte[] buf$1, ByteArrayOutputStream b$1, InputStream src) {
        int readBytes = 0;
        while ((readBytes = src.read(buf$1)) != -1) {
            b$1.write(buf$1, 0, readBytes);
        }
    }

    private IOUtil$() {
        MODULE$ = this;
    }
}

