/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class SourceMatcher
implements Matcher {
    private static final boolean DEBUG = SystemProperties.getBoolean("filter.debug");
    private final NameMatch fileName;

    public String toString() {
        return "Source(file=\"" + this.fileName.getValue() + "\")";
    }

    public SourceMatcher(String fileName) {
        this.fileName = new NameMatch(fileName);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        if (primaryClassAnnotation == null) {
            return false;
        }
        String bugFileName = primaryClassAnnotation.getSourceFileName();
        if (bugFileName == null || bugFileName.isEmpty()) {
            return false;
        }
        boolean result = this.fileName.match(bugFileName);
        if (DEBUG) {
            System.out.println("Matching " + bugFileName + " with " + this.fileName + ", result = " + result);
        }
        return result;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.fileName.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Source", attributes);
    }
}

