/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class SynchronizationOnSharedBuiltinConstant
extends OpcodeStackDetector {
    final Set<String> badSignatures;
    final BugAccumulator bugAccumulator;
    private static final Pattern identified = Pattern.compile("\\p{Alnum}+");
    BugInstance pendingBug;
    int monitorEnterPC;
    String syncSignature;
    boolean isSyncOnBoolean;

    public SynchronizationOnSharedBuiltinConstant(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.badSignatures = new HashSet<String>();
        this.badSignatures.addAll(Arrays.asList("Ljava/lang/Boolean;", "Ljava/lang/Double;", "Ljava/lang/Float;", "Ljava/lang/Byte;", "Ljava/lang/Character;", "Ljava/lang/Short;", "Ljava/lang/Integer;", "Ljava/lang/Long;"));
    }

    private static boolean newlyConstructedObject(OpcodeStack.Item item) {
        XMethod method = item.getReturnValueOf();
        if (method == null) {
            return false;
        }
        return "<init>".equals(method.getName());
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.accumulateBug();
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 194: {
                OpcodeStack.Item top = this.stack.getStackItem(0);
                if (this.pendingBug != null) {
                    this.accumulateBug();
                }
                this.monitorEnterPC = this.getPC();
                this.syncSignature = top.getSignature();
                this.isSyncOnBoolean = false;
                Object constant = top.getConstant();
                if ("Ljava/lang/String;".equals(this.syncSignature) && constant instanceof String) {
                    this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_SHARED_CONSTANT", 2).addClassAndMethod(this);
                    String value = (String)constant;
                    if (!identified.matcher(value).matches()) break;
                    this.pendingBug.addString(value).describe("STRING_CONSTANT");
                    break;
                }
                if (!this.badSignatures.contains(this.syncSignature)) break;
                this.isSyncOnBoolean = "Ljava/lang/Boolean;".equals(this.syncSignature);
                XField field = top.getXField();
                FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                OpcodeStack.Item summary = fieldSummary.getSummary(field);
                int priority = 2;
                if (this.isSyncOnBoolean) {
                    --priority;
                }
                if (SynchronizationOnSharedBuiltinConstant.newlyConstructedObject(summary)) {
                    this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_UNSHARED_BOXED_PRIMITIVE", 2).addClassAndMethod(this).addType(this.syncSignature).addOptionalField(field).addOptionalLocalVariable(this, top);
                    break;
                }
                if (this.isSyncOnBoolean) {
                    this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_BOOLEAN", priority).addClassAndMethod(this).addOptionalField(field).addOptionalLocalVariable(this, top);
                    break;
                }
                this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_BOXED_PRIMITIVE", priority).addClassAndMethod(this).addType(this.syncSignature).addOptionalField(field).addOptionalLocalVariable(this, top);
                break;
            }
            case 195: {
                this.accumulateBug();
                break;
            }
        }
    }

    private void accumulateBug() {
        if (this.pendingBug == null) {
            return;
        }
        this.bugAccumulator.accumulateBug(this.pendingBug, SourceLineAnnotation.fromVisitedInstruction(this, this.monitorEnterPC));
        this.pendingBug = null;
    }
}

