/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamFactory;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ObjectType;

public class InstanceFieldLoadStreamFactory
implements StreamFactory {
    private final String streamBaseClass;
    private String bugPatternType;

    public InstanceFieldLoadStreamFactory(String streamBaseClass) {
        this.streamBaseClass = streamBaseClass;
    }

    public InstanceFieldLoadStreamFactory setBugPatternType(String bugPatternType) {
        this.bugPatternType = bugPatternType;
        return this;
    }

    @Override
    public Stream createStream(Location location, ObjectType type, ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
        Instruction ins = location.getHandle().getInstruction();
        if (ins.getOpcode() != 180) {
            return null;
        }
        String fieldClass = type.getClassName();
        try {
            if (fieldClass.startsWith("[")) {
                return null;
            }
            if (!Hierarchy.isSubtype(fieldClass, this.streamBaseClass)) {
                return null;
            }
            Stream stream = new Stream(location, fieldClass, this.streamBaseClass);
            stream.setIsOpenOnCreation(true);
            stream.setOpenLocation(location);
            if (this.bugPatternType != null) {
                stream.setInteresting(this.bugPatternType);
            }
            return stream;
        }
        catch (ClassNotFoundException e) {
            lookupFailureCallback.reportMissingClass(e);
            return null;
        }
    }
}

