/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Code;

public class FindComparatorProblems
extends OpcodeStackDetector {
    private static final MethodDescriptor FLOAT_DESCRIPTOR = new MethodDescriptor("java/lang/Float", "compare", "(FF)I", true);
    private static final MethodDescriptor DOUBLE_DESCRIPTOR = new MethodDescriptor("java/lang/Double", "compare", "(DD)I", true);
    private boolean isComparator;
    private int lastEmptyStackPC;
    private List<int[]> twoDoublesInStack;
    private final BugAccumulator accumulator;

    public FindComparatorProblems(BugReporter reporter) {
        this.accumulator = new BugAccumulator(reporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        boolean comparator = Subtypes2.instanceOf(classContext.getClassDescriptor(), "java.util.Comparator");
        boolean comparable = Subtypes2.instanceOf(classContext.getClassDescriptor(), "java.lang.Comparable");
        this.isComparator = comparator;
        if (comparator || comparable) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public boolean shouldVisitCode(Code obj) {
        return !this.getMethodDescriptor().isStatic() && (this.isComparator && this.getMethodName().equals("compare") && this.getMethodSig().endsWith(")I") || this.getMethodName().equals("compareTo") && this.getMethodSig().equals("(L" + this.getClassName() + ";)I"));
    }

    @Override
    public void visit(Code obj) {
        this.twoDoublesInStack = new ArrayList<int[]>();
        this.lastEmptyStackPC = 0;
        super.visit(obj);
        this.accumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item top;
        Object o;
        if (this.getStack().getStackDepth() == 0) {
            this.lastEmptyStackPC = this.getPC();
        }
        if ((seen == 152 || seen == 151 || seen == 149 || seen == 150) && this.getStack().getStackDepth() == 2) {
            int[] startEnd = new int[]{this.lastEmptyStackPC, this.getPC()};
            Iterator<int[]> iterator = this.twoDoublesInStack.iterator();
            while (iterator.hasNext()) {
                int[] oldStartEnd = iterator.next();
                if (!this.codeEquals(oldStartEnd, startEnd)) continue;
                OpcodeStack.Item item1 = this.getStack().getStackItem(0);
                OpcodeStack.Item item2 = this.getStack().getStackItem(1);
                this.accumulator.accumulateBug(new BugInstance("CO_COMPARETO_INCORRECT_FLOATING", 2).addClassAndMethod(this).addType(item1.getSignature()).addMethod(item1.getSignature().equals("D") ? DOUBLE_DESCRIPTOR : FLOAT_DESCRIPTOR).describe("SHOULD_CALL").addValueSource(item1, this).addValueSource(item2, this), this);
                iterator.remove();
                return;
            }
            this.twoDoublesInStack.add(startEnd);
        }
        if (seen == 172 && (o = (top = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (Integer)o == Integer.MIN_VALUE) {
            this.accumulator.accumulateBug(new BugInstance(this, "CO_COMPARETO_RESULTS_MIN_VALUE", 2).addClassAndMethod(this), this);
        }
    }

    private boolean codeEquals(int[] oldStartEnd, int[] startEnd) {
        int end = startEnd[1];
        int start = startEnd[0];
        int oldEnd = oldStartEnd[1];
        int oldStart = oldStartEnd[0];
        if (end - start != oldEnd - oldStart) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            if (this.getCodeByte(i) == this.getCodeByte(i - start + oldStart)) continue;
            return false;
        }
        return true;
    }
}

