/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Collections;
import org.apache.bcel.classfile.Code;

public class AtomicityProblem
extends OpcodeStackDetector {
    int priority = 5;
    int lastQuestionableCheckTarget = -1;
    private final BugReporter bugReporter;
    static final boolean DEBUG = false;

    public AtomicityProblem(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (AtomicityProblem.hasInterestingClass(classContext.getJavaClass().getConstantPool(), Collections.singleton("java/util/concurrent/ConcurrentHashMap"))) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Code obj) {
        this.lastQuestionableCheckTarget = -1;
        super.visit(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 153: 
            case 154: {
                OpcodeStack.Item top = this.stack.getStackItem(0);
                XMethod m = top.getReturnValueOf();
                if (m == null || !"java.util.concurrent.ConcurrentHashMap".equals(m.getClassName()) || !"containsKey".equals(m.getName())) break;
                this.lastQuestionableCheckTarget = this.getBranchTarget();
                if (seen == 153) {
                    this.priority = 3;
                    break;
                }
                if (seen != 154) break;
                this.priority = 2;
                break;
            }
            case 198: 
            case 199: {
                OpcodeStack.Item top = this.stack.getStackItem(0);
                XMethod m = top.getReturnValueOf();
                if (m == null || !"java.util.concurrent.ConcurrentHashMap".equals(m.getClassName()) || !"get".equals(m.getName())) break;
                this.lastQuestionableCheckTarget = this.getBranchTarget();
                if (seen == 198) {
                    this.priority = 3;
                    break;
                }
                if (seen != 199) break;
                this.priority = 2;
                break;
            }
            case 182: 
            case 185: {
                if (!"java.util.concurrent.ConcurrentHashMap".equals(this.getDottedClassConstantOperand())) break;
                String methodName = this.getNameConstantOperand();
                XClass xClass = this.getXClassOperand();
                if (xClass == null || !"put".equals(methodName) || this.getPC() >= this.lastQuestionableCheckTarget || this.lastQuestionableCheckTarget == -1) break;
                this.bugReporter.reportBug(new BugInstance(this, "AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION", this.priority).addClassAndMethod(this).addType(xClass.getClassDescriptor()).addCalledMethod(this).addSourceLine(this));
                break;
            }
        }
    }
}

